/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.connector.samplefile.impl;

import com.sap.idm.vds.connector.samplefile.impl.FileBasicOperations;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileAdd {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int add(String path, String name, String content, boolean isDNDirectory) {
        try {
            if (!path.endsWith("\\")) {
                path = String.valueOf(path) + "\\";
            }
            File file = new File(String.valueOf(path) + name);
            File dir = new File(path);
            if (!dir.isDirectory()) {
                return 7;
            }
            if (file.exists()) {
                return 6;
            }
            if (isDNDirectory) {
                if (file.mkdir()) return 0;
                return 9;
            }
            if (!file.createNewFile()) {
                return 9;
            }
            RandomAccessFile fileRA = new RandomAccessFile(String.valueOf(path) + name, "rw");
            FileBasicOperations operations = new FileBasicOperations(fileRA);
            operations.addAtEnd(content);
            fileRA.close();
            return 0;
        }
        catch (IOException e) {
            return 9;
        }
    }
}

