/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.sec;

import com.sap.idm.vds.sec.IllegalBase64Exception;
import java.util.Arrays;

public final class Base64 {
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] IA = new int[256];

    private Base64() {
    }

    public static char[] encodeToChar(byte[] aArray, boolean aSplitLine, boolean aEqualsPad) {
        int sLen;
        int n = sLen = aArray != null ? aArray.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (aSplitLine ? (cCnt - 1) / 76 << 1 : 0);
        int left = sLen - eLen;
        int resLen = dLen;
        if (!aEqualsPad && left > 0) {
            resLen = left == 2 ? --resLen : (resLen -= 2);
        }
        char[] dArr = new char[resLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i = (aArray[s++] & 0xFF) << 16 | (aArray[s++] & 0xFF) << 8 | aArray[s++] & 0xFF;
            dArr[d++] = CA[i >>> 18 & 0x3F];
            dArr[d++] = CA[i >>> 12 & 0x3F];
            dArr[d++] = CA[i >>> 6 & 0x3F];
            dArr[d++] = CA[i & 0x3F];
            if (!aSplitLine || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        if (left > 0) {
            int i = (aArray[eLen] & 0xFF) << 10 | (left == 2 ? (aArray[sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = CA[i >> 12];
            dArr[dLen - 3] = CA[i >>> 6 & 0x3F];
            if (aEqualsPad) {
                dArr[dLen - 2] = left == 2 ? CA[i & 0x3F] : 61;
                dArr[dLen - 1] = 61;
            } else if (left == 2) {
                dArr[dLen - 2] = CA[i & 0x3F];
            }
        }
        return dArr;
    }

    public static byte[] decode(char[] aArray) throws IllegalBase64Exception {
        int sLen;
        int n = sLen = aArray != null ? aArray.length : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int sepCnt = 0;
        for (int i = 0; i < sLen; ++i) {
            if (IA[aArray[i]] >= 0) continue;
            ++sepCnt;
            if (IA[aArray[i]] >= -1) continue;
            throw new IllegalBase64Exception("illegal Base64 character:'" + aArray[i]);
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && IA[aArray[--i]] <= 0) {
            if (aArray[i] != '=') continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = IA[aArray[s++]]) >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    public static byte[] decodeFast(char[] aArray) {
        int sIx;
        int sLen = aArray.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[aArray[sIx]] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[aArray[eIx]] < 0) {
            --eIx;
        }
        int pad = aArray[eIx] == '=' ? (aArray[eIx - 1] == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (aArray[76] == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[aArray[sIx++]] << 18 | IA[aArray[sIx++]] << 12 | IA[aArray[sIx++]] << 6 | IA[aArray[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[aArray[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static byte[] encodeToByte(byte[] aArray, boolean aSplitLine) {
        int sLen;
        int n = sLen = aArray != null ? aArray.length : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (aSplitLine ? (cCnt - 1) / 76 << 1 : 0);
        byte[] dArr = new byte[dLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i = (aArray[s++] & 0xFF) << 16 | (aArray[s++] & 0xFF) << 8 | aArray[s++] & 0xFF;
            dArr[d++] = (byte)CA[i >>> 18 & 0x3F];
            dArr[d++] = (byte)CA[i >>> 12 & 0x3F];
            dArr[d++] = (byte)CA[i >>> 6 & 0x3F];
            dArr[d++] = (byte)CA[i & 0x3F];
            if (!aSplitLine || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (aArray[eLen] & 0xFF) << 10 | (left == 2 ? (aArray[sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = (byte)CA[i >> 12];
            dArr[dLen - 3] = (byte)CA[i >>> 6 & 0x3F];
            dArr[dLen - 2] = left == 2 ? (int)CA[i & 0x3F] : 61;
            dArr[dLen - 1] = 61;
        }
        return dArr;
    }

    public static byte[] decode(byte[] aArray) {
        int sLen = aArray.length;
        int sepCnt = 0;
        for (int i = 0; i < sLen; ++i) {
            if (IA[aArray[i] & 0xFF] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && IA[aArray[--i] & 0xFF] <= 0) {
            if (aArray[i] != 61) continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = IA[aArray[s++] & 0xFF]) >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    public static byte[] decodeFast(byte[] aArray) {
        int sIx;
        int sLen = aArray.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[aArray[sIx] & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[aArray[eIx] & 0xFF] < 0) {
            --eIx;
        }
        int pad = aArray[eIx] == 61 ? (aArray[eIx - 1] == 61 ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (aArray[76] == 13 ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[aArray[sIx++]] << 18 | IA[aArray[sIx++]] << 12 | IA[aArray[sIx++]] << 6 | IA[aArray[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[aArray[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static String encodeToString(byte[] aArray, boolean aSplitLine, boolean aEqualsPad) {
        return new String(Base64.encodeToChar(aArray, aSplitLine, aEqualsPad));
    }

    public static String encode(byte[] aArray, boolean aEqualsPad) {
        return new String(Base64.encodeToChar(aArray, false, aEqualsPad));
    }

    public static String encode(byte[] aArray) {
        return new String(Base64.encodeToChar(aArray, false, false));
    }

    public static byte[] decode(String aSource) throws IllegalBase64Exception {
        int sLen;
        int n = sLen = aSource != null ? aSource.length() : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int sepCnt = 0;
        for (int i = 0; i < sLen; ++i) {
            if (IA[aSource.charAt(i)] >= 0) continue;
            ++sepCnt;
            if (IA[aSource.charAt(i)] >= -1) continue;
            throw new IllegalBase64Exception("illegal Base64 characters:" + aSource.charAt(i));
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && IA[aSource.charAt(--i)] <= 0) {
            if (aSource.charAt(i) != '=') continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                int n2 = c = s < sLen ? IA[aSource.charAt(s++)] : 0;
                if (c >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    public static byte[] decodeFast(String aSource) {
        int sIx;
        int sLen = aSource.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[aSource.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[aSource.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = aSource.charAt(eIx) == '=' ? (aSource.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (aSource.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[aSource.charAt(sIx++)] << 18 | IA[aSource.charAt(sIx++)] << 12 | IA[aSource.charAt(sIx++)] << 6 | IA[aSource.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[aSource.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        Arrays.fill(IA, -2);
        int iS = CA.length;
        for (int i = 0; i < iS; ++i) {
            Base64.IA[Base64.CA[i]] = i;
        }
        Base64.IA[61] = 0;
        Base64.IA[13] = -1;
        Base64.IA[10] = -1;
        Base64.IA[9] = -1;
        Base64.IA[32] = -1;
    }
}

