/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.util;

import com.sap.idm.vds.ie.Config;
import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.util.Util;
import com.sap.idm.vds.sec.Base64;
import com.sap.idm.vds.sec.IllegalBase64Exception;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String XML_PRINT_TRANSFORMER = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n  <xsl:output method=\"xml\" encoding=\"ISO-8859-1\"/>\n  <xsl:param name=\"indent-increment\" select=\"'   '\"/>\n  <xsl:template name=\"newline\">\n    <xsl:text disable-output-escaping=\"yes\">\n</xsl:text>\n  </xsl:template>\n  <xsl:template match=\"comment() | processing-instruction()\">\n    <xsl:param name=\"indent\" select=\"''\"/>\n    <xsl:call-template name=\"newline\"/>\n    <xsl:value-of select=\"$indent\"/>\n    <xsl:copy />\n  </xsl:template>\n  <xsl:template match=\"text()\">\n    <xsl:param name=\"indent\" select=\"''\"/>\n    <xsl:call-template name=\"newline\"/>\n    <xsl:value-of select=\"$indent\"/>\n    <xsl:value-of select=\"normalize-space(.)\"/>\n  </xsl:template>\n  <xsl:template match=\"text()[normalize-space(.)='']\"/>\n  <xsl:template match=\"*\">\n    <xsl:param name=\"indent\" select=\"''\"/>\n    <xsl:call-template name=\"newline\"/>\n    <xsl:value-of select=\"$indent\"/>\n      <xsl:choose>\n       <xsl:when test=\"count(child::*) > 0\">\n        <xsl:copy>\n         <xsl:copy-of select=\"@*\"/>\n         <xsl:apply-templates select=\"*|text()\">\n           <xsl:with-param name=\"indent\" select=\"concat ($indent, $indent-increment)\"/>\n         </xsl:apply-templates>\n         <xsl:call-template name=\"newline\"/>\n         <xsl:value-of select=\"$indent\"/>\n        </xsl:copy>\n       </xsl:when>\n       <xsl:otherwise>\n        <xsl:copy-of select=\".\"/>\n       </xsl:otherwise>\n     </xsl:choose>\n  </xsl:template>\n</xsl:stylesheet>";
    private static final String TEMP_PREFIX = "$ROOT$/TEMP/";
    private static TransformerFactory transformerFactory;
    private static DocumentBuilderFactory builderFactory;
    private static Document mDoc;
    static /* synthetic */ Class class$com$sap$idm$vds$ie$util$XMLUtil;

    public static void WriteXMLtoFile(Document aDocument, String aConfigName) throws Exception {
        PrintStream output = new PrintStream(new FileOutputStream(aConfigName));
        XMLUtil.printNode(aDocument.getDocumentElement(), output, System.err, true);
        output.close();
    }

    protected static void printNode(Node aNode, OutputStream aOut, PrintStream aErr, boolean aPrettyPrint) {
        block6: {
            Transformer serializer = null;
            try {
                Element tempElement;
                Element root = aNode.getOwnerDocument().getDocumentElement();
                TransformerFactory tfactory = TransformerFactory.newInstance();
                if (aPrettyPrint) {
                    StringReader xslReader = new StringReader(XML_PRINT_TRANSFORMER);
                    Templates template = tfactory.newTemplates(new StreamSource(xslReader));
                    serializer = template.newTransformer();
                } else {
                    serializer = tfactory.newTransformer();
                    Properties oprops = new Properties();
                    oprops.put("method", "XML");
                    oprops.put("indent", "yes");
                    URL url = (class$com$sap$idm$vds$ie$util$XMLUtil == null ? (class$com$sap$idm$vds$ie$util$XMLUtil = XMLUtil.class$("com.sap.idm.vds.ie.util.XMLUtil")) : class$com$sap$idm$vds$ie$util$XMLUtil).getResource("/XMLEntities.res");
                    oprops.put("{http://xml.apache.org/xalan}entities", url.toString());
                    serializer.setOutputProperties(oprops);
                }
                Element internalNode = null;
                if (!aPrettyPrint && aNode instanceof Element && (internalNode = XMLUtil.getElement(tempElement = (Element)aNode, TEMP_PREFIX)) != null) {
                    root.removeChild(internalNode);
                }
                DOMSource src = new DOMSource(aNode);
                StreamResult dest = new StreamResult(aOut);
                serializer.transform(src, dest);
                if (internalNode == null) break block6;
                root.appendChild(internalNode);
            }
            catch (Throwable e) {
                aErr.println("Exception from XML serializing : " + e.toString() + " - '" + e.getMessage() + "'");
                e.printStackTrace(aErr);
                if (serializer == null) break block6;
                aErr.println("\nSerializer properties:");
                Properties props = serializer.getOutputProperties();
                Enumeration<?> keys = props.propertyNames();
                while (keys.hasMoreElements()) {
                    String name = (String)keys.nextElement();
                    aErr.println(name + " = " + props.getProperty(name));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String transformDOMToString(Node aNodeToBeTransformed, boolean aRemoveRoot) {
        try {
            Transformer transformer;
            TransformerFactory transformerFactory = XMLUtil.transformerFactory;
            synchronized (transformerFactory) {
                transformer = XMLUtil.transformerFactory.newTransformer();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            transformer.transform(new DOMSource(aNodeToBeTransformed), result);
            String theString = baos.toString();
            if (!aRemoveRoot) {
                return theString;
            }
            int rootLength = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length();
            theString = theString.substring(rootLength);
            return theString;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document transformStringToDOM(String aStringToBeTransformed) {
        try {
            DocumentBuilder builder;
            DocumentBuilderFactory documentBuilderFactory = builderFactory;
            synchronized (documentBuilderFactory) {
                builder = builderFactory.newDocumentBuilder();
            }
            ByteArrayInputStream instream = new ByteArrayInputStream(aStringToBeTransformed.getBytes());
            BufferedInputStream in = new BufferedInputStream(instream);
            return builder.parse(in);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildDOM(String aFileName) {
        try {
            DocumentBuilder builder;
            File file = new File(aFileName);
            DocumentBuilderFactory documentBuilderFactory = builderFactory;
            synchronized (documentBuilderFactory) {
                builder = builderFactory.newDocumentBuilder();
            }
            return builder.parse(file);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Config prepare(String strTemplateConfigName) {
        Config xmlConf = null;
        try {
            if (strTemplateConfigName != null) {
                File templateConfigFile = new File(strTemplateConfigName);
                if (templateConfigFile == null || !templateConfigFile.exists()) {
                    MVDIELogger.Log("Can not find config file:" + templateConfigFile, 2);
                } else {
                    xmlConf = new Config(templateConfigFile);
                }
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Can not prepare template configuration from :" + strTemplateConfigName, 2);
        }
        return xmlConf;
    }

    private static String getValue(Element aElm, String aAttrName, String aDefault, boolean aDecode) {
        if (aDefault == null) {
            aDefault = "";
        }
        if (aElm != null) {
            Element elm;
            String tagName;
            int ix = aAttrName.lastIndexOf(47);
            if (ix > 0) {
                String path = aAttrName.substring(0, ix);
                tagName = aAttrName.substring(ix + 1);
                elm = XMLUtil.getElement(aElm, path);
            } else {
                elm = aElm;
                tagName = aAttrName;
            }
            if (aDecode) {
                return XMLUtil.decode(XMLUtil.getTextValue(elm, tagName, aDefault));
            }
            return XMLUtil.getTextValue(elm, tagName, aDefault);
        }
        return aDefault;
    }

    private static String getTextValue(Element aMother, String aTagName, String aDefault) {
        String value = aDefault;
        if (aMother != null) {
            if (Util.isEmpty(aTagName)) {
                return XMLUtil.getTextValue(aMother);
            }
            if (aTagName.indexOf(47) > 0) {
                throw new IllegalArgumentException("Slash not allowed in tag name: " + aTagName);
            }
            Element tempElement = XMLUtil.getChildElementByTagName(aMother, aTagName, false);
            if (tempElement != null) {
                value = XMLUtil.getTextValue(aDefault, tempElement);
            }
        }
        return value;
    }

    public static String getValue(Element aElm, String aAttrName, String aDefault) {
        return XMLUtil.getValue(aElm, aAttrName, aDefault, true);
    }

    protected static String getTextValue(Node aNode) {
        return XMLUtil.getTextValue("", aNode);
    }

    protected static String getTextValue(String aDefault, Node aNode) {
        String value = aDefault;
        if (aNode != null) {
            if (aNode.getNodeType() == 3 || aNode.getNodeType() == 4) {
                value = aNode.getNodeValue();
            } else if (aNode.getNodeType() == 1) {
                Node theAttr = aNode.getFirstChild();
                value = XMLUtil.getTextValue(aDefault, theAttr);
            }
        }
        return value;
    }

    protected static String getTextValue(Element aMother, String aTagName) {
        return XMLUtil.getTextValue(aMother, aTagName, "");
    }

    protected static Element getElement(Element aElm, String aTagPath) {
        return XMLUtil.getElement(aElm, aTagPath, false);
    }

    private static Element getElement(Element aElm, String aTagPath, boolean aCreateElements) {
        Element result = null;
        Vector attrNames = Util.splitString(aTagPath, '/');
        Element elm = aElm;
        Iterator it = attrNames.iterator();
        while (it.hasNext()) {
            String tagName = (String)it.next();
            Properties attributes = null;
            if (tagName.startsWith("$") && tagName.endsWith("ROOT$")) {
                elm = XMLUtil.getRootElement(elm, tagName);
            } else {
                Element parent = elm;
                int ix = tagName.indexOf(32);
                attributes = new Properties();
                if (ix > 0) {
                    String atts = tagName.substring(ix + 1).trim();
                    tagName = tagName.substring(0, ix);
                    ByteArrayInputStream bis = new ByteArrayInputStream(atts.getBytes());
                    try {
                        attributes.load(bis);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (Util.isEmpty(attributes)) {
                    elm = XMLUtil.getChildElementByTagName(parent, tagName, aCreateElements);
                } else {
                    NodeList nodelist = parent.getElementsByTagName(tagName);
                    boolean found = false;
                    for (int i = 0; i < nodelist.getLength(); ++i) {
                        elm = (Element)nodelist.item(i);
                        Set<Object> attNames = attributes.keySet();
                        Iterator<Object> attit = attNames.iterator();
                        while (attit.hasNext()) {
                            String attName = (String)attit.next();
                            String attValue = attributes.getProperty(attName);
                            if (elm.hasAttribute(attName) && elm.getAttribute(attName).equalsIgnoreCase(attValue)) {
                                found = true;
                                continue;
                            }
                            found = false;
                            break;
                        }
                        if (found) break;
                    }
                    if (!found) {
                        elm = null;
                    }
                }
                if (aCreateElements && elm == null) {
                    Element tmpElm = parent.getOwnerDocument().createElement(tagName);
                    if (!Util.isEmpty(attributes)) {
                        Set<Object> attNames = attributes.keySet();
                        Iterator<Object> attit = attNames.iterator();
                        while (attit.hasNext()) {
                            String attName = (String)attit.next();
                            String attValue = attributes.getProperty(attName);
                            tmpElm.setAttribute(attName, attValue);
                        }
                    }
                    elm = (Element)parent.appendChild(tmpElm);
                }
            }
            if (elm == null) {
                return null;
            }
            result = elm;
        }
        return result;
    }

    protected static Element getRootElement(Node aNode, String aRootTag) {
        NodeList nodelist;
        Element elm = aNode.getOwnerDocument().getDocumentElement();
        if (aRootTag.equals("$MVDROOT$")) {
            NodeList nodelist2;
            if (!elm.getNodeName().equals("MVDConfig") && (nodelist2 = elm.getElementsByTagName("MVDConfig")).getLength() > 0) {
                elm = (Element)nodelist2.item(0);
            }
        } else if (aRootTag.equals("$MFSROOT$") && !elm.getNodeName().equals("MaXwareFederationServer") && (nodelist = elm.getElementsByTagName("MaXwareFederationServer")).getLength() > 0) {
            elm = (Element)nodelist.item(0);
        }
        return elm;
    }

    public static Element getChildElementByTagName(Element aElm, String aTagName, boolean aCreateElements) {
        int ix = aTagName.lastIndexOf(47);
        if (ix > 0) {
            IllegalArgumentException iae = new IllegalArgumentException("Slash not allowed in tag name: " + aTagName);
            throw iae;
        }
        Element elm = null;
        for (Node n = aElm.getFirstChild(); n != null; n = n.getNextSibling()) {
            try {
                elm = (Element)n;
                if (elm.getNodeName().equals(aTagName)) {
                    return elm;
                }
            }
            catch (ClassCastException cce) {
                elm = null;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            elm = null;
        }
        if (aCreateElements && elm == null) {
            Element tmpElm = aElm.getOwnerDocument().createElement(aTagName);
            elm = (Element)aElm.appendChild(tmpElm);
        }
        return elm;
    }

    private static String decode(String aSource) {
        String result = aSource;
        if (Util.isEmpty(result)) {
            result = "";
        }
        if (!result.startsWith("{")) {
            return result;
        }
        if (result.startsWith("{CRYPT}")) {
            try {
                String sTemp = result.substring(7, result.length() - 1);
                byte[] bTemp = Base64.decode(sTemp);
                for (int i = 0; i < bTemp.length; ++i) {
                    int iTmp = bTemp[i];
                    iTmp = iTmp + i % 19 - 7;
                    bTemp[i] = (byte)iTmp;
                }
                result = new String(bTemp);
                result = result.substring(1);
            }
            catch (IllegalBase64Exception ibe) {}
        } else if (result.startsWith("{B64}")) {
            try {
                String sTemp = result.substring(5);
                byte[] bTemp = Base64.decode(sTemp);
                result = new String(bTemp);
            }
            catch (IllegalBase64Exception illegalBase64Exception) {
                // empty catch block
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            transformerFactory = TransformerFactory.newInstance();
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

