/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.single;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSingleObject {
    private String mObjName = "";
    protected HashMap mDefaults = new HashMap();

    public AbstractSingleObject(String aobjname) {
        this.mObjName = aobjname;
    }

    public abstract void initDefaults() throws Exception;

    public HashMap getDefaultss() {
        return this.mDefaults;
    }

    private String getDefaults(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    public boolean init() throws Exception {
        this.initDefaults();
        return VerifierUtil.createSecondLevelObject(this.mObjName, false);
    }

    private HashMap initDiffs() throws Exception {
        HashMap aDiffs = new HashMap(this.mDefaults);
        return aDiffs;
    }

    public void findAndVerifyNode() throws Exception {
        try {
            Document document = VerifierUtil.getDocument();
            NodeList nodeList = document.getElementsByTagName("MVDConfig");
            Node mc = nodeList.item(0);
            nodeList = ((Element)mc).getElementsByTagName(this.mObjName);
            Node qNode = nodeList.item(0);
            if (qNode != null) {
                qNode = this.verifyNode(qNode);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update <" + this.mObjName + "> node: " + e, 2);
        }
    }

    private Node verifyNode(Node aNode) {
        String outputId = "";
        if (aNode != null) {
            try {
                outputId = this.mObjName;
                VerifierUtil.doTheMagic(aNode, this.initDiffs(), null, null, outputId);
            }
            catch (Exception e) {
                MVDIELogger.Log("Could not update <" + this.mObjName + "> node: " + e, 2);
            }
        }
        return aNode;
    }
}

