/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.logging;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractLogDestination83 {
    private String mParentNodeName = "";
    private String mTopNodeName = "";
    protected HashMap mDefaults = new HashMap();

    public AbstractLogDestination83(String aParentNodeName, String aTopNodeName) {
        this.mParentNodeName = aParentNodeName;
        this.mTopNodeName = aTopNodeName;
    }

    public void initDefaults() throws Exception {
    }

    public String getDefault(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    public HashMap getDefault() {
        return this.mDefaults;
    }

    public boolean init() throws Exception {
        this.initDefaults();
        VerifierUtil.createSubLevelObject("LogDestination", this.mParentNodeName, false);
        VerifierUtil.createSubSubLevelObject(this.mTopNodeName, "LogDestination", this.mParentNodeName, false);
        return true;
    }

    private HashMap initDiffs() throws Exception {
        HashMap aDiffs = new HashMap(this.mDefaults);
        return aDiffs;
    }

    public void findAndVerifyNode() throws Exception {
        try {
            Document document = VerifierUtil.getDocument();
            NodeList nodeList = document.getElementsByTagName("MVDConfig");
            Node mc = nodeList.item(0);
            nodeList = ((Element)mc).getElementsByTagName(this.mParentNodeName);
            mc = nodeList.item(0);
            nodeList = ((Element)mc).getElementsByTagName(this.mTopNodeName);
            Node qNode = nodeList.item(0);
            if (qNode != null) {
                qNode = this.verifyNode(qNode);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update <" + this.mTopNodeName + "> node: " + e, 2);
        }
    }

    private Node verifyNode(Node aNode) {
        String outputId = "";
        if (aNode != null) {
            try {
                outputId = this.mTopNodeName;
                VerifierUtil.doTheMagic(aNode, this.initDiffs(), null, null, outputId);
            }
            catch (Exception e) {
                MVDIELogger.Log("Could not update <" + this.mTopNodeName + "> node: " + e, 2);
            }
        }
        return aNode;
    }
}

