/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.lists;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.util.XMLUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class VerifierUtil {
    private static int mLargestID = 0;
    private static Document mDoc;
    private static HashMap mTableColumns;
    private static StringBuffer mChangesStringBuffer;
    private static String mImportanceFlag;

    public static int getLargestID() {
        return ++mLargestID;
    }

    public static void setLargestID(Element aAnyElement, String aTag) {
        int iMax = 0;
        Element root = null;
        if (aAnyElement != null) {
            Document doc = aAnyElement.getOwnerDocument();
            root = doc.getDocumentElement();
        } else {
            root = mDoc.getDocumentElement();
        }
        NodeList nodelist = root.getElementsByTagName(aTag);
        if (nodelist.getLength() > 0) {
            for (int idx = nodelist.getLength() - 1; idx >= 0; --idx) {
                Element elm = (Element)nodelist.item(idx);
                String s = VerifierUtil.getTextValue("0", elm);
                int id = Integer.parseInt(s);
                if (id <= iMax) continue;
                iMax = id;
            }
        }
        mLargestID = iMax;
    }

    public static void setDocument(Document doc) {
        mDoc = doc;
        if (mChangesStringBuffer != null && mChangesStringBuffer.length() > 0) {
            mChangesStringBuffer.setLength(0);
        }
    }

    public static String getImportanceFlag() {
        return mImportanceFlag;
    }

    public static void addImportanceFlag(String Flag) {
        if (mImportanceFlag.length() > 0) {
            mImportanceFlag = mImportanceFlag + ",";
        }
        mImportanceFlag = mImportanceFlag + Flag;
    }

    public static String getChangeMessages() {
        if (mChangesStringBuffer != null) {
            return mChangesStringBuffer.toString();
        }
        return "";
    }

    public static void updateString(Vector aTagsToAdd, Vector aTagsToRemove, String aTagName) {
        String message = "";
        if (!aTagsToAdd.isEmpty()) {
            message = "Adding tags to " + aTagName + ": " + aTagsToAdd.toString();
            VerifierUtil.updateString(message);
        }
        if (!aTagsToRemove.isEmpty()) {
            message = "Removing nodes from " + aTagName + ": " + aTagsToRemove.toString();
            VerifierUtil.updateString(message);
        }
    }

    public static void updateString(String aMessage) {
        try {
            VerifierUtil.addChangeMessage("\n" + aMessage);
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not add change message '" + aMessage + "'" + e, 0);
        }
        MVDIELogger.Log(aMessage, 1);
        System.setProperty("DOM_HAS_CHANGED", "1");
    }

    public static void addChangeMessage(Vector aTagsToAdd, Vector aTagsToRemove, String aTagName) throws Exception {
        String message = "";
        try {
            if (!aTagsToAdd.isEmpty()) {
                message = "Adding tags to " + aTagName + ":" + aTagsToAdd.toString();
                VerifierUtil.addChangeMessage(message);
            }
        }
        catch (Exception e) {
            throw new Exception("Could not add change string '" + message + "': " + e);
        }
        try {
            if (!aTagsToRemove.isEmpty()) {
                message = "Removing nodes from " + aTagName + ": " + aTagsToRemove.toString();
                VerifierUtil.addChangeMessage(message);
            }
        }
        catch (Exception e) {
            throw new Exception("Could not add change string '" + message + "': " + e);
        }
    }

    public static void addChangeMessage(String aChangeMessage) throws Exception {
        System.setProperty("DOM_HAS_CHANGED", "1");
        try {
            if (mChangesStringBuffer == null) {
                mChangesStringBuffer = new StringBuffer();
            }
            if (!VerifierUtil.isAdded(aChangeMessage)) {
                mChangesStringBuffer.append("\n" + aChangeMessage);
                MVDIELogger.Log(aChangeMessage, 1);
            }
        }
        catch (Exception e) {
            throw new Exception("Could not add change message: " + e);
        }
    }

    private static boolean isAdded(String aChangeMessage) {
        return mChangesStringBuffer.indexOf(aChangeMessage) >= 0;
    }

    public static Document getDocument() {
        return mDoc;
    }

    public static HashMap compareProperties(HashMap aSource, HashMap aTarget) throws Exception {
        try {
            String key;
            Iterator it = aSource.keySet().iterator();
            while (it.hasNext()) {
                key = it.next().toString();
                if (!aTarget.containsKey(key)) continue;
                aTarget.put(key, "0");
            }
            it = aTarget.keySet().iterator();
            while (it.hasNext()) {
                key = it.next().toString();
                if (aSource.containsKey(key)) continue;
                aTarget.put(key, "1");
            }
        }
        catch (Exception de) {
            throw new Exception("Could not compare properties: " + de.getMessage());
        }
        return aTarget;
    }

    public static String getOutputId(String aType, HashMap idHash, String[] idkeys) {
        String outputId = "";
        for (int ix = 0; ix < idkeys.length; ++ix) {
            if (outputId.length() > 0) {
                outputId = outputId + " \\ ";
            }
            outputId = outputId + idkeys[ix] + "=" + (String)idHash.get(idkeys[ix]);
        }
        outputId = "<" + aType + "> " + "node with " + outputId;
        return outputId;
    }

    public static void doTheMagic(Node recordNode, HashMap diffHash, HashMap idHash, String[] idkeys, String outputId) throws Exception {
        HashMap compareTags = VerifierUtil.compareProperties(recordNode, diffHash, outputId);
        Vector tagsToAdd = VerifierUtil.getTags(compareTags, "1");
        for (int missCounter = 0; missCounter < tagsToAdd.size(); ++missCounter) {
            String recChildName = (String)tagsToAdd.get(missCounter);
            String recChildValue = "";
            boolean bFound = false;
            if (diffHash != null && idkeys != null) {
                for (int ix = 0; ix < idkeys.length; ++ix) {
                    if (!recChildName.equalsIgnoreCase(idkeys[ix])) continue;
                    recChildValue = (String)idHash.get(recChildName);
                    bFound = true;
                    break;
                }
            }
            if (!bFound) {
                recChildValue = (String)diffHash.get(recChildName);
            }
            VerifierUtil.Store_Value(recordNode, recChildName, recChildValue);
        }
        Vector tagsToRemove = VerifierUtil.getTags(compareTags, "-1");
        recordNode = VerifierUtil.removeChilds(recordNode, tagsToRemove);
        VerifierUtil.updateString(tagsToAdd, tagsToRemove, outputId);
    }

    public static HashMap compareProperties(Node aRecordNode, HashMap aMandatoryTags, String aName) throws Exception {
        HashMap<String, String> nodeNames = new HashMap<String, String>();
        HashMap<String, String> mandTags = new HashMap<String, String>();
        try {
            String key;
            NodeList childNodes = aRecordNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() == 3) continue;
                String nodeName = childNode.getNodeName();
                nodeNames.put(nodeName, "");
            }
            Iterator it = nodeNames.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                if (aMandatoryTags.containsKey(key)) {
                    mandTags.put(key, "0");
                }
                if (aMandatoryTags.containsKey(key)) continue;
                mandTags.put(key, "-1");
            }
            it = aMandatoryTags.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                if (nodeNames.containsKey(key) || aMandatoryTags.get(key).toString().equalsIgnoreCase("0")) continue;
                mandTags.put(key, "1");
            }
        }
        catch (Exception de) {
            throw new Exception("Could not compare " + aName + " record node: " + de.getMessage());
        }
        return mandTags;
    }

    public static Vector getTags(HashMap aMissingTags, String aCriteria) throws Exception {
        Vector<String> missTags = new Vector<String>();
        try {
            Iterator it = aMissingTags.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)aMissingTags.get(key);
                if (!value.equalsIgnoreCase(aCriteria)) continue;
                missTags.add(key);
            }
        }
        catch (Exception de) {
            throw new Exception("Could not compare properties: " + de.getMessage());
        }
        return missTags;
    }

    public static HashMap getTags(HashMap aMissingTags, HashMap aDefaults, String aCriteria) throws Exception {
        HashMap<String, String> keyAndValues = new HashMap<String, String>();
        try {
            Iterator it = aMissingTags.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)aMissingTags.get(key);
                if (!value.equalsIgnoreCase(aCriteria)) continue;
                value = (String)aDefaults.get(key);
                keyAndValues.put(key, value);
            }
        }
        catch (Exception de) {
            throw new Exception("Could not compare properties: " + de.getMessage());
        }
        return keyAndValues;
    }

    public static String getTextValue(Node ww) {
        NodeList alist = ww.getChildNodes();
        boolean bFound = false;
        Node txtnode = null;
        for (int uuu = 0; uuu < alist.getLength(); ++uuu) {
            txtnode = alist.item(uuu);
            if (txtnode == null || txtnode.getNodeType() != 3) continue;
            bFound = true;
            break;
        }
        if (!bFound || txtnode.getNodeValue() == null || txtnode.getNodeValue().length() == 0) {
            return null;
        }
        return txtnode.getNodeValue();
    }

    public static void Store_New_Value(Node aNode, String aAttrValue) throws Exception {
        if (aAttrValue != null) {
            Text valNode = mDoc.createTextNode(aAttrValue);
            if (aNode.hasChildNodes()) {
                aNode.removeChild(aNode.getFirstChild());
            }
            aNode.appendChild(valNode);
        }
    }

    public static void Store_Value(Node aNode, String aAttrName, String aAttrValue) throws Exception {
        Element el = mDoc.createElement(aAttrName);
        if (aAttrValue != null) {
            Text valNode = mDoc.createTextNode(aAttrValue);
            el.appendChild(valNode);
        }
        aNode.appendChild(el);
    }

    public static void Store_Value_As_Attr(Node aNode, String aName, String aAttrName, String aAttrValue) throws Exception {
        Element el = mDoc.createElement(aName);
        if (aAttrValue != null) {
            el.setAttribute("name", aAttrName);
            el.setAttribute("value", aAttrValue);
        }
        aNode.appendChild(el);
    }

    public static void Store_TagName(Node aNode, String aTagName) throws Exception {
        Element el = mDoc.createElement(aTagName);
        aNode.appendChild(el);
    }

    public static Node Create_Node(String aTagName) throws Exception {
        Element el = mDoc.createElement(aTagName);
        return el;
    }

    public static Vector getIDsFromString(String aIDs) throws Exception {
        Vector<String> IDs = new Vector<String>();
        StringTokenizer ids = new StringTokenizer(aIDs, ":");
        while (ids.hasMoreTokens()) {
            String id = ids.nextToken();
            IDs.add(id);
        }
        return IDs;
    }

    public static void setXMLasDefaultAppender(Node parentnode) {
        NodeList nl = null;
        if (parentnode != null) {
            nl = ((Element)parentnode).getElementsByTagName("UseDefaultAppender");
        }
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        Node mdefapp = nl.item(0);
        String sss = VerifierUtil.getTextValue(mdefapp);
        if (sss.equalsIgnoreCase("true")) {
            nl = ((Element)parentnode).getElementsByTagName("Appenders");
            Node mapp = nl.item(0);
            if (mapp.hasChildNodes()) {
                mapp.removeChild(mapp.getFirstChild());
            }
            Text valNode = mDoc.createTextNode("!XML");
            mapp.appendChild(valNode);
        }
    }

    public static void setXMLasDefaultAppender(String nodename) throws Exception {
        NodeList nl = mDoc.getElementsByTagName("MVDConfig");
        Node mc = nl.item(0);
        nl = ((Element)mc).getElementsByTagName("Logging");
        Node mlog = nl.item(0);
        nl = ((Element)mlog).getElementsByTagName(nodename);
        Node mlognode = null;
        if (nl.getLength() != 0) {
            mlognode = nl.item(0);
        }
        VerifierUtil.setXMLasDefaultAppender(mlognode);
    }

    public static boolean createSecondLevelObject(String objName, boolean bCreateSubRecord) throws Exception {
        Node aNode;
        NodeList nl = mDoc.getElementsByTagName(objName);
        if (nl.getLength() == 0) {
            Element rootNode = mDoc.getDocumentElement();
            Node aNode2 = VerifierUtil.Create_Node(objName);
            rootNode.appendChild(aNode2);
            if (bCreateSubRecord) {
                Node recNode = VerifierUtil.Create_Node("Record");
                aNode2.appendChild(recNode);
            }
            VerifierUtil.addChangeMessage("\nCreated <" + objName + "> node");
            MVDIELogger.Log("Created <" + objName + "> node", 1);
            System.setProperty("DOM_HAS_CHANGED", "1");
            return false;
        }
        if (bCreateSubRecord && (nl = ((Element)(aNode = nl.item(0))).getElementsByTagName("Record")).getLength() == 0) {
            Node recNode = VerifierUtil.Create_Node("Record");
            aNode.appendChild(recNode);
            VerifierUtil.addChangeMessage("\nCreated <" + objName + "> node");
            MVDIELogger.Log("Created <Record> node under <" + objName + "> node", 1);
            System.setProperty("DOM_HAS_CHANGED", "1");
        }
        return true;
    }

    public static boolean createSubLevelObject(String childName, String objName, boolean bCreateSubRecord) throws Exception {
        NodeList nl = mDoc.getElementsByTagName(objName);
        Node pNode = nl.item(0);
        if ((nl = ((Element)pNode).getElementsByTagName(childName)).getLength() == 0) {
            Node aNode = VerifierUtil.Create_Node(childName);
            pNode.appendChild(aNode);
            VerifierUtil.addChangeMessage("\nCreated <" + childName + "> node");
            MVDIELogger.Log("Created <" + childName + "> node", 1);
            System.setProperty("DOM_HAS_CHANGED", "1");
            return false;
        }
        return true;
    }

    public static boolean createSubSubLevelObject(String childName, String objName, String outerName, boolean bCreateSubRecord) throws Exception {
        NodeList nl = mDoc.getElementsByTagName(outerName);
        Node pNode = nl.item(0);
        nl = ((Element)pNode).getElementsByTagName(objName);
        pNode = nl.item(0);
        if ((nl = ((Element)pNode).getElementsByTagName(childName)).getLength() == 0) {
            Node aNode = VerifierUtil.Create_Node(childName);
            pNode.appendChild(aNode);
            VerifierUtil.addChangeMessage("\nCreated <" + childName + "> node");
            MVDIELogger.Log("Created <" + childName + "> node", 1);
            System.setProperty("DOM_HAS_CHANGED", "1");
            return false;
        }
        return true;
    }

    public static HashMap getObjectIdentification(Node recordNode, String[] idKeys) {
        HashMap<String, String> idHash = new HashMap<String, String>();
        NodeList recordChilds = recordNode.getChildNodes();
        for (int childCounter = 0; childCounter < recordChilds.getLength(); ++childCounter) {
            Node recordChild = recordChilds.item(childCounter);
            if (recordChild.getNodeType() == 3 || !recordChild.hasChildNodes()) continue;
            String recChildName = recordChild.getNodeName();
            for (int ix = 0; ix < idKeys.length; ++ix) {
                String s;
                Node n;
                if (!recChildName.equalsIgnoreCase(idKeys[ix]) || (n = recordChild.getFirstChild()) == null || (s = n.getNodeValue()) == null) continue;
                s.trim();
                idHash.put(idKeys[ix], s);
            }
        }
        return idHash;
    }

    public static Node removeChilds(Node aRecNode, Vector aTagsToRemove) {
        for (int i = 0; i < aTagsToRemove.size(); ++i) {
            String remove = (String)aTagsToRemove.get(i);
            Element childNode = XMLUtil.getChildElementByTagName((Element)aRecNode, remove, false);
            if (childNode == null) continue;
            aRecNode.removeChild(childNode);
        }
        return aRecNode;
    }

    public static Node addChilds(Node aRecNode, Vector aTagsToAdd, HashMap aStruct) throws Exception {
        for (int missCounter = 0; missCounter < aTagsToAdd.size(); ++missCounter) {
            String childName = (String)aTagsToAdd.get(missCounter);
            String recChildValue = (String)aStruct.get(childName);
            VerifierUtil.Store_Value(aRecNode, childName, recChildValue);
        }
        return aRecNode;
    }

    public static HashMap initDiffs(HashMap aKeyMap) throws Exception {
        HashMap diffs = new HashMap(aKeyMap);
        return diffs;
    }

    public static void checkRoot() throws Exception {
        Element rootElem = mDoc.getDocumentElement();
        if (rootElem.getNodeName().equalsIgnoreCase("MVDConfig")) {
            Element newRootElem = mDoc.createElement("MaXwareFederationServer");
            newRootElem.setAttribute("Version", "1.0");
            Node node = rootElem.cloneNode(true);
            newRootElem.appendChild(node);
            mDoc.removeChild(rootElem);
            mDoc.appendChild(newRootElem);
            VerifierUtil.addChangeMessage("Reconfigure root from MVDConfig to MaXwareFeredarionServer");
        }
    }

    public static void checkMVDConfigRoot() throws Exception {
        String s;
        Element rootElem = mDoc.getDocumentElement();
        if (rootElem.getNodeName().equalsIgnoreCase("MVDConfig") && !(s = rootElem.getAttribute("Version")).equals("8.4")) {
            rootElem.setAttribute("Version", "8.4");
            System.setProperty("DOM_HAS_CHANGED", "1");
            VerifierUtil.addChangeMessage("\nUpgraded document version to 8.4");
        }
    }

    public static void checkRootChildNodes() throws Exception {
        Boolean hasChanged = Boolean.FALSE;
        Vector messages = new Vector();
        Vector retVector = new Vector();
        Object dsGroupNode = null;
        Node rootElem = mDoc.getElementsByTagName("MaXwareFederationServer").item(0);
        NodeList rootChilds = rootElem.getChildNodes();
        String[] checkRootChildName = new String[]{"RelyingParty", "KeyStores"};
        for (int i = 0; i < checkRootChildName.length; ++i) {
            VerifierUtil.doNodeExist(rootElem, checkRootChildName[i], rootChilds);
        }
    }

    private static void doNodeExist(Node aNodeToAppendTo, String aNodeName, NodeList aNodeList) throws Exception {
        for (int nodeCounter = 0; nodeCounter < aNodeList.getLength(); ++nodeCounter) {
            Node node = aNodeList.item(nodeCounter);
            String nodeName = node.getNodeName();
            if (!aNodeName.equalsIgnoreCase(nodeName)) continue;
            return;
        }
        VerifierUtil.addChangeMessage("Created node " + aNodeName);
        Node node = VerifierUtil.Create_Node(aNodeName);
        aNodeToAppendTo.appendChild(node);
        if (aNodeName.equalsIgnoreCase("AssertingParty") || aNodeName.equalsIgnoreCase("RelyingParty")) {
            VerifierUtil.addChangeMessage("Created node Enable with value false and appended it to " + aNodeName);
            MVDIELogger.Log("Created node Enable with value false and appended it to " + aNodeName, 1);
            Node enableNode = VerifierUtil.Create_Node("Enabled");
            enableNode.appendChild(VerifierUtil.getDocument().createTextNode("false"));
            node.appendChild(enableNode);
        }
    }

    protected static String getTextValue(String aDefault, Node aNode) {
        String value = aDefault;
        if (aNode != null) {
            if (aNode.getNodeType() == 3 || aNode.getNodeType() == 4) {
                value = aNode.getNodeValue();
            } else if (aNode.getNodeType() == 1) {
                Node theAttr = aNode.getFirstChild();
                value = VerifierUtil.getTextValue(aDefault, theAttr);
            }
        }
        return value;
    }

    public static int stringToInt(String aInput, int aDefault) {
        int result = aDefault;
        try {
            result = Integer.parseInt(aInput);
        }
        catch (Exception e) {
            result = aDefault;
        }
        return result;
    }

    protected static int createNewID(Element aAnyElement, String aTag, int aSuggestion) {
        boolean found = false;
        if (aSuggestion <= 0) {
            found = true;
        }
        int iMax = 0;
        Document doc = aAnyElement.getOwnerDocument();
        Element root = doc.getDocumentElement();
        NodeList nodelist = root.getElementsByTagName(aTag);
        if (nodelist.getLength() > 0) {
            for (int idx = nodelist.getLength() - 1; idx >= 0; --idx) {
                Element elm = (Element)nodelist.item(idx);
                int id = VerifierUtil.stringToInt(VerifierUtil.getTextValue("0", elm), 0);
                if (id == aSuggestion) {
                    found = true;
                }
                if (id <= iMax) continue;
                iMax = id;
            }
        }
        if (!found && aSuggestion < iMax) {
            return aSuggestion;
        }
        return ++iMax;
    }

    static {
        mChangesStringBuffer = null;
        mImportanceFlag = "";
    }
}

