/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.lists;

import com.sap.idm.vds.ie.lists.AbstractTopListObject;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import com.sap.idm.vds.ie.util.MVDMic_Util;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSource
extends AbstractTopListObject {
    public DataSource() {
        super(null, "DataSources", "Record", new String[]{"ID", "Name", "Type", "UniqueName"});
    }

    public String updateIdHash(HashMap idHash) {
        String recID = (String)idHash.get("ID");
        String recName = (String)idHash.get("Name");
        String uniqueName = (String)idHash.get("UniqueName");
        String dsType = (String)idHash.get("Type");
        if (recID == null || recID.length() == 0) {
            recID = "" + VerifierUtil.getLargestID();
            idHash.put("ID", recID);
            if (recName == null || recName.length() == 0) {
                recName = "Generated by verifier (ID=" + recID + ")";
                idHash.put("Name", recName);
            }
        }
        if (uniqueName == null || uniqueName.equalsIgnoreCase("none")) {
            String aUniqueName = recID + MVDMic_Util.replace(recName, " ", "");
            int aLen = Math.min(10, aUniqueName.length());
            aUniqueName = aUniqueName.substring(0, aLen).toUpperCase();
            idHash.put("UniqueName", aUniqueName);
        }
        if (dsType == null) {
            dsType = "LDAP";
            idHash.put("Type", dsType);
        }
        return dsType;
    }

    public void initDefaults() throws Exception {
        this.mDefaults.put("ID", "");
        this.mDefaults.put("UniqueName", "");
        this.mDefaults.put("Enabled", "False");
        this.mDefaults.put("EnableSyntaxCheck", "False");
        this.mDefaults.put("SyntaxCheck", "");
        this.mDefaults.put("EnableSyntaxCheckModSet", "False");
        this.mDefaults.put("EnableSyntaxCheckAddSet", "False");
        this.mDefaults.put("SyntaxCheckModSetMethod", "");
        this.mDefaults.put("SyntaxCheckAddSetMethod", "");
        this.mDefaults.put("Description", "");
        this.mDefaults.put("ForbidNonIdxFilt", "");
        this.mDefaults.put("ForbidNonAvailFields", "");
        this.mDefaults.put("DoIgnoreAttributes", "");
        this.mDefaults.put("Name", "");
        this.mDefaults.put("PostOpScript", "");
        this.mDefaults.put("PreOpScript", "");
        this.mDefaults.put("SearchScript", "");
        this.mDefaults.put("ModifyScript", "");
        this.mDefaults.put("AddScript", "");
        this.mDefaults.put("DeleteScript", "");
        this.mDefaults.put("CompareScript", "");
        this.mDefaults.put("AvailableFields", "");
        this.mDefaults.put("FilterFields", "");
        this.mDefaults.put("IgnoredAttributes", "");
        this.mDefaults.put("EnableConvFromDataSource", "");
        this.mDefaults.put("EnableConvToDataSource", "");
        this.mDefaults.put("AttrConvToDataSource", "");
        this.mDefaults.put("AttrConvFromDataSource", "");
        this.mDefaults.put("Type", "");
        this.mDefaults.put("ParamFields", "");
        this.mDefaults.put("DoEditAttributeSet", "");
        this.mDefaults.put("EditAttributeSetMethod", "");
        this.mDefaults.put("IsCaseSensitive", "");
        this.mDefaults.put("AttrConvConstructFromDataSource", "");
        this.mDefaults.put("AttrConvDeleteFromDataSource", "");
        this.mDefaults.put("ClientKeystoreID", "-1");
        this.mDefaults.put("ClientTrustStoreID", "-1");
    }

    public HashMap initDiffsByKey(String aKey) {
        HashMap<String, String> aDiffs = new HashMap<String, String>(this.mDefaults);
        if (aKey.equalsIgnoreCase("Database")) {
            aDiffs.put("JDBCDriver", "");
            aDiffs.put("DefaultDN", "");
            aDiffs.put("DefaultBaseFilter", "");
            aDiffs.put("DefaultAddHelper", "");
            aDiffs.put("DefaultDNFields", "");
        } else if (aKey.equalsIgnoreCase("Generic")) {
            aDiffs.put("DefaultDN", "");
            aDiffs.put("DefaultBaseFilter", "");
            aDiffs.put("DefaultAddHelper", "");
            aDiffs.put("DefaultDNFields", "");
        } else if (aKey.equalsIgnoreCase("LDAP")) {
            aDiffs.put("DefaultStartingPoint", "");
        }
        return aDiffs;
    }

    public static HashMap getDataSourceByID(String aID) throws Exception {
        Vector dataSources = DataSource.getDataSource();
        HashMap dataSource = null;
        try {
            for (int dsCounter = 0; dsCounter < dataSources.size(); ++dsCounter) {
                dataSource = (HashMap)dataSources.get(dsCounter);
                if (!aID.equalsIgnoreCase(dataSource.get("ID").toString())) continue;
                return dataSource;
            }
        }
        catch (Exception e) {
            throw new Exception("Error getting data source given by ID " + aID + ": " + e.getMessage());
        }
        return null;
    }

    private static Vector getDataSource() throws Exception {
        Vector dataSources = new Vector();
        Document document = VerifierUtil.getDocument();
        try {
            NodeList nl = document.getElementsByTagName("DataSources");
            Node node = nl.item(0);
            if (node != null) {
                nl = ((Element)node).getElementsByTagName("Record");
                for (int i = 0; i < nl.getLength(); ++i) {
                    HashMap<String, String> tmpDataSourceProperties = new HashMap<String, String>();
                    Node datasourceNode = nl.item(i);
                    if (datasourceNode != null && datasourceNode.hasChildNodes()) {
                        NodeList nodeList = datasourceNode.getChildNodes();
                        for (int x = 0; x < nodeList.getLength(); ++x) {
                            node = nodeList.item(x);
                            if (node.getNodeType() == 3) continue;
                            String nodeStr = node.getNodeName();
                            String strVal = "";
                            if (node.hasChildNodes()) {
                                strVal = node.getFirstChild().getNodeValue().trim();
                            }
                            tmpDataSourceProperties.put(nodeStr, strVal);
                        }
                    }
                    dataSources.add(tmpDataSourceProperties);
                }
            }
        }
        catch (Exception de) {
            throw new Exception("Error getting data sources from configuration: " + de.getMessage());
        }
        return dataSources;
    }
}

