/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.lists;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Acl {
    private HashMap mDefaults = new HashMap();

    public void initDefaults() throws Exception {
        this.mDefaults.put("Enabled", "TRUE");
        this.mDefaults.put("ID", "");
        this.mDefaults.put("Name", "");
        this.mDefaults.put("QName", "");
        this.mDefaults.put("ParentID", "");
        this.mDefaults.put("MappingID", "");
        this.mDefaults.put("LDAPProperties", "");
        this.mDefaults.put("UserGroupRuleMapping", "");
        this.mDefaults.put("ObjectClass", "*");
        this.mDefaults.put("ProhibitOneLevelSearch", "FALSE");
        this.mDefaults.put("EnableOwnerAccess", "FALSE");
        this.mDefaults.put("OwnerRuleID", "-1");
        this.mDefaults.put("ParamFields", "");
        this.mDefaults.put("ProhibitExactSubSearch", "FALSE");
        this.mDefaults.put("ProhibitInheritedSubSearch", "FALSE");
        this.mDefaults.put("ForestID", "1");
        this.mDefaults.put("EnableMemberAccess", "FALSE");
        this.mDefaults.put("MemberRuleID", "-1");
        this.mDefaults.put("Priority", "50");
        this.mDefaults.put("MappingType", "0");
    }

    private String getDefaults(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    private HashMap getDefaults() {
        return this.mDefaults;
    }

    public boolean init() throws Exception {
        this.initDefaults();
        return VerifierUtil.createSecondLevelObject("ACLs", false);
    }

    private HashMap initDiffs() throws Exception {
        HashMap<String, String> aDiffs = new HashMap<String, String>(this.mDefaults);
        aDiffs.put("Record", "0");
        return aDiffs;
    }

    public void verifyACLTags() throws Exception {
        String outputId = "";
        try {
            Document document = VerifierUtil.getDocument();
            NodeList nl = document.getElementsByTagName("ACLs");
            Node node = nl.item(0);
            if (node != null) {
                this.verifyAclRecordNode(node);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update <ACLs> - " + e, 2);
        }
    }

    public void verifyAclRecordNode(Node node) throws Exception {
        String outputId = "";
        try {
            NodeList nl = ((Element)node).getChildNodes();
            for (int x = 0; x < nl.getLength(); ++x) {
                Node recordNode = nl.item(x);
                if (recordNode == null || !recordNode.getNodeName().equals("Record")) continue;
                String[] idkeys = new String[]{"ID", "Name"};
                HashMap idHash = VerifierUtil.getObjectIdentification(recordNode, idkeys);
                String recID = (String)idHash.get("ID");
                String recName = (String)idHash.get("Name");
                if (recID == null || recID.length() == 0) {
                    recID = "" + VerifierUtil.getLargestID();
                    idHash.put("ID", recID);
                    if (recName == null || recName.length() == 0) {
                        recName = "Generated by verifier (ID=" + recID + ")";
                        idHash.put("Name", recName);
                    }
                }
                outputId = VerifierUtil.getOutputId("ACLs", idHash, idkeys);
                VerifierUtil.doTheMagic(recordNode, this.initDiffs(), idHash, idkeys, outputId);
                this.verifyAclRecordNode(recordNode);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update " + outputId + " - " + e, 2);
        }
    }
}

