/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.dsgroups;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.dsgroups.AttributeSource;
import com.sap.idm.vds.ie.dsgroups.DSGroups_Util;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDSGroup {
    private String mTopNodeName = "";
    protected HashMap mDefaults = new HashMap();

    public AbstractDSGroup(String aTopNodeName) {
        this.mTopNodeName = aTopNodeName;
    }

    public abstract void initDefaults() throws Exception;

    public String getDefault(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    public HashMap getDefault() {
        return this.mDefaults;
    }

    public boolean init() throws Exception {
        this.initDefaults();
        if (!this.mTopNodeName.equalsIgnoreCase("AttributeSources")) {
            VerifierUtil.createSecondLevelObject("DataSourceGroups", false);
            return VerifierUtil.createSubLevelObject(this.mTopNodeName, "DataSourceGroups", false);
        }
        return true;
    }

    private HashMap initDiffs() throws Exception {
        HashMap<String, String> aDiffs = new HashMap<String, String>(this.mDefaults);
        if (!this.mTopNodeName.equalsIgnoreCase("AttributeSources")) {
            aDiffs.put("Source", "0");
        }
        if (this.mTopNodeName.equalsIgnoreCase("JoinGroups") || this.mTopNodeName.equalsIgnoreCase("DynamicAddGroups")) {
            aDiffs.put("AttributeSources", "0");
        }
        if (this.mTopNodeName.equalsIgnoreCase("ProvisioningGroups")) {
            aDiffs.put("AddUpdateDS", "0");
            aDiffs.put("ModUpdateDS", "0");
            aDiffs.put("DeleteUpdateDS", "0");
        }
        return aDiffs;
    }

    public void findAndVerifyTopNode(Node fromHere) throws Exception {
        NodeList nl = null;
        try {
            Node node;
            if (fromHere == null) {
                Document document = VerifierUtil.getDocument();
                nl = document.getElementsByTagName(this.mTopNodeName);
            } else {
                nl = ((Element)fromHere).getElementsByTagName(this.mTopNodeName);
            }
            if (nl.getLength() > 0 && (node = nl.item(0)) != null) {
                this.verifyGivenTopNode(node);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update <" + this.mTopNodeName + "> - " + e, 2);
        }
    }

    public void verifyGivenTopNode(Node node) throws Exception {
        String outputId = "";
        try {
            NodeList nl = ((Element)node).getElementsByTagName("Record");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node recordNode = nl.item(i);
                if (recordNode.getParentNode() != node || recordNode == null) continue;
                this.verifySingleNode(recordNode);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update " + outputId + " - " + e, 2);
        }
    }

    public void verifySingleNode(Node recordNode) throws Exception {
        String outputId = "";
        try {
            AttributeSource attrs;
            String[] idkeys = new String[]{"ID", "Name"};
            HashMap idHash = VerifierUtil.getObjectIdentification(recordNode, idkeys);
            String recID = (String)idHash.get("ID");
            String recName = (String)idHash.get("Name");
            if (recID == null || recID.length() == 0) {
                recID = "" + VerifierUtil.getLargestID();
                idHash.put("ID", recID);
                if (recName == null || recName.length() == 0) {
                    recName = "Generated by verifier (ID=" + recID + ")";
                    idHash.put("Name", recName);
                }
            }
            outputId = VerifierUtil.getOutputId(this.mTopNodeName, idHash, idkeys);
            VerifierUtil.doTheMagic(recordNode, this.initDiffs(), idHash, idkeys, outputId);
            if (!this.mTopNodeName.equalsIgnoreCase("AttributeSources")) {
                DSGroups_Util.verifySources(recordNode, this.mTopNodeName);
            }
            if ((this.mTopNodeName.equalsIgnoreCase("JoinGroups") || this.mTopNodeName.equalsIgnoreCase("DynamicAddGroups")) && (attrs = new AttributeSource()).init()) {
                attrs.verifyNode(recordNode);
            }
            if (this.mTopNodeName.equalsIgnoreCase("ProvisioningGroups")) {
                DSGroups_Util.verifyProvisioningTargets(recordNode, "AddUpdateDS");
                DSGroups_Util.verifyProvisioningTargets(recordNode, "ModUpdateDS");
                DSGroups_Util.verifyProvisioningTargets(recordNode, "DeleteUpdateDS");
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update " + outputId + " - " + e, 2);
        }
    }
}

