/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Configurator;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.ReverseTokenizer;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.Token;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.XMLFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;

public class PropertiesConfigurator
extends Configurator {
    static String version = "$Id: //sapmarkets/Logging/630_SP_REL/src/_Logging/java/com/sap/tc/logging/PropertiesConfigurator.java#9 $";
    protected static final String NO_PROPERTIES_EMSG = "No properties";
    protected static final String INVALID_PROPS_FILE = "Invalid logging properties filename: {0}, but application should still run properly";
    protected static final String SYNTAX_ERR_EMSG = "Invalid logging configuration: syntax error: see console for details";
    protected static final String SEMANTICS_ERR_EMSG = "Invalid logging configuration: semantics error: see console for details";
    protected static final String SYNTAX_ERR_IN_KEY_MSG = "Invalid logging configuration: key ''{0}'': not a valid key or wrong syntax. {1}";
    protected static final String SYNTAX_ERR_IN_VAL_MSG = "Invalid logging configuration: value of key ''{0}'': wrong syntax or type. {1}";
    protected static final String UNKNOWN_CLASS_MSG = "Invalid logging configuration: unknown class ''{0}''. {1}";
    protected static final String NO_PATTERN_MSG = "Invalid logging configuration: no pattern defined by log[{0}]. {1}";
    protected static final String NO_LIMIT_MSG = "Invalid logging configuration: no limit for log[{0}]. {1}";
    protected static final String NO_CNT_MSG = "Invalid logging configuration: no count for log[{0}]. {1}";
    protected static final String UNKNOWN_FORMATTER_MSG = "Invalid logging configuration: unknown formatter[{0}] for log[{1}]. {2}";
    protected static final String UNKNOWN_LOG_MSG = "Invalid logging configuration: unknown log[{0}] for controller {1}. {2}";
    private Properties properties;
    private File file;
    private long lastConfigured = 0L;
    private static final int NORMAL_LOGS = 0;
    private static final int LOCAL_LOGS = 1;
    private static final int PRIVATE_LOGS = 2;
    private static final int NO_LOGS = 3;
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$PropertiesConfigurator == null ? (class$com$sap$tc$logging$PropertiesConfigurator = PropertiesConfigurator.class$("com.sap.tc.logging.PropertiesConfigurator")) : class$com$sap$tc$logging$PropertiesConfigurator);
    static /* synthetic */ Class class$com$sap$tc$logging$PropertiesConfigurator;

    public PropertiesConfigurator(Properties properties) {
        String method = "PropertiesConfigurator(java.util.Properties)";
        if (properties != null) {
            this.properties = properties;
            this.file = null;
        } else {
            LoggingManager.getLog().errorT(classLoc, "PropertiesConfigurator(java.util.Properties)", "Invalid logging configuration: no properties object");
            this.handleException(new IllegalArgumentException(NO_PROPERTIES_EMSG));
        }
    }

    public PropertiesConfigurator(Properties properties, ClassLoader classLoader) {
        super(classLoader);
        String method = "PropertiesConfigurator(java.util.Properties,java.lang.ClassLoader)";
        if (properties != null) {
            this.properties = properties;
            this.file = null;
        } else {
            LoggingManager.getLog().errorT(classLoc, "PropertiesConfigurator(java.util.Properties,java.lang.ClassLoader)", "Invalid logging configuration: no properties object");
            this.handleException(new IllegalArgumentException(NO_PROPERTIES_EMSG));
        }
    }

    public PropertiesConfigurator(File file) {
        String method = "PropertiesConfigurator(java.io.File)";
        if (file != null) {
            this.properties = null;
            this.file = file;
        } else {
            LoggingManager.getLog().errorT(classLoc, "PropertiesConfigurator(java.io.File)", "Invalid logging configuration: no properties file provided");
            this.handleException(new IllegalArgumentException(NO_PROPERTIES_EMSG));
        }
    }

    public PropertiesConfigurator(File file, ClassLoader classLoader) {
        super(classLoader);
        String method = "PropertiesConfigurator(java.io.File,java.lang.ClassLoader)";
        if (file != null) {
            this.properties = null;
            this.file = file;
        } else {
            LoggingManager.getLog().errorT(classLoc, "PropertiesConfigurator(java.io.File,java.lang.ClassLoader)", "Invalid logging configuration: no properties file provided");
            this.handleException(new IllegalArgumentException(NO_PROPERTIES_EMSG));
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        String method = "setProperties(java.util.Properties)";
        if (properties != null) {
            this.properties = properties;
            this.file = null;
        } else {
            LoggingManager.getLog().errorT(classLoc, "setProperties(java.util.Properties)", "Invalid logging configuration: no properties object");
            this.handleException(new IllegalArgumentException(NO_PROPERTIES_EMSG));
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        String method = "setFile(java.io.File)";
        if (file != null) {
            this.properties = null;
            this.file = file;
        } else {
            LoggingManager.getLog().errorT(classLoc, "setFile(java.io.File)", "Invalid logging configuration: no properties file provided");
            this.handleException(new IllegalArgumentException(NO_PROPERTIES_EMSG));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure() {
        block122: {
            Object entry;
            String method = "configure()";
            if (this.properties == null && this.file == null) break block122;
            Properties currProperties = null;
            if (this.properties != null) {
                currProperties = this.properties;
            } else if (this.file != null) {
                currProperties = new Properties();
                try {
                    if (!this.file.exists()) {
                        LoggingManager.getLog().setMaximumSeverity(300);
                        LoggingManager.getLog().infoT(classLoc, "configure()", INVALID_PROPS_FILE, new Object[]{this.file.getAbsoluteFile()});
                        LoggingManager.getLog().setMaximumSeverity(500);
                        this.handleException(new FileNotFoundException(this.file.getAbsolutePath()));
                        return;
                    }
                    if (this.file.lastModified() > this.lastConfigured) {
                        FileInputStream propStream = new FileInputStream(this.file);
                        currProperties.load(propStream);
                        propStream.close();
                        propStream = null;
                        this.lastConfigured = this.file.lastModified();
                    }
                }
                catch (Exception exc) {
                    this.handleException(exc);
                }
            }
            HashMap<String, Object> formatters = new HashMap<String, Object>();
            HashMap<String, Object> logs = new HashMap<String, Object>();
            HashMap<String, LogControllerEntry> controllers = new HashMap<String, LogControllerEntry>();
            Iterator iter = ((Hashtable)currProperties).entrySet().iterator();
            block60: while (iter.hasNext()) {
                Attr attr;
                Object accEntry;
                entry = iter.next();
                Key key = this.parseKey((String)entry.getKey());
                String value = (String)entry.getValue();
                if (key == null) continue;
                if (key instanceof LogControllerKey) {
                    LogControllerKey controllerKey = (LogControllerKey)key;
                    LogController controller = controllerKey.getController();
                    LogControllerEntry accEntry2 = (LogControllerEntry)controllers.get(controller.getName());
                    if (accEntry2 == null) {
                        accEntry2 = new LogControllerEntry(controller);
                        controllers.put(controller.getName(), accEntry2);
                    }
                    Attr attr2 = controllerKey.getAttr();
                    switch (attr2.getAttr()) {
                        case 16: {
                            LogController relative = ((SeverityAttr)attr2).getRelative();
                            if (relative == null) {
                                accEntry2.setEffectiveSeverity(this.parseSeverity(value, (String)entry.getKey()));
                                break;
                            }
                            accEntry2.setEffectiveRelationSeverity(relative, this.parseSeverity(value, (String)entry.getKey()));
                            break;
                        }
                        case 28: {
                            LogController relative = ((SeverityAttr)attr2).getRelative();
                            if (relative == null) {
                                accEntry2.setMinimumSeverity(this.parseSeverity(value, (String)entry.getKey()));
                                break;
                            }
                            accEntry2.setMinimumRelationSeverity(relative, this.parseSeverity(value, (String)entry.getKey()));
                            break;
                        }
                        case 27: {
                            LogController relative = ((SeverityAttr)attr2).getRelative();
                            if (relative == null) {
                                accEntry2.setMaximumSeverity(this.parseSeverity(value, (String)entry.getKey()));
                                break;
                            }
                            accEntry2.setMaximumRelationSeverity(relative, this.parseSeverity(value, (String)entry.getKey()));
                            break;
                        }
                        case 26: {
                            accEntry2.setLogs(this.parseObjects(value, (String)entry.getKey()));
                            break;
                        }
                        case 24: {
                            accEntry2.setLocalLogs(this.parseObjects(value, (String)entry.getKey()));
                            break;
                        }
                        case 31: {
                            accEntry2.setPrivateLogs(this.parseObjects(value, (String)entry.getKey()));
                            break;
                        }
                        case 20: {
                            accEntry2.setFilters(this.parseObjects(value, (String)entry.getKey()));
                            break;
                        }
                        case 12: {
                            accEntry2.setResourceBundleName(value);
                            break;
                        }
                    }
                    continue;
                }
                if (key instanceof LogRefKey) {
                    LogRefKey logRefKey = (LogRefKey)key;
                    accEntry = (LogEntry)logs.get(logRefKey.getName());
                    if (accEntry == null) {
                        accEntry = new LogEntry();
                        logs.put(logRefKey.getName(), accEntry);
                    }
                    if ((attr = logRefKey.getAttr()) != null) {
                        switch (attr.getAttr()) {
                            case 10: {
                                ((LogEntry)accEntry).setAppend(this.parseBoolean(value, (String)entry.getKey()));
                                break;
                            }
                            case 11: {
                                ((LogEntry)accEntry).setAutoFlush(this.parseBoolean(value, (String)entry.getKey()));
                                break;
                            }
                            case 16: {
                                ((LogEntry)accEntry).setEffectiveSeverity(this.parseSeverity(value, (String)entry.getKey()));
                                break;
                            }
                            case 17: {
                                ((LogEntry)accEntry).setEncoding(value);
                                break;
                            }
                            case 15: {
                                ((LogEntry)accEntry).setDesc(value);
                                break;
                            }
                            case 20: {
                                ((LogEntry)accEntry).setFilters(this.parseObjects(value, (String)entry.getKey()));
                                break;
                            }
                            case 21: {
                                ((LogEntry)accEntry).setFormatter(this.parseObjects(value, (String)entry.getKey()));
                                break;
                            }
                            case 29: {
                                ((LogEntry)accEntry).setPattern(value);
                                break;
                            }
                            case 22: {
                                try {
                                    ((LogEntry)accEntry).setLimit(Integer.parseInt(value));
                                }
                                catch (NumberFormatException e) {
                                    LoggingManager.getLog().errorT(classLoc, "configure()", SYNTAX_ERR_IN_VAL_MSG, new Object[]{(String)entry.getKey(), this.file == null ? "" : this.file.getAbsolutePath()});
                                    this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                                }
                                break;
                            }
                            case 13: {
                                try {
                                    ((LogEntry)accEntry).setCnt(Integer.parseInt(value));
                                }
                                catch (NumberFormatException e) {
                                    LoggingManager.getLog().errorT(classLoc, "configure()", SYNTAX_ERR_IN_VAL_MSG, new Object[]{(String)entry.getKey(), this.file == null ? "" : this.file.getAbsolutePath()});
                                    this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                                }
                                continue block60;
                            }
                        }
                        continue;
                    }
                    ((LogEntry)accEntry).setObject(this.parseObjects(value, (String)entry.getKey()));
                    continue;
                }
                if (!(key instanceof FormatterRefKey)) continue;
                FormatterRefKey formatterRefKey = (FormatterRefKey)key;
                accEntry = (FormatterEntry)formatters.get(formatterRefKey.getName());
                if (accEntry == null) {
                    accEntry = new FormatterEntry();
                    formatters.put(formatterRefKey.getName(), accEntry);
                }
                if ((attr = formatterRefKey.getAttr()) != null) {
                    switch (attr.getAttr()) {
                        case 29: {
                            ((FormatterEntry)accEntry).setPattern(value);
                            break;
                        }
                    }
                    continue;
                }
                ((FormatterEntry)accEntry).setObject(this.parseObjects(value, (String)entry.getKey()));
            }
            iter = formatters.values().iterator();
            block61: while (iter.hasNext()) {
                entry = (FormatterEntry)((Object)iter.next());
                if (((FormatterEntry)entry).getObject() != null) {
                    ObjectVal object = (ObjectVal)((FormatterEntry)entry).getObject().getObjects().iterator().next();
                    if (object instanceof ClassVal) {
                        ClassVal cl = (ClassVal)object;
                        switch (cl.getType()) {
                            case 33: {
                                if (((FormatterEntry)entry).getPattern() != null) {
                                    ((FormatterEntry)entry).setFormatter(new TraceFormatter(((FormatterEntry)entry).getPattern()));
                                    break;
                                }
                                ((FormatterEntry)entry).setFormatter(new TraceFormatter());
                                break;
                            }
                            case 23: {
                                ((FormatterEntry)entry).setFormatter(new ListFormatter());
                                break;
                            }
                            case 35: {
                                ((FormatterEntry)entry).setFormatter(new XMLFormatter());
                                break;
                            }
                            case 2: {
                                try {
                                    Formatter formatter = (Formatter)this.getClassLoader().loadClass(((CustomClassVal)cl).getIdent()).newInstance();
                                    ((FormatterEntry)entry).setFormatter(formatter);
                                    if (!(formatter instanceof TraceFormatter)) continue block61;
                                    ((TraceFormatter)formatter).setPattern(((FormatterEntry)entry).getPattern());
                                }
                                catch (Exception e) {
                                    LoggingManager.getLog().errorT(classLoc, "configure()", UNKNOWN_CLASS_MSG, new Object[]{((CustomClassVal)cl).getIdent(), this.file == null ? "" : this.file.getAbsolutePath()});
                                    this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                }
                                break;
                            }
                            default: {
                                iter.remove();
                                break;
                            }
                        }
                        continue;
                    }
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
            iter = logs.entrySet().iterator();
            while (iter.hasNext()) {
                Log log;
                LogEntry entry2;
                block123: {
                    ObjectVal object;
                    String name;
                    block124: {
                        Iterator formatterIter;
                        Map.Entry mapEntry = iter.next();
                        name = (String)mapEntry.getKey();
                        entry2 = (LogEntry)mapEntry.getValue();
                        log = null;
                        if (entry2.getObject() == null) continue;
                        object = (ObjectVal)entry2.getObject().getObjects().iterator().next();
                        if (object instanceof ClassVal) {
                            ClassVal cl = (ClassVal)object;
                            switch (cl.getType()) {
                                case 19: {
                                    if (entry2.getPattern() != null) {
                                        int limit = 0;
                                        int cnt = 0;
                                        if (entry2.getLimit() > 0 && entry2.getCnt() > 0) {
                                            limit = entry2.getLimit();
                                            cnt = entry2.getCnt();
                                        } else {
                                            if (entry2.getLimit() > 0) {
                                                LoggingManager.getLog().errorT(classLoc, "configure()", NO_CNT_MSG, new Object[]{name, this.file == null ? "" : this.file.getAbsolutePath()});
                                                this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                            }
                                            if (entry2.getCnt() > 0) {
                                                LoggingManager.getLog().errorT(classLoc, "configure()", NO_LIMIT_MSG, new Object[]{name, this.file == null ? "" : this.file.getAbsolutePath()});
                                                this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                            }
                                        }
                                        log = new FileLog(entry2.getPattern(), limit, cnt);
                                        if (entry2.getAppend() != null) {
                                            ((FileLog)log).setAppend(entry2.getAppend().getBoolean());
                                        }
                                        break;
                                    } else {
                                        iter.remove();
                                        LoggingManager.getLog().errorT(classLoc, "configure()", NO_PATTERN_MSG, new Object[]{name, this.file == null ? "" : this.file.getAbsolutePath()});
                                        this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                        break;
                                    }
                                }
                                case 14: {
                                    log = new ConsoleLog();
                                    break;
                                }
                                case 2: {
                                    try {
                                        log = (Log)this.getClassLoader().loadClass(((CustomClassVal)cl).getIdent()).newInstance();
                                        if (log instanceof FileLog) {
                                            FileLog fileLog = (FileLog)log;
                                            if (entry2.getPattern() != null) {
                                                fileLog.setPattern(entry2.getPattern());
                                            }
                                            if (entry2.getLimit() > 0 && entry2.getCnt() > 0) {
                                                fileLog.setRotation(entry2.getLimit(), entry2.getCnt());
                                            } else {
                                                if (entry2.getLimit() > 0) {
                                                    LoggingManager.getLog().errorT(classLoc, "configure()", NO_CNT_MSG, new Object[]{name, this.file == null ? "" : this.file.getAbsolutePath()});
                                                    this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                                }
                                                if (entry2.getCnt() > 0) {
                                                    LoggingManager.getLog().errorT(classLoc, "configure()", NO_LIMIT_MSG, new Object[]{name, this.file == null ? "" : this.file.getAbsolutePath()});
                                                    this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                                }
                                            }
                                            if (entry2.getAppend() != null) {
                                                fileLog.setAppend(entry2.getAppend().getBoolean());
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LoggingManager.getLog().errorT(classLoc, "configure()", UNKNOWN_CLASS_MSG, new Object[]{((CustomClassVal)cl).getIdent(), this.file == null ? "" : this.file.getAbsolutePath()});
                                        this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                    }
                                    break;
                                }
                                default: {
                                    iter.remove();
                                    break;
                                }
                            }
                        } else {
                            iter.remove();
                        }
                        if (log == null) continue;
                        if (entry2.getEffectiveSeverity() != null) {
                            log.setEffectiveSeverity(entry2.getEffectiveSeverity().getSeverity());
                        }
                        if (entry2.getEncoding() != null) {
                            log.setEncoding(entry2.getEncoding());
                        }
                        if (entry2.getDesc() != null) {
                            log.setName(entry2.getDesc());
                        }
                        if (entry2.getFilters() != null) {
                            if (!entry2.getFilters().isAdding()) {
                                log.removeFilters();
                            }
                            Iterator filterIter = entry2.getFilters().getObjects().iterator();
                            while (filterIter.hasNext()) {
                                ClassVal filter;
                                object = (ObjectVal)filterIter.next();
                                if (!(object instanceof ClassVal) || (filter = (ClassVal)object).getType() != 2) continue;
                                try {
                                    log.addFilter((Filter)this.getClassLoader().loadClass(((CustomClassVal)filter).getIdent()).newInstance());
                                }
                                catch (Exception e) {
                                    LoggingManager.getLog().errorT(classLoc, "configure()", UNKNOWN_CLASS_MSG, new Object[]{((CustomClassVal)filter).getIdent(), this.file == null ? "" : this.file.getAbsolutePath()});
                                    this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                }
                            }
                        }
                        if (entry2.getFormatter() == null || !(formatterIter = entry2.getFormatter().getObjects().iterator()).hasNext()) break block123;
                        object = (ObjectVal)formatterIter.next();
                        if (!(object instanceof ClassVal)) break block124;
                        ClassVal formatter = (ClassVal)object;
                        switch (formatter.getType()) {
                            case 33: {
                                log.setFormatter(new TraceFormatter());
                                break;
                            }
                            case 23: {
                                log.setFormatter(new ListFormatter());
                                break;
                            }
                            case 35: {
                                log.setFormatter(new XMLFormatter());
                                break;
                            }
                            case 2: {
                                try {
                                    log.setFormatter((Formatter)this.getClassLoader().loadClass(((CustomClassVal)formatter).getIdent()).newInstance());
                                }
                                catch (Exception e) {
                                    LoggingManager.getLog().errorT(classLoc, "configure()", UNKNOWN_CLASS_MSG, new Object[]{((CustomClassVal)formatter).getIdent(), this.file == null ? "" : this.file.getAbsolutePath()});
                                    this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                                }
                            }
                        }
                        break block123;
                    }
                    if (object instanceof FormatterRefVal) {
                        FormatterRefVal ref = (FormatterRefVal)object;
                        try {
                            log.setFormatter(((FormatterEntry)formatters.get(ref.getName())).getFormatter());
                        }
                        catch (NullPointerException e) {
                            LoggingManager.getLog().errorT(classLoc, "configure()", UNKNOWN_FORMATTER_MSG, new Object[]{ref.getName(), name, this.file == null ? "" : this.file.getAbsolutePath()});
                            this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                        }
                    }
                }
                if (entry2.getAutoFlush() != null) {
                    log.setAutoFlush(entry2.getAutoFlush().getBoolean());
                }
                entry2.setLog(log);
            }
            iter = controllers.values().iterator();
            while (iter.hasNext()) {
                Iterator newLogsIter;
                LinkedList newLogs;
                Map.Entry severity;
                entry = (LogControllerEntry)((Object)iter.next());
                LogController controller = ((LogControllerEntry)entry).getController();
                if (((LogControllerEntry)entry).getEffectiveSeverity() != null) {
                    controller.setEffectiveSeverity(((LogControllerEntry)entry).getEffectiveSeverity().getSeverity());
                }
                if (((LogControllerEntry)entry).getMinimumSeverity() != null) {
                    controller.setMinimumSeverity(((LogControllerEntry)entry).getMinimumSeverity().getSeverity());
                }
                if (((LogControllerEntry)entry).getMaximumSeverity() != null) {
                    controller.setMaximumSeverity(((LogControllerEntry)entry).getMaximumSeverity().getSeverity());
                }
                Iterator severitiesIter = ((LogControllerEntry)entry).getEffectiveRelationSeverities().entrySet().iterator();
                while (severitiesIter.hasNext()) {
                    severity = severitiesIter.next();
                    controller.setEffectiveSeverity((LogController)severity.getKey(), ((SeverityVal)severity.getValue()).getSeverity());
                }
                severitiesIter = ((LogControllerEntry)entry).getMinimumRelationSeverities().entrySet().iterator();
                while (severitiesIter.hasNext()) {
                    severity = severitiesIter.next();
                    controller.setMinimumSeverity((LogController)severity.getKey(), ((SeverityVal)severity.getValue()).getSeverity());
                }
                severitiesIter = ((LogControllerEntry)entry).getMaximumRelationSeverities().entrySet().iterator();
                while (severitiesIter.hasNext()) {
                    severity = severitiesIter.next();
                    controller.setMaximumSeverity((LogController)severity.getKey(), ((SeverityVal)severity.getValue()).getSeverity());
                }
                ObjectsVal objects = ((LogControllerEntry)entry).getLogs();
                if (objects != null) {
                    newLogs = this.computeLogs(0, objects, controller, logs);
                    newLogsIter = newLogs.iterator();
                    while (newLogsIter.hasNext()) {
                        controller.addLog((Log)newLogsIter.next());
                    }
                }
                if ((objects = ((LogControllerEntry)entry).getLocalLogs()) != null) {
                    newLogs = this.computeLogs(1, objects, controller, logs);
                    newLogsIter = newLogs.iterator();
                    while (newLogsIter.hasNext()) {
                        controller.addLocalLog((Log)newLogsIter.next());
                    }
                }
                if ((objects = ((LogControllerEntry)entry).getPrivateLogs()) != null) {
                    newLogs = this.computeLogs(2, objects, controller, logs);
                    newLogsIter = newLogs.iterator();
                    while (newLogsIter.hasNext()) {
                        controller.addPrivateLog((Log)newLogsIter.next());
                    }
                }
                if (((LogControllerEntry)entry).getFilters() != null) {
                    if (!((LogControllerEntry)entry).getFilters().isAdding()) {
                        controller.removeFilters();
                    }
                    Iterator filterIter = ((LogControllerEntry)entry).getFilters().getObjects().iterator();
                    while (filterIter.hasNext()) {
                        ClassVal filter;
                        ObjectVal object = (ObjectVal)filterIter.next();
                        if (!(object instanceof ClassVal) || (filter = (ClassVal)object).getType() != 2) continue;
                        try {
                            controller.addFilter((Filter)this.getClassLoader().loadClass(((CustomClassVal)filter).getIdent()).newInstance());
                        }
                        catch (Exception e) {
                            LoggingManager.getLog().errorT(classLoc, "configure()", UNKNOWN_CLASS_MSG, new Object[]{((CustomClassVal)filter).getIdent(), this.file == null ? "" : this.file.getAbsolutePath()});
                            this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                        }
                    }
                }
                if (((LogControllerEntry)entry).getResourceBundleName() == null) continue;
                controller.setResourceBundleName(((LogControllerEntry)entry).getResourceBundleName());
            }
        }
    }

    public void initConfigure() throws IllegalArgumentException, FileNotFoundException, IOException, Exception {
        if (this.file == null && this.properties == null) {
            throw new IllegalArgumentException(NO_PROPERTIES_EMSG);
        }
        Exception oldExc = this.getException();
        this.configure();
        Exception exc = this.getException();
        if (exc != null && exc != oldExc) {
            if (exc instanceof FileNotFoundException) {
                throw (FileNotFoundException)exc;
            }
            if (exc instanceof IOException) {
                throw (IOException)exc;
            }
            throw exc;
        }
    }

    private LinkedList computeLogs(int type, ObjectsVal objects, LogController controller, HashMap logs) {
        String method = "computeLogs(int,ObjectsVal,LogController,java.util.HashMap)";
        Iterator logsIter = objects.getObjects().iterator();
        LinkedList<Log> newLogs = new LinkedList<Log>();
        while (logsIter.hasNext()) {
            ObjectVal object = (ObjectVal)logsIter.next();
            if (object instanceof ClassVal) {
                ClassVal log = (ClassVal)object;
                switch (log.getType()) {
                    case 14: {
                        newLogs.add(new ConsoleLog());
                        break;
                    }
                    case 2: {
                        try {
                            newLogs.add((Log)this.getClassLoader().loadClass(((CustomClassVal)log).getIdent()).newInstance());
                            break;
                        }
                        catch (Exception e) {
                            LoggingManager.getLog().errorT(classLoc, "computeLogs(int,ObjectsVal,LogController,java.util.HashMap)", UNKNOWN_CLASS_MSG, new Object[]{((CustomClassVal)log).getIdent(), this.file == null ? "" : this.file.getAbsolutePath()});
                            this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
                        }
                    }
                }
                continue;
            }
            if (!(object instanceof LogRefVal)) continue;
            LogRefVal ref = (LogRefVal)object;
            Object entry = logs.get(ref.getName());
            if (entry != null) {
                newLogs.add((Log)entry);
                continue;
            }
            LoggingManager.getLog().errorT(classLoc, "computeLogs(int,ObjectsVal,LogController,java.util.HashMap)", UNKNOWN_LOG_MSG, new Object[]{ref.getName(), controller.getName(), this.file == null ? "" : this.file.getAbsolutePath()});
            this.handleException(new IllegalArgumentException(SEMANTICS_ERR_EMSG));
        }
        int curr = 0;
        while (curr < 3) {
            Iterator prevLogsIter;
            switch (curr) {
                case 0: {
                    prevLogsIter = controller.getLogs().iterator();
                    break;
                }
                case 1: {
                    prevLogsIter = controller.getLocalLogs().iterator();
                    break;
                }
                case 2: {
                    prevLogsIter = controller.getPrivateLogs().iterator();
                    break;
                }
                default: {
                    prevLogsIter = null;
                    break;
                }
            }
            while (prevLogsIter.hasNext()) {
                Log log = (Log)prevLogsIter.next();
                boolean found = false;
                ListIterator newLogsIter = newLogs.listIterator();
                while (newLogsIter.hasNext()) {
                    Object nextLog = newLogsIter.next();
                    if (nextLog instanceof Log) {
                        if (!log.equals((Log)nextLog)) continue;
                        found = true;
                        newLogsIter.remove();
                        continue;
                    }
                    LogEntry newLogEntry = (LogEntry)nextLog;
                    Log newLog = newLogEntry.getLog();
                    if (!log.equals(newLog)) continue;
                    found = true;
                    newLogsIter.remove();
                    if (newLogEntry.getEffectiveSeverity() != null) {
                        log.setEffectiveSeverity(newLogEntry.getEffectiveSeverity().getSeverity());
                    }
                    if (newLogEntry.getEncoding() != null) {
                        log.setEncoding(newLog.getEncoding());
                    }
                    if (newLogEntry.getDesc() != null) {
                        log.setName(newLog.getName());
                    }
                    if (newLogEntry.getFilters() != null) {
                        Iterator filterIter = newLog.getFilters().iterator();
                        log.removeFilters();
                        while (filterIter.hasNext()) {
                            log.addFilter((Filter)filterIter.next());
                        }
                    }
                    if (newLogEntry.getFormatter() != null) {
                        log.setFormatter(newLog.getFormatter());
                    }
                    if (newLogEntry.getAutoFlush() != null) {
                        log.setAutoFlush(newLog.isAutoFlush());
                    }
                    if (!(log instanceof FileLog)) continue;
                    if (newLogEntry.isLimitSet() || newLogEntry.isCntSet()) {
                        ((FileLog)log).setRotation(((FileLog)newLog).getLimit(), ((FileLog)newLog).getCnt());
                    }
                    if (newLogEntry.getAppend() == null) continue;
                    ((FileLog)log).setAppend(newLogEntry.getAppend().getBoolean());
                }
                if (found) {
                    newLogs.add(log);
                    continue;
                }
                if (curr != type || objects.isAdding()) continue;
                controller.removeLog(log);
            }
            ++curr;
        }
        ListIterator<Log> newLogsIter = newLogs.listIterator();
        while (newLogsIter.hasNext()) {
            Object newLog = newLogsIter.next();
            if (!(newLog instanceof LogEntry)) continue;
            newLogsIter.remove();
            newLogsIter.add(((LogEntry)newLog).getLog());
        }
        return newLogs;
    }

    protected Key parseKey(String key) {
        String method = "parseKey(java.lang.String)";
        PCTokenizer tokenizer = new PCTokenizer(key);
        switch (tokenizer.getLookahead().getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                ReverseTokenizer reverseTokenizer = new ReverseTokenizer(tokenizer);
                Token token = reverseTokenizer.nextToken();
                if (token.getType() == 9) {
                    int level = 1;
                    while (level > 0) {
                        token = reverseTokenizer.nextToken();
                        if (token.getType() == 8) {
                            --level;
                            continue;
                        }
                        if (token.getType() == 9) {
                            ++level;
                            continue;
                        }
                        if (token.getType() != 0) continue;
                        LoggingManager.getLog().errorT(classLoc, "parseKey(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                        return null;
                    }
                    token = reverseTokenizer.nextToken();
                    if (token.getType() != 16 && token.getType() != 28 && token.getType() != 27) {
                        LoggingManager.getLog().errorT(classLoc, "parseKey(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                        return null;
                    }
                } else if (token.getType() != 16 && token.getType() != 28 && token.getType() != 27 && token.getType() != 26 && token.getType() != 24 && token.getType() != 31 && token.getType() != 20 && token.getType() != 12) {
                    LoggingManager.getLog().errorT(classLoc, "parseKey(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                    this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                    return null;
                }
                if (reverseTokenizer.nextToken().getType() == 4) {
                    LogController controller = this.parseLogController(reverseTokenizer.getContent(), tokenizer.getFullContent());
                    if (controller != null) {
                        tokenizer = new PCTokenizer(reverseTokenizer.getAcceptedContent());
                        tokenizer.nextToken();
                        Attr attr = this.parseLogControllerAttr(tokenizer);
                        if (attr != null) {
                            return new LogControllerKey(controller, attr);
                        }
                        return null;
                    }
                    return null;
                }
            }
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                return new LogControllerKey(Location.getRoot(), this.parseLogControllerAttr(tokenizer));
            }
            case 25: {
                String name = this.parseLog(tokenizer, null);
                if (name != null) {
                    Token token = tokenizer.nextToken();
                    if (token.getType() == 4) {
                        Attr attr = this.parseLogAttr(tokenizer);
                        if (attr != null) {
                            if (tokenizer.nextToken().getType() == 0) {
                                return new LogRefKey(name, attr);
                            }
                            LoggingManager.getLog().errorT(classLoc, "parseKey(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                            this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                            return null;
                        }
                        return null;
                    }
                    if (token.getType() == 0) {
                        return new LogRefKey(name);
                    }
                    LoggingManager.getLog().errorT(classLoc, "parseKey(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                    this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                    return null;
                }
                return null;
            }
            case 21: {
                String name = this.parseFormatter(tokenizer, null);
                if (name != null) {
                    Token token = tokenizer.nextToken();
                    if (token.getType() == 4) {
                        Attr attr = this.parseFormatterAttr(tokenizer);
                        if (attr != null) {
                            if (tokenizer.nextToken().getType() == 0) {
                                return new FormatterRefKey(name, attr);
                            }
                            LoggingManager.getLog().errorT(classLoc, "parseKey(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                            this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                            return null;
                        }
                        return null;
                    }
                    if (token.getType() == 0) {
                        return new FormatterRefKey(name);
                    }
                    LoggingManager.getLog().errorT(classLoc, "parseKey(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                    this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                    return null;
                }
                return null;
            }
        }
        LoggingManager.getLog().errorT(classLoc, "parseKey(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    protected LogController parseLogController(String name, String forKey) {
        String method = "parseLogController(java.lang.String)";
        try {
            if (new PCTokenizer(name).getLookahead().getType() != 5) {
                return Location.getLocation(name);
            }
            return Category.getCategoryInt(name);
        }
        catch (IllegalArgumentException e) {
            LoggingManager.getLog().errorT(classLoc, "parseLogController(java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
            this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
            return null;
        }
    }

    protected Attr parseLogControllerAttr(PCTokenizer tokenizer) {
        String method = "parseLogControllerAttr(PCTokenizer)";
        Token token = tokenizer.nextToken();
        switch (token.getType()) {
            case 16: 
            case 27: 
            case 28: {
                if (tokenizer.getLookahead().getType() == 8) {
                    tokenizer.nextToken();
                    ReverseTokenizer reverseTokenizer = new ReverseTokenizer(tokenizer);
                    if (reverseTokenizer.nextToken().getType() == 9) {
                        LogController controller = this.parseLogController(reverseTokenizer.getContent(), tokenizer.getFullContent());
                        if (controller != null) {
                            return new SeverityAttr(token.getType(), controller);
                        }
                        return null;
                    }
                    LoggingManager.getLog().errorT(classLoc, "parseLogControllerAttr(PCTokenizer)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                    this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                    return null;
                }
                return new SeverityAttr(token.getType());
            }
            case 12: 
            case 20: 
            case 24: 
            case 26: 
            case 31: {
                return new Attr(token.getType());
            }
        }
        LoggingManager.getLog().errorT(classLoc, "parseLogControllerAttr(PCTokenizer)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    protected String parseLog(PCTokenizer tokenizer, String forKey) {
        String method = "parseLog(PCTokenizer,java.lang.String)";
        if (tokenizer.nextToken().getType() == 25 && tokenizer.nextToken().getType() == 8) {
            Token token = tokenizer.nextToken();
            if (token.getType() == 2 || token.getType() == 1) {
                String name = token.getValue();
                if (tokenizer.nextToken().getType() == 9) {
                    return name;
                }
                if (forKey == null) {
                    LoggingManager.getLog().errorT(classLoc, "parseLog(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                } else {
                    LoggingManager.getLog().errorT(classLoc, "parseLog(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
                }
                this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                return null;
            }
            if (forKey == null) {
                LoggingManager.getLog().errorT(classLoc, "parseLog(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
            } else {
                LoggingManager.getLog().errorT(classLoc, "parseLog(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
            }
            this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
            return null;
        }
        if (forKey == null) {
            LoggingManager.getLog().errorT(classLoc, "parseLog(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
        } else {
            LoggingManager.getLog().errorT(classLoc, "parseLog(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
        }
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    protected Attr parseLogAttr(PCTokenizer tokenizer) {
        String method = "parseLogAttr(PCTokenizer)";
        Token token = tokenizer.nextToken();
        switch (token.getType()) {
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 29: {
                return new Attr(token.getType());
            }
        }
        LoggingManager.getLog().errorT(classLoc, "parseLogAttr(PCTokenizer)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    protected String parseFormatter(PCTokenizer tokenizer, String forKey) {
        String method = "parseFormatter(PCTokenizer,java.lang.String)";
        if (tokenizer.nextToken().getType() == 21 && tokenizer.nextToken().getType() == 8) {
            Token token = tokenizer.nextToken();
            if (token.getType() == 2 || token.getType() == 1) {
                String name = token.getValue();
                if (tokenizer.nextToken().getType() == 9) {
                    return name;
                }
                if (forKey == null) {
                    LoggingManager.getLog().errorT(classLoc, "parseFormatter(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
                } else {
                    LoggingManager.getLog().errorT(classLoc, "parseFormatter(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
                }
                this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                return null;
            }
            if (forKey == null) {
                LoggingManager.getLog().errorT(classLoc, "parseFormatter(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
            } else {
                LoggingManager.getLog().errorT(classLoc, "parseFormatter(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
            }
            this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
            return null;
        }
        if (forKey == null) {
            LoggingManager.getLog().errorT(classLoc, "parseFormatter(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
        } else {
            LoggingManager.getLog().errorT(classLoc, "parseFormatter(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
        }
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    protected Attr parseFormatterAttr(PCTokenizer tokenizer) {
        String method = "parseFormatterAttr(PCTokenizer)";
        Token token = tokenizer.nextToken();
        switch (token.getType()) {
            case 29: {
                return new Attr(token.getType());
            }
        }
        LoggingManager.getLog().errorT(classLoc, "parseFormatterAttr(PCTokenizer)", SYNTAX_ERR_IN_KEY_MSG, new Object[]{tokenizer.getFullContent(), this.file == null ? "" : this.file.getAbsolutePath()});
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    protected SeverityVal parseSeverity(String value, String forKey) {
        String method = "parseSeverity(java.lang.String,java.lang.String)";
        PCTokenizer tokenizer = new PCTokenizer(value);
        Token token = tokenizer.nextToken();
        if (token.getType() == 32) {
            if (tokenizer.nextToken().getType() == 4) {
                token = tokenizer.nextToken();
            } else {
                LoggingManager.getLog().errorT(classLoc, "parseSeverity(java.lang.String,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
                this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                return null;
            }
        }
        try {
            int severity = Severity.parse(token.getValue());
            if (tokenizer.nextToken().getType() == 0) {
                return new SeverityVal(severity);
            }
            LoggingManager.getLog().errorT(classLoc, "parseSeverity(java.lang.String,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
            this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
            return null;
        }
        catch (IllegalArgumentException e) {
            LoggingManager.getLog().errorT(classLoc, "parseSeverity(java.lang.String,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
            this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
            return null;
        }
    }

    protected BooleanVal parseBoolean(String value, String forKey) {
        String method = "parseBoolean(java.lang.String,java.lang.String)";
        PCTokenizer tokenizer = new PCTokenizer(value);
        switch (tokenizer.nextToken().getType()) {
            case 18: {
                return BooleanVal.FALSE;
            }
            case 34: {
                return BooleanVal.TRUE;
            }
        }
        LoggingManager.getLog().errorT(classLoc, "parseBoolean(java.lang.String,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    protected ObjectsVal parseObjects(String value, String forKey) {
        String method = "parseObjects(java.lang.String,java.lang.String)";
        PCTokenizer tokenizer = new PCTokenizer(value);
        boolean isAdding = false;
        if (tokenizer.getLookahead().getType() != 0) {
            ObjectsVal objects;
            if (tokenizer.getLookahead().getType() == 30) {
                tokenizer.nextToken();
                isAdding = true;
            }
            if ((objects = this.parseObjectList(tokenizer, forKey)) != null) {
                if (tokenizer.nextToken().getType() == 0) {
                    objects.setAdding(isAdding);
                    return objects;
                }
                LoggingManager.getLog().errorT(classLoc, "parseObjects(java.lang.String,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
                this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                return null;
            }
            return null;
        }
        return new ObjectsVal();
    }

    protected ObjectsVal parseObjectList(PCTokenizer tokenizer, String forKey) {
        String method = "parseObjectList(PCTokenizer,java.lang.String)";
        ObjectsVal objects = null;
        ObjectVal object = this.parseObject(tokenizer, forKey);
        if (object != null) {
            objects = new ObjectsVal();
            objects.addObject(object);
            while (tokenizer.getLookahead().getType() == 3) {
                tokenizer.nextToken();
                object = this.parseObject(tokenizer, forKey);
                if (object == null) continue;
                objects.addObject(object);
            }
        }
        return objects;
    }

    protected ObjectVal parseObject(PCTokenizer tokenizer, String forKey) {
        String method = "parseObject(PCTokenizer,java.lang.String)";
        switch (tokenizer.getLookahead().getType()) {
            case 1: 
            case 2: 
            case 14: 
            case 19: 
            case 23: 
            case 33: 
            case 35: {
                return this.parseClass(tokenizer, forKey);
            }
            case 25: {
                String name = this.parseLog(tokenizer, forKey);
                if (name != null) {
                    return new LogRefVal(name);
                }
                return null;
            }
            case 21: {
                String name = this.parseFormatter(tokenizer, forKey);
                if (name != null) {
                    return new FormatterRefVal(name);
                }
                return null;
            }
        }
        LoggingManager.getLog().errorT(classLoc, "parseObject(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    protected ClassVal parseClass(PCTokenizer tokenizer, String forKey) {
        String method = "parseClass(PCTokenizer,java.lang.String)";
        Token token = tokenizer.nextToken();
        switch (token.getType()) {
            case 14: 
            case 19: 
            case 23: 
            case 33: 
            case 35: {
                return new ClassVal(token.getType());
            }
            case 1: 
            case 2: {
                String ident = token.getValue();
                while (tokenizer.getLookahead().getType() == 4) {
                    tokenizer.nextToken();
                    token = tokenizer.nextToken();
                    if (token.getType() == 2 || token.getType() == 1) {
                        ident = ident + "." + token.getValue();
                        continue;
                    }
                    LoggingManager.getLog().errorT(classLoc, "parseClass(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
                    this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
                    return null;
                }
                return new CustomClassVal(ident);
            }
        }
        LoggingManager.getLog().errorT(classLoc, "parseClass(PCTokenizer,java.lang.String)", SYNTAX_ERR_IN_VAL_MSG, new Object[]{forKey, this.file == null ? "" : this.file.getAbsolutePath()});
        this.handleException(new IllegalArgumentException(SYNTAX_ERR_EMSG));
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Tokenizer
    extends com.sap.tc.logging.Tokenizer {
        public Tokenizer(String content) {
            super(content);
        }

        public Token nextTokenInt() {
            Token token = super.nextTokenInt();
            int type = token.getType();
            if (type != -1) {
                return token;
            }
            char val = token.getValue().charAt(0);
            switch (val) {
                case ',': {
                    return new Token(3, ",");
                }
                case '.': {
                    return new Token(4, ".");
                }
                case '/': {
                    return new Token(5, "/");
                }
                case '(': {
                    return new Token(6, "(");
                }
                case ')': {
                    return new Token(7, ")");
                }
                case '[': {
                    return new Token(8, "[");
                }
                case ']': {
                    return new Token(9, "]");
                }
            }
            return token;
        }
    }

    static class TokenType
    extends com.sap.tc.logging.TokenType {
        public static final int COMMA = 3;
        public static final int DOT = 4;
        public static final int SLASH = 5;
        public static final int LEFT_PARAN = 6;
        public static final int RIGHT_PARAN = 7;
        public static final int LEFT_BRACKET = 8;
        public static final int RIGHT_BRACKET = 9;
        public static final int MAX = 9;

        TokenType() {
        }
    }

    private static class FormatterEntry {
        private ObjectsVal object;
        private String pattern;
        private Formatter formatter;

        private FormatterEntry() {
        }

        public ObjectsVal getObject() {
            return this.object;
        }

        public void setObject(ObjectsVal object) {
            this.object = object;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public Formatter getFormatter() {
            return this.formatter;
        }

        public void setFormatter(Formatter formatter) {
            this.formatter = formatter;
        }
    }

    private static class LogEntry {
        private ObjectsVal object;
        private ObjectsVal filters;
        private ObjectsVal formatter;
        private SeverityVal effSeverity;
        private BooleanVal append;
        private BooleanVal autoFlush;
        private String enc;
        private String pattern;
        private String desc;
        private int limit = 0;
        private int cnt = 0;
        private boolean autoFlushSet = false;
        private boolean limitSet = false;
        private boolean cntSet = false;
        private Log log;

        private LogEntry() {
        }

        public ObjectsVal getObject() {
            return this.object;
        }

        public void setObject(ObjectsVal object) {
            this.object = object;
        }

        public SeverityVal getEffectiveSeverity() {
            return this.effSeverity;
        }

        public void setEffectiveSeverity(SeverityVal severity) {
            this.effSeverity = severity;
        }

        public String getEncoding() {
            return this.enc;
        }

        public void setEncoding(String enc) {
            this.enc = enc;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public ObjectsVal getFilters() {
            return this.filters;
        }

        public void setFilters(ObjectsVal objects) {
            this.filters = objects;
        }

        public ObjectsVal getFormatter() {
            return this.formatter;
        }

        public void setFormatter(ObjectsVal object) {
            this.formatter = object;
        }

        public BooleanVal getAppend() {
            return this.append;
        }

        public void setAppend(BooleanVal append) {
            this.append = append;
        }

        public BooleanVal getAutoFlush() {
            return this.autoFlush;
        }

        public void setAutoFlush(BooleanVal autoFlush) {
            this.autoFlush = autoFlush;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            if (limit > 0) {
                this.limit = limit;
            }
            this.limitSet = true;
        }

        public boolean isLimitSet() {
            return this.limitSet;
        }

        public int getCnt() {
            return this.cnt;
        }

        public void setCnt(int cnt) {
            if (cnt > 0) {
                this.cnt = cnt;
            }
            this.cntSet = true;
        }

        public boolean isCntSet() {
            return this.cntSet;
        }

        public Log getLog() {
            return this.log;
        }

        public void setLog(Log log) {
            this.log = log;
        }
    }

    private static class LogControllerEntry {
        private LogController controller;
        private SeverityVal effSeverity;
        private SeverityVal minSeverity;
        private SeverityVal maxSeverity;
        private Map effRelationSeverities = new HashMap();
        private Map minRelationSeverities = new HashMap();
        private Map maxRelationSeverities = new HashMap();
        private ObjectsVal logs;
        private ObjectsVal localLogs;
        private ObjectsVal privateLogs;
        private ObjectsVal filters;
        private String resourceBundleName;

        public LogControllerEntry(LogController controller) {
            this.controller = controller;
        }

        public LogController getController() {
            return this.controller;
        }

        public SeverityVal getEffectiveSeverity() {
            return this.effSeverity;
        }

        public void setEffectiveSeverity(SeverityVal severity) {
            this.effSeverity = severity;
        }

        public Map getEffectiveRelationSeverities() {
            return this.effRelationSeverities;
        }

        public void setEffectiveRelationSeverity(LogController controller, SeverityVal severity) {
            this.effRelationSeverities.put(controller, severity);
        }

        public SeverityVal getMinimumSeverity() {
            return this.minSeverity;
        }

        public void setMinimumSeverity(SeverityVal severity) {
            this.minSeverity = severity;
        }

        public Map getMinimumRelationSeverities() {
            return this.minRelationSeverities;
        }

        public void setMinimumRelationSeverity(LogController controller, SeverityVal severity) {
            this.minRelationSeverities.put(controller, severity);
        }

        public SeverityVal getMaximumSeverity() {
            return this.maxSeverity;
        }

        public void setMaximumSeverity(SeverityVal severity) {
            this.maxSeverity = severity;
        }

        public Map getMaximumRelationSeverities() {
            return this.maxRelationSeverities;
        }

        public void setMaximumRelationSeverity(LogController controller, SeverityVal severity) {
            this.maxRelationSeverities.put(controller, severity);
        }

        public ObjectsVal getLogs() {
            return this.logs;
        }

        public void setLogs(ObjectsVal logs) {
            this.logs = logs;
        }

        public ObjectsVal getLocalLogs() {
            return this.localLogs;
        }

        public void setLocalLogs(ObjectsVal logs) {
            this.localLogs = logs;
        }

        public ObjectsVal getPrivateLogs() {
            return this.privateLogs;
        }

        public void setPrivateLogs(ObjectsVal logs) {
            this.privateLogs = logs;
        }

        public ObjectsVal getFilters() {
            return this.filters;
        }

        public void setFilters(ObjectsVal filters) {
            this.filters = filters;
        }

        public String getResourceBundleName() {
            return this.resourceBundleName;
        }

        public void setResourceBundleName(String resourceBundleName) {
            this.resourceBundleName = resourceBundleName;
        }
    }

    private static class CustomClassVal
    extends ClassVal {
        private String ident;

        public CustomClassVal(String ident) {
            super(2);
            this.ident = ident;
        }

        public String getIdent() {
            return this.ident;
        }
    }

    private static class ClassVal
    extends ObjectVal {
        private int type;

        public ClassVal(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    private static class FormatterRefVal
    extends RefVal {
        public FormatterRefVal(String name) {
            super(name);
        }
    }

    private static class LogRefVal
    extends RefVal {
        public LogRefVal(String name) {
            super(name);
        }
    }

    private static class RefVal
    extends ObjectVal {
        private String name;

        public RefVal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class ObjectVal
    extends Val {
        private ObjectVal() {
        }
    }

    private static class ObjectsVal
    extends Val {
        private boolean isAdding = false;
        private LinkedList objects = new LinkedList();

        private ObjectsVal() {
        }

        public boolean isAdding() {
            return this.isAdding;
        }

        public void setAdding(boolean isAdding) {
            this.isAdding = isAdding;
        }

        public Collection getObjects() {
            return this.objects;
        }

        public void addObject(ObjectVal object) {
            this.objects.add(object);
        }
    }

    private static class BooleanVal
    extends Val {
        public static BooleanVal FALSE = new BooleanVal(false);
        public static BooleanVal TRUE = new BooleanVal(true);
        private boolean val;

        public BooleanVal(boolean val) {
            this.val = val;
        }

        public boolean getBoolean() {
            return this.val;
        }
    }

    private static class SeverityVal
    extends Val {
        private int severity;

        public SeverityVal(int severity) {
            this.severity = severity;
        }

        public int getSeverity() {
            return this.severity;
        }
    }

    private static class Val
    extends Element {
        private Val() {
        }
    }

    private static class SeverityAttr
    extends Attr {
        private LogController relative;

        public SeverityAttr(int attr) {
            super(attr);
        }

        public SeverityAttr(int attr, LogController relative) {
            super(attr);
            this.relative = relative;
        }

        public LogController getRelative() {
            return this.relative;
        }
    }

    private static class Attr
    extends Element {
        private int attr;

        public Attr(int attr) {
            this.attr = attr;
        }

        public int getAttr() {
            return this.attr;
        }
    }

    private static class FormatterRefKey
    extends RefKey {
        public FormatterRefKey(String name) {
            super(name);
        }

        public FormatterRefKey(String name, Attr attr) {
            super(name, attr);
        }
    }

    private static class LogRefKey
    extends RefKey {
        public LogRefKey(String name) {
            super(name);
        }

        public LogRefKey(String name, Attr attr) {
            super(name, attr);
        }
    }

    private static class RefKey
    extends Key {
        private String name;

        public RefKey(String name) {
            this.name = name;
        }

        public RefKey(String name, Attr attr) {
            super(attr);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class LogControllerKey
    extends Key {
        private LogController controller;

        public LogControllerKey(LogController controller, Attr attr) {
            super(attr);
            this.controller = controller;
        }

        public LogController getController() {
            return this.controller;
        }
    }

    private static class Key
    extends Element {
        private Attr attr;

        public Key() {
            this.attr = null;
        }

        public Key(Attr attr) {
            this.attr = attr;
        }

        public Attr getAttr() {
            return this.attr;
        }

        public void setAttr(Attr attr) {
            this.attr = attr;
        }
    }

    private static class Element {
        private Element() {
        }
    }

    static class PCTokenizer
    extends Tokenizer {
        public PCTokenizer(String name) {
            super(name);
        }

        public Token nextTokenInt() {
            Token token = super.nextTokenInt();
            int type = token.getType();
            if (type != -1) {
                if (type == 2) {
                    String val = token.getValue();
                    if (val.equals("append")) {
                        return new Token(10, val);
                    }
                    if (val.equals("autoFlush")) {
                        return new Token(11, val);
                    }
                    if (val.equals("bundleName")) {
                        return new Token(12, val);
                    }
                    if (val.equals("cnt")) {
                        return new Token(13, val);
                    }
                    if (val.equals("ConsoleLog")) {
                        return new Token(14, val);
                    }
                    if (val.equals("severity") || val.equals("effSeverity")) {
                        return new Token(16, val);
                    }
                    if (val.equals("encoding")) {
                        return new Token(17, val);
                    }
                    if (val.equals("desc")) {
                        return new Token(15, val);
                    }
                    if (val.equals("false")) {
                        return new Token(18, val);
                    }
                    if (val.equals("FileLog")) {
                        return new Token(19, val);
                    }
                    if (val.equals("filters")) {
                        return new Token(20, val);
                    }
                    if (val.equals("formatter")) {
                        return new Token(21, val);
                    }
                    if (val.equals("limit")) {
                        return new Token(22, val);
                    }
                    if (val.equals("ListFormatter")) {
                        return new Token(23, val);
                    }
                    if (val.equals("localLogs")) {
                        return new Token(24, val);
                    }
                    if (val.equals("log")) {
                        return new Token(25, val);
                    }
                    if (val.equals("logs")) {
                        return new Token(26, val);
                    }
                    if (val.equals("maxSeverity")) {
                        return new Token(27, val);
                    }
                    if (val.equals("minSeverity")) {
                        return new Token(28, val);
                    }
                    if (val.equals("pattern")) {
                        return new Token(29, val);
                    }
                    if (val.equals("privateLogs")) {
                        return new Token(31, val);
                    }
                    if (val.equals("Severity")) {
                        return new Token(32, val);
                    }
                    if (val.equals("TraceFormatter")) {
                        return new Token(33, val);
                    }
                    if (val.equals("true")) {
                        return new Token(34, val);
                    }
                    if (val.equals("XMLFormatter")) {
                        return new Token(35, val);
                    }
                    return token;
                }
                return token;
            }
            char val = token.getValue().charAt(0);
            switch (val) {
                case ',': {
                    return new Token(3, ",");
                }
                case '+': {
                    return new Token(30, "+");
                }
            }
            return token;
        }
    }

    static class PCTokenType
    extends TokenType {
        public static final int APPEND = 10;
        public static final int AUTO_FLUSH = 11;
        public static final int BUNDLE_NAME = 12;
        public static final int CNT = 13;
        public static final int CONSOLE_LOG = 14;
        public static final int DESCRIPTION = 15;
        public static final int EFF_SEVERITY = 16;
        public static final int ENCODING = 17;
        public static final int FALSE = 18;
        public static final int FILE_LOG = 19;
        public static final int FILTERS = 20;
        public static final int FORMATTER = 21;
        public static final int LIMIT = 22;
        public static final int LIST_FORMATTER = 23;
        public static final int LOCAL_LOGS = 24;
        public static final int LOG = 25;
        public static final int LOGS = 26;
        public static final int MAX_SEVERITY = 27;
        public static final int MIN_SEVERITY = 28;
        public static final int PATTERN = 29;
        public static final int PLUS = 30;
        public static final int PRIVATE_LOGS = 31;
        public static final int SEVERITY = 32;
        public static final int TRACE_FORMATTER = 33;
        public static final int TRUE = 34;
        public static final int XML_FORMATTER = 35;
        public static final int MAX = 35;

        PCTokenType() {
        }
    }
}

