/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MessageDelimiterBuilder;
import com.sap.tc.logging.Version;
import com.sap.tc.logging.exceptions.UnsupportedFormatException;
import com.sap.tc.logging.interfaces.IMessageBuilder;
import com.sap.tc.logging.interfaces.IMessageDelimiterBuilder;
import java.io.UnsupportedEncodingException;

public class MessageBuilder
implements IMessageBuilder {
    private static final int DEFAULT_MESSAGE_SIZE = 32768;
    private static final int DEFAULT_MESSAGE_SIZE_OPTIMIZER = 100;
    private byte[] message;
    private byte[] messageEmpty;
    private String messageEncoding;
    private int messageSize;
    private int messageSizeOptimizer;
    private int messageBuildDirection = -2;
    private long messageBookMarkBOL = -1L;
    private long messageBookMarkEOL = -1L;
    private boolean messageStartCheckExists;
    private boolean messageStartIsOk;
    private boolean messageEndIsOk;
    private Formatter formatter;
    private IMessageDelimiterBuilder messageDelimiter;

    private MessageBuilder() {
    }

    protected MessageBuilder(Formatter formatter, IMessageDelimiterBuilder delimiter) {
        if (formatter == null) {
            throw new IllegalArgumentException("Missing Formatter instance!");
        }
        this.formatter = formatter.getClass().getName().equalsIgnoreCase("com.sap.sql.trace.SQLTraceXMLFormatter") ? LoggingManager.DEFAULT_FORMATTER : formatter;
        this.messageDelimiter = delimiter == null ? new MessageDelimiterBuilder(0, 0) : delimiter;
        this.messageDelimiter.setParent(this);
        this.message = new byte[32768];
        this.messageEmpty = new byte[32768];
        this.messageStartCheckExists = delimiter.isDelimited();
    }

    public void savePreviousLine(byte[] chunk, int size) {
        if (this.messageBuildDirection == -2) {
            this.messageBuildDirection = -1;
        }
        this.checkMessageSize(size);
        System.arraycopy(this.message, 0, this.message, size, this.messageSize);
        System.arraycopy(chunk, 0, this.message, 0, size);
        this.messageSize += size;
    }

    public void saveNextLine(byte[] chunk, int size) {
        if (this.messageBuildDirection == -2) {
            this.messageBuildDirection = 1;
        }
        this.checkMessageSize(size);
        System.arraycopy(chunk, 0, this.message, this.messageSize, size);
        this.messageSize += size;
    }

    public byte[] message() {
        if (this.messageSize <= 0) {
            return new byte[0];
        }
        byte[] tmpMessage = new byte[this.messageSize];
        System.arraycopy(this.message, 0, tmpMessage, 0, this.messageSize);
        return tmpMessage;
    }

    public int size() {
        return this.messageSize;
    }

    public void reset() {
        if (this.messageSize > 0) {
            if (this.messageSize > this.messageEmpty.length) {
                this.message = new byte[32768];
            } else {
                System.arraycopy(this.messageEmpty, 0, this.message, 0, this.messageSize);
            }
        }
        this.messageSize = 0;
        this.messageBuildDirection = -2;
        this.messageBookMarkBOL = -1L;
        this.messageBookMarkEOL = -1L;
        this.messageStartIsOk = false;
        this.messageEndIsOk = false;
        this.messageDelimiter.reset();
    }

    public IMessageDelimiterBuilder getDelimiter() {
        return this.messageDelimiter;
    }

    public byte[] getFieldByte(int index) {
        int startPos = 0;
        int endPos = 0;
        byte[] result = null;
        if (this.messageDelimiter.size() == 0) {
            return new byte[0];
        }
        startPos = this.messageDelimiter.getDelimiterPos(index);
        endPos = this.messageDelimiter.getDelimiterPos(index + 1);
        if (startPos == 0 || endPos == 0) {
            return new byte[0];
        }
        int size = endPos - startPos - 1;
        if (size < 0) {
            return new byte[0];
        }
        result = new byte[size];
        System.arraycopy(this.message, startPos, result, 0, size);
        return result;
    }

    public String getFieldString(int index) {
        String result = null;
        if (this.messageEncoding != null) {
            try {
                result = new String(this.getFieldByte(index), this.messageEncoding);
            }
            catch (Exception ex) {
                result = new String(this.getFieldByte(index));
            }
        } else {
            result = new String(this.getFieldByte(index));
        }
        return result;
    }

    public int getFieldInt(int index) {
        return this.parseInt(this.getFieldString(index));
    }

    public boolean isComplete(int direction) throws UnsupportedFormatException {
        switch (direction) {
            case 1: {
                if (this.isStartOk() || !this.messageDelimiter.isDelimited()) break;
                throw new UnsupportedFormatException("Unsupported message start format!");
            }
        }
        return this.isCompleteInt();
    }

    public void setBookMarkBOL(long value) {
        if (this.messageBuildDirection == 1 && this.messageBookMarkBOL >= 0L) {
            return;
        }
        this.messageBookMarkBOL = value;
    }

    public long getBookMarkBOL() {
        return this.messageBookMarkBOL;
    }

    public void setBookMarkEOL(long value) {
        if (this.messageBuildDirection == -1 && this.messageBookMarkEOL >= 0L) {
            return;
        }
        this.messageBookMarkEOL = value;
    }

    public long getBookMarkEOL() {
        return this.messageBookMarkEOL;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public void setEncoding(String charsetName) {
        if (charsetName == null || charsetName.length() == 0) {
            return;
        }
        this.messageEncoding = charsetName;
    }

    public String getEncoding() {
        return this.messageEncoding;
    }

    private String getMessageStart() throws UnsupportedFormatException {
        if (this.messageEncoding != null) {
            try {
                return new String(this.message, 1, 3, this.messageEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new UnsupportedFormatException("Unsupported encoding!");
            }
        }
        return new String(this.message, 1, 3);
    }

    private boolean isCompleteInt() throws UnsupportedFormatException {
        if (this.messageDelimiter.isDelimited()) {
            return this.isStartOk() && this.isEndOk() && this.messageDelimiter.isComplete();
        }
        if (this.messageEncoding != null) {
            try {
                return this.formatter.isCompleteMessage(new String(this.message(), this.messageEncoding));
            }
            catch (UnsupportedEncodingException ex) {
                throw new UnsupportedFormatException("Unsupported encoding!");
            }
        }
        return this.formatter.isCompleteMessage(new String(this.message()));
    }

    private boolean isStartOk() throws UnsupportedFormatException {
        this.messageStartIsOk = this.messageDelimiter.isDelimited() ? Version.getVersionIndex(this.getMessageStart()) != 0 : this.formatter.isStartMessage(this.getMessageStart());
        return this.messageStartIsOk;
    }

    private boolean isEndOk() throws UnsupportedFormatException {
        if (this.messageEndIsOk) {
            return this.messageEndIsOk;
        }
        if (this.messageSize > 0 && this.message[this.messageSize - 1] == 10) {
            int msgSize;
            this.messageEndIsOk = this.messageSize > 1 && this.message[this.messageSize - 2] == 13 ? (msgSize = this.findLastCharacter(this.messageSize, this.message)) > 3 && this.message[msgSize - 1] != 92 && msgSize > 4 && this.message[msgSize] == 35 : (msgSize = this.findLastCharacter(this.messageSize, this.message)) > 2 && this.message[msgSize - 1] != 92 && msgSize > 1 && this.message[msgSize] == 35;
        }
        return this.messageEndIsOk;
    }

    private void checkMessageSize(int size) {
        if (this.message.length < this.messageSize + size) {
            byte[] tmpMessage = new byte[this.messageSize + size + 100];
            System.arraycopy(this.message, 0, tmpMessage, 0, this.messageSize);
            this.message = tmpMessage;
        } else if (this.messageSizeOptimizer > 100 && this.messageSize + size < 100) {
            byte[] tmpMessage = new byte[32768];
            System.arraycopy(this.message, 0, tmpMessage, 0, this.messageSize);
            this.message = tmpMessage;
        }
    }

    private int findLastCharacter(int messageSize, byte[] message) {
        int i = messageSize - 1;
        while (i >= 0) {
            if (message[i] != 10 && message[i] != 13) {
                return i;
            }
            --i;
        }
        return 0;
    }

    private int parseInt(String value) {
        int i = 0;
        i = 0;
        while (i < value.length()) {
            if (!Character.isDigit(value.charAt(i))) break;
            ++i;
        }
        if (i > 0) {
            return Integer.parseInt(value.substring(0, i));
        }
        return 0;
    }
}

