/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.GUId;
import com.sap.tc.logging.Group;
import com.sap.tc.logging.ILogRecordFull;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.interfaces.IRPPublisher;
import com.sap.tc.logging.messagedepot.LocalizedMessage;
import com.sap.tc.logging.messagedepot.MessageAccessor;
import com.sap.tc.logging.messagedepot.MessageID;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LogRecord
extends ExceptionHandling
implements Serializable,
ILogRecordFull {
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$LogRecord == null ? (class$com$sap$tc$logging$LogRecord = LogRecord.class$("com.sap.tc.logging.LogRecord")) : class$com$sap$tc$logging$LogRecord);
    static String version = "$Id: //sapmarkets/Logging/630_SP_REL/src/_Logging/java/com/sap/tc/logging/LogRecord.java#26 $";
    static final Locale STANDARD_LOCALE = Locale.US;
    static final String NULL_STRING = "<null>";
    private static final DateFormat timeFormatter = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private static final String EMPTY_STRING = "";
    private static final String EXCEPTION_POINTER = " \n[EXCEPTION]\n ";
    private static volatile long lastTimeInSeconds = 0L;
    private static volatile String lastTimeString = null;
    private static IRPPublisher rpPublisher;
    private GUId id;
    private int lrSize;
    private long lrBookMark;
    private String lrLogName;
    private Date time;
    private String thrName;
    private String[] args;
    private Object[] argsObj;
    private int severity;
    private String sourceName;
    private String locationName;
    private String[] relatives;
    private String application;
    private String user;
    private String session;
    private String transaction;
    private String dsrComponent;
    private String dsrUser;
    private String dsrTransaction;
    private String sysName;
    private String sysInstanceName;
    private String sysHostName;
    private String sysNodeID;
    private String groupID;
    private String groupName;
    private String groupDescription;
    private int groupLevel;
    private int groupIndent;
    private int msgType;
    private String msgCode;
    private String msgAlias;
    private String resourceBundleName;
    private String msgClear;
    private String msgDefault;
    private String msgLocalized;
    private Throwable msgException;
    static /* synthetic */ Class class$com$sap$tc$logging$LogRecord;

    LogRecord(LogController source, String loc, int severity, String[] relatives, int msgType, String msg, String[] args) {
        this(source, loc, Thread.currentThread(), severity, relatives, msgType, (Object)null, (String)null, msg, args);
    }

    protected LogRecord(LogController source, String locName, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, String[] args) {
        this(source, locName, Thread.currentThread(), severity, relatives, msgType, msgCode, resourceBundleName, msgClear, args);
    }

    protected LogRecord(LogController source, String locName, Thread thr, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, String[] args) {
        block13: {
            this.lrBookMark = -1L;
            this.groupLevel = 0;
            this.groupIndent = 0;
            this.msgType = 0;
            this.setRuntimeProperties();
            this.id = new GUId();
            this.time = new Date();
            if (source != null) {
                this.sourceName = source.getName();
            }
            this.locationName = locName;
            this.thrName = thr.toString();
            this.relatives = relatives;
            this.severity = severity;
            this.args = args;
            this.msgType = msgType;
            this.msgDefault = msgClear;
            this.msgClear = msgClear;
            if (msgCode != null) {
                this.msgCode = msgCode.toString();
            }
            this.resourceBundleName = resourceBundleName;
            if (resourceBundleName != null) {
                try {
                    try {
                        ResourceBundle msgs;
                        ClassLoader classLoader = source.getClassLoader();
                        if (classLoader != null) {
                            msgs = ResourceBundle.getBundle(resourceBundleName, STANDARD_LOCALE, classLoader);
                        } else {
                            try {
                                msgs = ResourceBundle.getBundle(resourceBundleName, STANDARD_LOCALE);
                            }
                            catch (MissingResourceException exc) {
                                msgs = ResourceBundle.getBundle(resourceBundleName, STANDARD_LOCALE, thr.getContextClassLoader());
                            }
                        }
                        this.msgLocalized = msgs.getString(this.msgCode);
                    }
                    catch (MissingResourceException exc) {
                        source.handleException(exc);
                        Object var15_18 = null;
                        this.msgClear = this.msgLocalized != null ? this.msgLocalized : this.msgDefault;
                        break block13;
                    }
                    catch (SecurityException exc) {
                        source.handleException(exc);
                        Object var15_19 = null;
                        this.msgClear = this.msgLocalized != null ? this.msgLocalized : this.msgDefault;
                        break block13;
                    }
                    catch (NullPointerException exc) {
                        source.handleException(exc);
                        Object var15_20 = null;
                        this.msgClear = this.msgLocalized != null ? this.msgLocalized : this.msgDefault;
                    }
                    Object var15_17 = null;
                    this.msgClear = this.msgLocalized != null ? this.msgLocalized : this.msgDefault;
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    this.msgClear = this.msgLocalized != null ? this.msgLocalized : this.msgDefault;
                    throw throwable;
                }
            }
        }
    }

    protected LogRecord(String msgId, int size, Date time, String source, int severity, String loc, String[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String msgAlias, String resourceBundleName, String msgClear, Object[] args, String application, String user, String session, String transaction, String dsrComponent, String dsrUser, String dsrTransaction, MessageAccessor msgAccessor) {
        this.lrBookMark = -1L;
        this.groupLevel = 0;
        this.groupIndent = 0;
        this.msgType = 0;
        this.id = new GUId(msgId);
        this.lrSize = size;
        this.time = time;
        this.sourceName = source;
        this.severity = severity;
        this.locationName = loc;
        this.relatives = relatives;
        this.groupLevel = level;
        this.groupIndent = indent;
        this.thrName = thr;
        this.msgType = msgType;
        this.msgCode = msgCode;
        this.msgAlias = msgAlias;
        this.resourceBundleName = resourceBundleName;
        this.args = LogRecord.getArgStrsInt(args);
        this.argsObj = args;
        this.application = application;
        this.user = user;
        this.session = session;
        this.transaction = transaction;
        this.dsrComponent = dsrComponent;
        this.dsrUser = dsrUser;
        this.dsrTransaction = dsrTransaction;
        this.msgDefault = msgClear;
        this.msgClear = msgClear;
        if (msgAccessor != null && msgCode != null) {
            try {
                LocalizedMessage locMessage = msgAccessor.getLocalizedMessage(new MessageID(msgCode));
                if (locMessage != null) {
                    this.msgClear = this.msgLocalized = locMessage.getLongText();
                } else {
                    this.msgLocalized = null;
                    this.msgClear = msgClear;
                }
            }
            catch (Exception ex) {
                this.msgLocalized = null;
                this.msgClear = msgClear;
            }
        }
    }

    protected LogRecord(String msgId, int size, Date time, String source, int severity, String loc, String[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String resourceBundleName, String msgClear, Object[] args, String application, String user, String session, String transaction, String dsrComponent, String dsrUser, String dsrTransaction) {
        this(msgId, size, time, source, severity, loc, relatives, groupId, level, indent, thr, msgType, msgCode, null, resourceBundleName, msgClear, args, application, user, session, transaction, dsrComponent, dsrUser, dsrTransaction, null);
    }

    protected LogRecord(String msgId, Date time, String source, int severity, String loc, String[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String resourceBundleName, String msgClear, Object[] args, String application, String user, String session, String transaction, String dsrComponent, String dsrUser, String dsrTransaction) {
        this.lrBookMark = -1L;
        this.groupLevel = 0;
        this.groupIndent = 0;
        this.msgType = 0;
        this.id = new GUId(msgId);
        this.time = time;
        this.sourceName = source;
        this.severity = severity;
        this.locationName = loc;
        this.relatives = relatives;
        this.groupLevel = level;
        this.groupIndent = indent;
        this.thrName = thr;
        this.msgType = msgType;
        this.msgCode = msgCode;
        this.resourceBundleName = resourceBundleName;
        this.msgClear = msgClear;
        this.args = LogRecord.getArgStrsInt(args);
        this.argsObj = args;
        this.application = application;
        this.user = user;
        this.session = session;
        this.transaction = transaction;
        this.dsrComponent = dsrComponent;
        this.dsrUser = dsrUser;
        this.dsrTransaction = dsrTransaction;
    }

    LogRecord(LogController source, String loc, int severity, String[] relatives, int msgType, String msg, Object[] args, Throwable msgException) {
        this(source, loc, severity, relatives, msgType, msg, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
        this.msgException = msgException;
        this.buildException(source);
    }

    LogRecord(LogController source, String loc, int severity, String[] relatives, int msgType, String msg, Object[] args) {
        this(source, loc, severity, relatives, msgType, msg, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
    }

    protected LogRecord(LogController source, String locName, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args, Throwable msgExc) {
        this(source, locName, Thread.currentThread(), severity, relatives, msgType, msgCode, resourceBundleName, msgClear, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
        this.msgException = msgExc;
        this.buildException(source);
    }

    protected LogRecord(LogController source, String locName, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args) {
        this(source, locName, Thread.currentThread(), severity, relatives, msgType, msgCode, resourceBundleName, msgClear, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
    }

    protected LogRecord(LogController source, String locName, Thread thr, int severity, String[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args) {
        this(source, locName, thr, severity, relatives, msgType, msgCode, resourceBundleName, msgClear, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
    }

    protected LogRecord(String msgId, Date time, String source, int severity, String loc, LogController[] relatives, String groupId, int level, int indent, String thr, int msgType, String msgCode, String resourceBundleName, String msgClear, String[] args, String application, String user, String session, String transaction) {
        this(msgId, time, source, severity, loc, LogRecord.convertRelatives(relatives), groupId, level, indent, thr, msgType, msgCode, resourceBundleName, msgClear, args, application, user, session, transaction, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
    }

    protected LogRecord(LogController source, String locName, Thread thr, int severity, LogController[] relatives, int msgType, Object msgCode, String resourceBundleName, String msgClear, Object[] args) {
        this(source, locName, thr, severity, LogRecord.convertRelatives(relatives), msgType, msgCode, resourceBundleName, msgClear, LogRecord.getArgStrsInt(args));
        this.argsObj = args;
    }

    public GUId getId() {
        return this.id;
    }

    public int getSize() {
        return this.lrSize;
    }

    public Date getTime() {
        return this.time;
    }

    public String getApplication() {
        if (this.application != null) {
            return this.application;
        }
        return EMPTY_STRING;
    }

    public void setApplication(String value) {
        this.application = value;
    }

    public String getUser() {
        if (this.user != null) {
            return this.user;
        }
        return EMPTY_STRING;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public String getSession() {
        if (this.session != null) {
            return this.session;
        }
        return EMPTY_STRING;
    }

    public void setSession(String value) {
        this.session = value;
    }

    public String getTransaction() {
        if (this.transaction != null) {
            return this.transaction;
        }
        return EMPTY_STRING;
    }

    public void setTransaction(String value) {
        this.transaction = value;
    }

    public String getDsrComponent() {
        if (this.dsrComponent != null) {
            return this.dsrComponent;
        }
        return EMPTY_STRING;
    }

    public void setDsrComponent(String value) {
        this.dsrComponent = value;
    }

    public String getDsrUser() {
        if (this.dsrUser != null) {
            return this.dsrUser;
        }
        return EMPTY_STRING;
    }

    public void setDsrUser(String value) {
        this.dsrUser = value;
    }

    public String getDsrTransaction() {
        if (this.dsrTransaction != null) {
            return this.dsrTransaction;
        }
        return EMPTY_STRING;
    }

    public void setDsrTransaction(String value) {
        this.dsrTransaction = value;
    }

    public String getSysHostName() {
        if (this.sysHostName != null) {
            return this.sysHostName;
        }
        return EMPTY_STRING;
    }

    public void setSysHostName(String value) {
        this.sysHostName = value;
    }

    public String getSysInstanceName() {
        if (this.sysInstanceName != null) {
            return this.sysInstanceName;
        }
        return EMPTY_STRING;
    }

    public void setSysInstanceName(String value) {
        this.sysInstanceName = value;
    }

    public String getSysName() {
        if (this.sysName != null) {
            return this.sysName;
        }
        return EMPTY_STRING;
    }

    public void setSysName(String value) {
        this.sysName = value;
    }

    public String getSysNodeID() {
        if (this.sysNodeID != null) {
            return this.sysNodeID;
        }
        return EMPTY_STRING;
    }

    public void setSysNodeID(String value) {
        this.sysNodeID = value;
    }

    public boolean isGroupActive() {
        return false;
    }

    public List getGroups() {
        return Collections.EMPTY_LIST;
    }

    public Group getGroup() {
        return null;
    }

    public GUId getGroupId() {
        return null;
    }

    public String getGroupID() {
        if (this.groupID != null) {
            return this.groupID;
        }
        return EMPTY_STRING;
    }

    public String getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        return EMPTY_STRING;
    }

    public String getLocationName() {
        if (this.locationName != null) {
            return this.locationName;
        }
        return EMPTY_STRING;
    }

    public String getGroupName() {
        if (this.groupName != null) {
            return this.groupName;
        }
        return EMPTY_STRING;
    }

    public String getGroupDescription() {
        if (this.groupDescription != null) {
            return this.groupDescription;
        }
        return EMPTY_STRING;
    }

    public int getGroupIndent() {
        return this.groupIndent;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public String getThreadName() {
        if (this.thrName != null) {
            return this.thrName;
        }
        return EMPTY_STRING;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public String getMsgCode() {
        if (this.msgCode != null) {
            return this.msgCode;
        }
        return EMPTY_STRING;
    }

    public String getMsgAlias() {
        if (this.msgAlias != null) {
            return this.msgAlias;
        }
        return EMPTY_STRING;
    }

    public String getResourceBundleName() {
        if (this.resourceBundleName != null) {
            return this.resourceBundleName;
        }
        return EMPTY_STRING;
    }

    public String getMessage() {
        if (this.msgType == 1) {
            return MessageFormat.format(this.getMsgClear(), this.getArgsInt());
        }
        return this.msgClear;
    }

    public String getMsgClear() {
        if (this.msgClear != null) {
            return this.msgClear;
        }
        return EMPTY_STRING;
    }

    public String getMsgDefault() {
        if (this.msgDefault != null) {
            return this.msgDefault;
        }
        return EMPTY_STRING;
    }

    public String getMsgLocalized() {
        if (this.msgLocalized != null) {
            return this.msgLocalized;
        }
        return EMPTY_STRING;
    }

    public Throwable getMsgException() {
        return this.msgException;
    }

    public List getArgs() {
        if (this.args != null) {
            return Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(this.args)));
        }
        return Collections.EMPTY_LIST;
    }

    public List getArgObjs() {
        if (this.argsObj != null) {
            return Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(this.argsObj)));
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getRelatives() {
        if (this.relatives != null) {
            return Collections.unmodifiableCollection(new ArrayList<String>(Arrays.asList(this.relatives)));
        }
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogRecord) {
            return this.id.equals(((LogRecord)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void setBookMark(long value) {
        this.lrBookMark = value;
    }

    public long getBookMark() {
        return this.lrBookMark;
    }

    public String getLogName() {
        return this.lrLogName;
    }

    public void setLogName(String value) {
        this.lrLogName = value;
    }

    String getTimeString() {
        return LogRecord.formatTime(this.time);
    }

    String[] getRelativesInt() {
        return this.relatives;
    }

    static String[] getArgStrsInt(Object[] argsLikeObjects) {
        String[] argStrs = null;
        if (argsLikeObjects != null) {
            argStrs = new String[argsLikeObjects.length];
            int i = 0;
            while (i < argsLikeObjects.length) {
                if (argsLikeObjects[i] != null) {
                    try {
                        argStrs[i] = argsLikeObjects[i].toString();
                    }
                    catch (Exception ex) {
                        APILogger.logIntByAPI(400, classLoc, "[getArgStrsInt()]", MSGCollection.LOGGING_MSG_ID_PARSING_ARGS, MSGCollection.LOGGING_MSG_STR_PARSING_ARGS, null);
                        APILogger.catchingIntByAPI(ex);
                        argStrs[i] = NULL_STRING;
                    }
                } else {
                    argStrs[i] = NULL_STRING;
                }
                ++i;
            }
        }
        return argStrs;
    }

    static String formatTime(Date time) {
        long thisTimeInSeconds = time.getTime() / 1000L;
        if (lastTimeInSeconds != thisTimeInSeconds) {
            lastTimeString = timeFormatter.format(time);
            lastTimeInSeconds = thisTimeInSeconds;
        }
        return lastTimeString;
    }

    void setGroupID(String value) {
        this.groupID = value;
    }

    void setGroupName(String value) {
        this.groupName = value;
    }

    void setGroupDescription(String value) {
        this.groupDescription = value;
    }

    void setGroupIndent(int value) {
        this.groupIndent = value;
    }

    void setGroupLevel(int value) {
        this.groupLevel = value;
    }

    Object[] getArgsInt() {
        return this.args;
    }

    private static String[] convertRelatives(LogController[] relatives) {
        String[] tmpValues = null;
        if (relatives != null) {
            tmpValues = new String[relatives.length];
            int i = 0;
            while (i < relatives.length) {
                tmpValues[i] = relatives[i].getName();
                ++i;
            }
        }
        return tmpValues;
    }

    private void setRuntimeProperties() {
        try {
            if (rpPublisher == null) {
                rpPublisher = LoggingManager.getRuntimePropertiesPublisher();
            }
            if (rpPublisher != null) {
                rpPublisher.reInitProperties(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private LogController[] copyRelatives(LogController[] relatives) {
        if (relatives != null) {
            LogController[] tmpRelatives = null;
            int relativesCnt = 0;
            int i = 0;
            while (i < relatives.length) {
                if (relatives[i] != null) {
                    ++relativesCnt;
                }
                ++i;
            }
            if (relativesCnt > 0) {
                int j = 0;
                tmpRelatives = new LogController[relativesCnt];
                int i2 = 0;
                while (i2 < relatives.length) {
                    if (relatives[i2] != null) {
                        tmpRelatives[j] = relatives[i2];
                        ++j;
                    }
                    ++i2;
                }
            }
            return tmpRelatives;
        }
        return null;
    }

    private String getNewMsg(String msg, int argsLength) {
        return msg + EXCEPTION_POINTER + "{" + (argsLength - 1) + "}";
    }

    private Object[] getNewArgs(Object[] args, Throwable exc) {
        Object[] tmpArgs = args;
        if (args != null) {
            tmpArgs = new Object[args.length + 1];
            int i = 0;
            while (i < args.length) {
                tmpArgs[i] = args[i];
                ++i;
            }
            tmpArgs[tmpArgs.length - 1] = ExceptionManager.getStackTrace(exc);
        }
        return tmpArgs;
    }

    private void buildException(LogController source) {
        if (this.msgException != null && source != null && source instanceof Location) {
            if (this.argsObj == null) {
                this.argsObj = new Object[]{ExceptionManager.getStackTrace(this.msgException)};
                this.msgType = 1;
            } else {
                this.argsObj = this.getNewArgs(this.argsObj, this.msgException);
            }
            this.msgClear = this.getNewMsg(this.msgClear, this.argsObj.length);
            this.args = LogRecord.getArgStrsInt(this.argsObj);
        }
    }

    public LogController getSource() {
        return null;
    }

    public String getLocation() {
        return this.getLocationName();
    }

    public int getLevel() {
        return this.getGroupLevel();
    }

    public int getIndent() {
        return this.getGroupIndent();
    }

    public Thread getThread() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

