package org.example.app;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Does some logging with commons logging API for demonstration.
 */
public class JclExampleUsage {
	
	/** The JCL-Logger*/
	private static Log jcl = LogFactory.getLog(JclExampleUsage.class);

	/**
	 * Just some commons logging log output.
	 */
	public static void logSomething() {
		// traces		
		jcl.trace("JCL - trace-method");
		jcl.debug("JCL - debug-method");
		jcl.debug(
			"JCL - debug-method with exception",
			new NullPointerException("Developer's best friend."));

		//logs
		jcl.info("JCL - info-method");
		jcl.warn("JCL - warn-method");
		jcl.error("JCL - error-method");
		jcl.fatal("JCL - fatal-method");
		jcl.fatal(
			"JCL - fatal-method with exception",
			new NullPointerException("Developer's best friend."));
	}
}
