/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ldap;

import com.sap.security.core.audit.Audit;
import com.sap.security.core.audit.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.cert.X509Certificate;

public class CertificationSearch {
    private Audit a = new Audit();
    private Properties props = null;

    public static void main(String[] args) {
        new CertificationSearch().start(args);
    }

    private Properties loadProps(String filename) {
        Properties _p = new Properties();
        try {
            this.a.print("Trying to read configuration file " + filename);
            _p.load(new FileInputStream(new File(filename)));
            this.a.print("Configuration successfully loaded");
        }
        catch (Throwable t) {
            this.a.print("Exeption when trying to load configuration file " + t.getMessage());
            _p = null;
        }
        return _p;
    }

    private void removeCertificate(String dn, DirContext ctx) throws Exception {
        try {
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute del = new BasicAttribute(this.props.getProperty("ldap.certificate.attribute"));
            attrs.put(del);
            ctx.modifyAttributes(dn, 3, (Attributes)attrs);
            this.a.print("Existing certificate deleted");
        }
        catch (Throwable t) {
            this.a.print("Problem when deleting old certificate can be ignored " + t.getMessage());
        }
    }

    private void addCertificate(String dn, DirContext ctx, boolean base64) throws Exception {
        X509Certificate cert = X509Certificate.getInstance(new FileInputStream(new File(this.props.getProperty("ldap.certificate"))));
        BasicAttribute certAttr = new BasicAttribute(this.props.getProperty("ldap.certificate.attribute"));
        if (!base64) {
            certAttr.add(cert.getEncoded());
        } else {
            certAttr.add(Base64.encode(cert.getEncoded()));
        }
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(certAttr);
        ctx.modifyAttributes(dn, 1, (Attributes)attrs);
        this.a.print("New certificate stored at user");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(String[] args) {
        this.a = new Audit();
        StringBuffer sb = new StringBuffer();
        sb.append("Certification Standalone Test Tool\n");
        sb.append("used for UME-LDAP Certification 2  (1.04.09)\n");
        this.a.print(sb.toString());
        if (args.length == 0) {
            this.a.print("Usage: certtest \"configuration file\"");
            return;
        }
        this.props = this.loadProps(args[0]);
        if (this.props == null) {
            this.a.print("No configuration file loaded");
            return;
        }
        StringBuffer all = new StringBuffer();
        all.append("Used properties_\n");
        all.append("\tldap.user: ").append(this.props.get("ldap.user")).append("\n");
        all.append("\tldap.password: ").append("*\n");
        all.append("\tldap.url: ").append(this.props.get("ldap.url")).append("\n");
        all.append("\tldap.logon.attribute: ").append(this.props.get("ldap.logon.attribute")).append("\n");
        all.append("\tldap.user.objectclass: ").append(this.props.get("ldap.user.objectclass")).append("\n");
        all.append("\tldap.certificate.attribute: ").append(this.props.get("ldap.certificate.attribute")).append("\n");
        all.append("\tldap.logon.id: ").append(this.props.get("ldap.logon.id")).append("\n");
        all.append("\tldap.certificate: ").append(this.props.get("ldap.certificate")).append("\n");
        all.append("\tldap.certificate.base64: ").append(this.props.get("ldap.certificate.base64")).append("\n");
        all.append("\tldap.only_search: ").append(this.props.get("ldap.only_search")).append("\n\n");
        this.a.print(all.toString());
        String base64Handling = (String)this.props.get("ldap.certificate.base64");
        boolean base64 = false;
        base64 = base64Handling != null && base64Handling.equalsIgnoreCase("true");
        DirContext ctx = null;
        try {
            try {
                ctx = this.openContext();
                this.a.print("LDAP Context established");
                this.a.print("\nPrimary search for user with certificate");
                String dn = this.searchForUserWithCertificate(ctx, base64);
                if (dn == null) {
                    if (!this.props.getProperty("ldap.only_search").equalsIgnoreCase("false")) {
                        this.a.print("\tFAILURE: No user found for certificate");
                        throw new Exception("Search for a user based on a certificate failed");
                    }
                    this.a.print("\tNo user found for certificate");
                } else if (this.props.getProperty("ldap.only_search").equalsIgnoreCase("false")) {
                    this.a.print("\tUser found for certificate " + dn);
                } else {
                    this.a.print("\tSUCCESS: User found for certificate " + dn);
                }
                if (!this.props.getProperty("ldap.only_search").equalsIgnoreCase("false")) return;
                this.a.print("\nSearch for user with provided logon id " + this.props.getProperty("ldap.logon.id"));
                String _dn = this.searchForUser(args, ctx);
                if (_dn == null) {
                    this.a.print("\tNo user found");
                    return;
                }
                this.removeCertificate(_dn, ctx);
                this.addCertificate(_dn, ctx, base64);
                this.a.print("\tUser updated by certificate found (remove old and set new) " + _dn);
                this.a.print("\nPerforming search for user based on the provided certificate");
                String newDN = this.searchForUserWithCertificate(ctx, base64);
                if (newDN != null) {
                    this.a.print("\tSUCCESS: user found for certificate " + newDN);
                    return;
                }
                this.a.print("\tFAILURE: NO user found for  certificate");
                throw new Exception("No user found when searching with certificate");
            }
            catch (Throwable t) {
                this.a.print("Exception during test " + t.getMessage());
                this.a.print("Closing LDAP context");
                this.closeContext(ctx);
                return;
            }
        }
        finally {
            this.a.print("Closing LDAP context");
            this.closeContext(ctx);
        }
    }

    private String searchForUserWithCertificate(DirContext ctx, boolean base64) throws Exception {
        String _result = null;
        if (!base64) {
            this.a.print("Certification handling RAW");
            String certificateAttribute = this.props.getProperty("ldap.certificate.attribute");
            String filter = "(&(objectclass=" + this.props.getProperty("ldap.user.objectclass") + ")(" + certificateAttribute + "={0}))";
            this.a.print("Search filter: " + filter);
            Object[] os = new Object[]{X509Certificate.getInstance(new FileInputStream(new File(this.props.getProperty("ldap.certificate")))).getEncoded()};
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search("", filter, os, sc);
            if (results.hasMore()) {
                SearchResult one = results.next();
                one.setRelative(true);
                _result = one.getName();
            }
        } else {
            this.a.print("Certificate handling in Base64 format");
            X509Certificate certificate = X509Certificate.getInstance(new FileInputStream(new File(this.props.getProperty("ldap.certificate"))));
            String base64String = Base64.encode(certificate.getEncoded());
            String certificateAttribute = this.props.getProperty("ldap.certificate.attribute");
            String filter = "(&(objectclass=" + this.props.getProperty("ldap.user.objectclass") + ")(" + certificateAttribute + "=" + base64String + "))";
            this.a.print("Search filter: " + filter);
            SearchControls sc = new SearchControls();
            sc.setReturningAttributes(new String[]{"usercertificate"});
            sc.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search("", filter, sc);
            if (results.hasMore()) {
                SearchResult one = results.next();
                one.setRelative(true);
                _result = one.getName();
                Attribute attribute = one.getAttributes().get("usercertificate");
            }
        }
        return _result;
    }

    private String searchForUser(String[] args, DirContext ctx) throws Exception {
        String _result = null;
        String filter = "(&(objectclass=" + this.props.getProperty("ldap.user.objectclass") + ")(" + this.props.getProperty("ldap.logon.attribute") + "=" + this.props.getProperty("ldap.logon.id") + "))";
        this.a.print("Search filter :" + filter);
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search("", filter, sc);
        while (results.hasMore()) {
            SearchResult one = results.next();
            one.setRelative(true);
            _result = one.getName();
        }
        return _result;
    }

    private DirContext openContext(String[] args) throws Exception {
        InitialDirContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", args[0]);
        env.put("java.naming.security.credentials", args[1]);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", args[2]);
        env.put("java.naming.ldap.version", "3");
        ctx = new InitialDirContext(env);
        ctx.lookup("");
        return ctx;
    }

    private DirContext openContext() throws Exception {
        InitialDirContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", this.props.getProperty("ldap.user"));
        env.put("java.naming.security.credentials", this.props.getProperty("ldap.pwd"));
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.props.getProperty("ldap.url"));
        env.put("java.naming.ldap.version", "3");
        ctx = new InitialDirContext(env);
        ctx.lookup("");
        return ctx;
    }

    private void closeContext(DirContext ctx) {
        if (ctx == null) {
            return;
        }
        try {
            ctx.close();
        }
        catch (Throwable t) {
            this.out("Ignoring exception when closing context");
        }
    }

    private void out(String message) {
        System.out.println(message);
    }
}

