/* $Id: textual.h,v 1.2 2005/12/04 22:29:25 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Postgres object interface for Python
 */
#ifndef PyPg_type_textual_H
#define PyPg_type_textual_H 0
#ifdef __cplusplus
extern "C" {
#endif

IF_PGTYPE_NAME(extern PyPgTypeObject PyPg_name_Type;)
IF_PGTYPE_TEXT(extern PyPgTypeObject PyPg_text_Type;)
IF_PGTYPE_CHAR(extern PyPgTypeObject PyPg_char_Type;)
IF_PGTYPE_BPCHAR(extern PyPgTypeObject PyPg_bpchar_Type;)
IF_PGTYPE_VARCHAR(extern PyPgTypeObject PyPg_varchar_Type;)
IF_PGTYPE_UNKNOWN(extern PyPgTypeObject PyPg_unknown_Type;)
IF_PGTYPE_CSTRING(extern PyPgTypeObject PyPg_cstring_Type;)

#define PyPg_name_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_name_Type))
#define PyPg_name_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_name_Type)

#define PyPg_text_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_text_Type))
#define PyPg_text_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_text_Type)

#define PyPg_char_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_char_Type))
#define PyPg_char_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_char_Type)

#define PyPg_bpchar_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_bpchar_Type))
#define PyPg_bpchar_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_bpchar_Type)

#define PyPg_varchar_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_varchar_Type))
#define PyPg_varchar_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_varchar_Type)

#define PyPg_unknown_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_unknown_Type))
#define PyPg_unknown_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_unknown_Type)

#define PyPg_cstring_Check(SELF) \
	(PyObject_TypeCheck((SELF), (PyTypeObject *) &PyPg_cstring_Type))
#define PyPg_cstring_CheckExact(SELF) \
	((SELF)->ob_type == (PyTypeObject *) &PyPg_cstring_Type)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_textual_H */
/*
 * vim: ts=3:sw=3:noet:
 */
