/* $Id: query.h,v 1.11 2006/02/27 04:41:44 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/query.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/query.h,v 1.4 2004/10/17 07:18:02 flaw
 *//*
 * Postgres Query Interface
 */
#ifndef PyPg_query_H
#define PyPg_query_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgQuery {
	PyObject_HEAD
	PyObj q_source;
	PyObj q_input;
	PyObj q_output;
	Node *q_rpt;

	MemoryContext q_context;      /* The permanent context */
	MemoryContext q_exec_context; /* The execution context */

	List *q_queryl;
	List *q_planl;

	Oid q_lastoid;
} * PyPgQuery;

#ifndef PyPg_ci_H
extern PyTypeObject PyPgQuery_Type;
PyObj PyPgQuery_NEW(PyTypeObject *subtype, PyObj query_string);

ParamListInfo ParamListInfo_FromTupleDescAndHeapTuple(TupleDesc, HeapTuple);
PyObj PyList_FromTupleDescAndTuplestore(TupleDesc, Tuplestorestate *);
#else
#	define PyPgQuery_Type (*(PyPgCI._PyPgQuery_Type))
#	define PyPgQuery_NEW(SUBTYPE, QUERY_STRING) \
		(PyPgCI._PyPgQuery_NEW(SUBTYPE, QUERY_STRING))
#endif

#define PyPgQuery_New(QUERY_STRING) PyPgQuery_NEW(&PyPgQuery_Type, QUERY_STRING)

#define PyPgQuery(SELF) ((PyPgQuery) SELF)

#define PyPgQuery_FetchString(SELF) (PyPgQuery(SELF)->q_source)
#define PyPgQuery_FetchSource(SELF) (PyPgQuery(SELF)->q_source)
#define PyPgQuery_FetchArgTypes(SELF) (PyPgQuery(SELF)->q_input)
#define PyPgQuery_FetchInput(SELF) (PyPgQuery(SELF)->q_input)
#define PyPgQuery_FetchOutput(SELF) (PyPgQuery(SELF)->q_output)
#define PyPgQuery_FetchRawParseTree(SELF) (PyPgQuery(SELF)->q_rpt)
#define PyPgQuery_FetchMemoryContext(SELF) (PyPgQuery(SELF)->q_context)
#define PyPgQuery_FetchExecutionMemoryContext(SELF) \
	(PyPgQuery(SELF)->q_exec_context)
#define PyPgQuery_FetchQueryList(SELF) (PyPgQuery(SELF)->q_queryl)
#define PyPgQuery_FetchPlanList(SELF) (PyPgQuery(SELF)->q_planl)
#define PyPgQuery_FetchLastOid(SELF) (PyPgQuery(SELF)->q_lastoid)

#define PyPgQuery_FixSource(SELF, STR) (PyPgQuery(SELF)->q_source = STR)
#define PyPgQuery_FixString(SELF, STR) (PyPgQuery(SELF)->q_source = STR)
#define PyPgQuery_FixArgTypes(SELF, ATS) (PyPgQuery(SELF)->q_input = ATS)
#define PyPgQuery_FixInput(SELF, TD) (PyPgQuery(SELF)->q_input = TD)
#define PyPgQuery_FixOutput(SELF, TD) (PyPgQuery(SELF)->q_output = TD)
#define PyPgQuery_FixRawParseTree(SELF, RPT) (PyPgQuery(SELF)->q_rpt = RPT)
#define PyPgQuery_FixMemoryContext(SELF, CX) (PyPgQuery(SELF)->q_context = CX)
#define PyPgQuery_FixExecutionMemoryContext(SELF, CX) \
	(PyPgQuery(SELF)->q_exec_context = CX)
#define PyPgQuery_FixQueryList(SELF, QL) (PyPgQuery(SELF)->q_queryl = QL)
#define PyPgQuery_FixPlanList(SELF, PL) (PyPgQuery(SELF)->q_planl = PL)
#define PyPgQuery_FixLastOid(SELF, LO) (PyPgQuery(SELF)->q_lastoid = LO)

#define PyPgQuery_FetchSTRING(SELF) \
	PyString_AS_STRING(PyPgQuery_FetchString(SELF))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_query_H */
/*
 * vim: ts=3:sw=3:noet:
 */
