/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class UtilTransliteratorUsingVM
extends UtilTransliterator {
    private static String footprint = "$Revision:   1.11  $";
    private String encoding;
    private static final int CHUNK = 256;

    public UtilTransliteratorUsingVM(String string) throws UtilException {
        try {
            " ".getBytes(string);
            this.encoding = string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, string);
        }
        this.setCacheSize(256);
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        try {
            return new String(byArray, n, n2, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1009);
        }
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        if (this.bytesCache.length < 256) {
            this.bytesCache = new byte[256];
        }
        if (this.charsCache.length < 256) {
            this.charsCache = new char[256];
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, 256);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                int n4 = 0;
                while (n4 < n3) {
                    this.charsCache[n4] = (char)(this.bytesCache[n4] & 0xFF);
                    ++n4;
                }
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new UtilException(1009);
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        if (this.charsCache.length < 256) {
            this.charsCache = new char[256];
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, 256);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new UtilException(1009);
        }
    }

    public byte[] encode(String string) throws UtilException {
        try {
            return string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1009);
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        byte[] byArray = this.encode(string);
        nArray[0] = byArray.length;
        return byArray;
    }

    public int getMaxBytesPerChar() {
        return 0;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public boolean isFixedBytesPerChar() {
        return false;
    }
}

