/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTempBuffer;
import java.io.IOException;
import java.io.InputStream;

public class UtilTempBufferInputStream
extends InputStream {
    private static String footprint = "$Revision:   1.1  $";
    private UtilTempBuffer tempBuffer;
    private int currentPos;
    private long length;

    public UtilTempBufferInputStream(UtilTempBuffer utilTempBuffer) {
        this.tempBuffer = utilTempBuffer;
        this.currentPos = 0;
        this.length = utilTempBuffer.getSize();
    }

    public void close() throws IOException {
        this.tempBuffer = null;
        this.currentPos = -1;
        this.length = 0L;
    }

    private String getExceptionMessage(int n) {
        UtilException utilException = new UtilException(n);
        return utilException.getMessage();
    }

    public long getLength() {
        long l;
        try {
            l = this.tempBuffer.getSize();
        }
        catch (NullPointerException nullPointerException) {
            l = -1L;
        }
        return l;
    }

    public int read() throws IOException {
        if ((long)this.currentPos == this.length) {
            return -1;
        }
        try {
            byte by = this.tempBuffer.read(this.currentPos);
            ++this.currentPos;
            return by;
        }
        catch (UtilException utilException) {
            throw new IOException(utilException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(this.getExceptionMessage(1017));
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if ((long)this.currentPos == this.length) {
            return -1;
        }
        try {
            int n3 = this.tempBuffer.read(this.currentPos, byArray, n, n2);
            this.currentPos += n3;
            return n3;
        }
        catch (UtilException utilException) {
            throw new IOException(utilException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(this.getExceptionMessage(1017));
        }
    }
}

