/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.postgresql.Connection;
import org.postgresql.core.ConnectionHook;
import org.postgresql.util.PSQLException;

public class Driver
implements java.sql.Driver {
    private Properties props;
    private static String[] protocols;

    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        this.props = this.parseURL(string, properties);
        if (this.props == null) {
            return null;
        }
        try {
            Connection connection = (Connection)Class.forName("org.postgresql.jdbc2.Connection").newInstance();
            connection.openConnection(this.host(), this.port(), this.props, this.database(), string, this);
            return (java.sql.Connection)((Object)connection);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PSQLException("postgresql.jvm.version", classNotFoundException);
        }
        catch (PSQLException pSQLException) {
            throw pSQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.unusual", exception);
        }
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.parseURL(string, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Properties properties2 = this.parseURL(string, properties);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{};
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 7;
    }

    public int getMinorVersion() {
        return 1;
    }

    public static String getVersion() {
        return "PostgreSQL 7.1 JDBC2";
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String string, Properties properties) throws SQLException {
        int n = -1;
        Properties properties2 = new Properties(properties);
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/;=&?", true);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (n2 <= 3) {
                if (n2 % 2 != 1 || !string4.equals(":")) {
                    if (n2 % 2 != 0) return null;
                    boolean bl = n2 == 0;
                    int n3 = 0;
                    while (n3 < protocols.length) {
                        if (string4.equals(protocols[n3]) && n2 == 2 && n3 > 0) {
                            ((Hashtable)properties2).put("Protocol", string4);
                            bl = true;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        return null;
                    }
                }
            } else if (n2 > 3) {
                if (n2 == 4 && string4.equals("/")) {
                    n = 0;
                } else if (n2 == 4) {
                    ((Hashtable)properties2).put("PGDBNAME", string4);
                    n = -2;
                } else if (n2 == 5 && n == 0 && string4.equals("/")) {
                    n = 1;
                } else {
                    if (n2 == 5 && n == 0) {
                        return null;
                    }
                    if (n2 == 6 && n == 1) {
                        ((Hashtable)properties2).put("PGHOST", string4);
                    } else if (n2 == 7 && string4.equals(":")) {
                        n = 2;
                    } else if (n2 == 8 && n == 2) {
                        try {
                            Integer n4 = Integer.decode(string4);
                            ((Hashtable)properties2).put("PGPORT", n4.toString());
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    } else if (!(n2 != 7 && n2 != 9 || n != 1 && n != 2 || !string4.equals("/"))) {
                        n = -1;
                    } else if (n == -1) {
                        ((Hashtable)properties2).put("PGDBNAME", string4);
                        n = -2;
                    } else if (n <= -2 && n2 % 2 == 1) {
                        if (string4.equals(";") || string4.equals("?") || string4.equals("&")) {
                            n = -3;
                        } else if (string4.equals("=")) {
                            n = -5;
                        }
                    } else if (n <= -2 && n2 % 2 == 0) {
                        if (n == -3) {
                            string2 = string4;
                        } else if (n == -5) {
                            string3 = string4;
                            ((Hashtable)properties2).put(string2, string3);
                            n = -2;
                        }
                    }
                }
            }
            ++n2;
        }
        return properties2;
    }

    public String host() {
        return this.props.getProperty("PGHOST", "localhost");
    }

    public int port() {
        return Integer.parseInt(this.props.getProperty("PGPORT", "5432"));
    }

    public String database() {
        return this.props.getProperty("PGDBNAME");
    }

    public String property(String string) {
        return this.props.getProperty(string);
    }

    public static SQLException notImplemented() {
        return new PSQLException("postgresql.unimplemented");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
            ConnectionHook.init();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        protocols = new String[]{"jdbc", "postgresql"};
    }
}

