/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbcx.base;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseConnectionProperties;
import com.microsoft.jdbc.base.BaseDriver;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseURLParser;
import com.microsoft.jdbcx.base.BaseClassUtilityX;
import com.microsoft.jdbcx.base.BaseLog;
import com.microsoft.jdbcx.base.BasePooledConnection;
import com.microsoft.util.UtilDebug;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class BaseDataSource
implements DataSource,
ConnectionPoolDataSource,
Referenceable,
Serializable {
    private static String footprint = "$Revision:   1.14.1.0  $";
    protected BaseExceptions exceptions;
    public UtilDebug debug;
    private transient PrintWriter printWriter;
    protected transient Object spyLogger;
    private transient boolean internalConnectionCallDoNotLog = false;
    protected String databaseName;
    String dataSourceName;
    String description;
    String password;
    String portNumber;
    String roleName;
    String serverName;
    String user;
    int loginTimeout = 0;
    boolean batchPerformanceWorkaround = false;
    String spyAttributes;
    boolean embedded = false;

    protected BaseConnection getBaseConnection() throws SQLException {
        this.setupExceptionHandling();
        BaseConnection baseConnection = BaseClassUtilityX.getConnection(this);
        BaseConnectionProperties baseConnectionProperties = this.getConnectionProperties(baseConnection);
        this.debug = BaseDriver.setupDebugging(baseConnectionProperties);
        baseConnection.open(baseConnectionProperties, this.exceptions, this.debug);
        return baseConnection;
    }

    protected BaseConnection getBaseConnection(String string, String string2) throws SQLException {
        this.setupExceptionHandling();
        BaseConnection baseConnection = BaseClassUtilityX.getConnection(this);
        BaseConnectionProperties baseConnectionProperties = this.getConnectionProperties(baseConnection);
        baseConnectionProperties.put("user", string);
        baseConnectionProperties.put("password", string2);
        this.debug = BaseDriver.setupDebugging(baseConnectionProperties);
        baseConnection.open(baseConnectionProperties, this.exceptions, this.debug);
        return baseConnection;
    }

    public final boolean getBatchPerformanceWorkaround() {
        return this.batchPerformanceWorkaround;
    }

    public final Connection getConnection() throws SQLException {
        BaseConnection baseConnection;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getConnection()");
        }
        try {
            baseConnection = this.getBaseConnection();
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return baseConnection;
        }
        Connection connection = BaseLog.GetSpyConnection(baseConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + connection + ")");
        return connection;
    }

    public final Connection getConnection(String string, String string2) throws SQLException {
        BaseConnection baseConnection;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getConnection(String user, String password)");
            BaseLog.Println(this.spyLogger, "user = " + string);
            BaseLog.Println(this.spyLogger, "password = ********");
        }
        try {
            baseConnection = this.getBaseConnection(string, string2);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return baseConnection;
        }
        Connection connection = BaseLog.GetSpyConnection(baseConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + connection + ")");
        return connection;
    }

    protected BaseConnectionProperties getConnectionProperties(BaseConnection baseConnection) throws SQLException {
        String string;
        BaseConnectionProperties baseConnectionProperties = new BaseConnectionProperties();
        baseConnectionProperties.putDefaults(baseConnection.getPropertyInfo());
        String string2 = BaseClassUtilityX.getRootName(this);
        String string3 = "jdbc:" + string2 + "://";
        if (this.serverName == null) {
            String[] stringArray = new String[]{"serverName"};
            throw this.exceptions.getException(6030, stringArray);
        }
        string3 = String.valueOf(string3) + this.serverName;
        if (this.portNumber == null) {
            String[] stringArray = new String[]{"portNumber"};
            throw this.exceptions.getException(6030, stringArray);
        }
        string3 = String.valueOf(string3) + ":" + this.portNumber;
        if (this.user != null) {
            string3 = String.valueOf(string3) + ";user=" + this.user;
        }
        if (this.password != null) {
            string3 = String.valueOf(string3) + ";password=" + this.password;
        }
        if (this.databaseName != null) {
            string3 = String.valueOf(string3) + ";databaseName=" + this.databaseName;
        }
        if (this.loginTimeout != 0) {
            string3 = String.valueOf(string3) + ";loginTimeout=" + new Integer(this.loginTimeout).toString();
        }
        if (this.embedded) {
            string3 = String.valueOf(string3) + ";embedded=true";
        }
        if (!baseConnection.getBatchIsJDBCCompliant()) {
            string3 = String.valueOf(string3) + ";batchPerformanceWorkaround=";
            string3 = this.batchPerformanceWorkaround ? String.valueOf(string3) + "true" : String.valueOf(string3) + "false";
        }
        if ((string = this.implGetPropertyNameValuePairs()) != null) {
            string3 = String.valueOf(string3) + ";" + string;
        }
        BaseURLParser baseURLParser = new BaseURLParser();
        baseURLParser.parse(string2, string3, true, baseConnectionProperties);
        return baseConnectionProperties;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final String getDatabaseName() {
        return this.databaseName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final boolean getEmbedded() throws SQLException {
        return this.embedded;
    }

    public final PrintWriter getLogWriter() throws SQLException {
        this.setupExceptionHandling();
        return this.printWriter;
    }

    public final int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public final String getPassword() {
        return this.password;
    }

    public final PooledConnection getPooledConnection() throws SQLException {
        BasePooledConnection basePooledConnection;
        Object object;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getPooledConnection()");
        }
        try {
            BasePooledConnection basePooledConnection2;
            object = this.getBaseConnection();
            basePooledConnection = basePooledConnection2 = new BasePooledConnection((BaseConnection)object, this.exceptions);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return basePooledConnection;
        }
        object = BaseLog.GetSpyPooledConnection(basePooledConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + object + ")");
        return object;
    }

    public final PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        BasePooledConnection basePooledConnection;
        Object object;
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
        if (this.spyLogger != null) {
            BaseLog.Println(this.spyLogger, "\nDataSource.getPooledConnection(String user, String password)");
            BaseLog.Println(this.spyLogger, "user = " + string);
            BaseLog.Println(this.spyLogger, "password = ********");
        }
        try {
            BasePooledConnection basePooledConnection2;
            object = this.getBaseConnection(string, string2);
            basePooledConnection = basePooledConnection2 = new BasePooledConnection((BaseConnection)object, this.exceptions);
        }
        catch (SQLException sQLException) {
            if (this.spyLogger != null) {
                throw BaseLog.GetSqlException(this.spyLogger, sQLException);
            }
            throw sQLException;
        }
        if (this.spyLogger == null) {
            return basePooledConnection;
        }
        object = BaseLog.GetSpyPooledConnection(basePooledConnection, this.spyLogger);
        BaseLog.Println(this.spyLogger, "OK (" + object + ")");
        return object;
    }

    public final int getPortNumber() {
        return Integer.parseInt(this.portNumber);
    }

    public final Reference getReference() throws NamingException {
        BaseConnection baseConnection;
        String string = BaseClassUtilityX.getRootName(this);
        String string2 = "com.microsoft.jdbcx." + string.toLowerCase() + "." + string + "DataSource";
        Reference reference = new Reference(string2, String.valueOf(string2) + "Factory", null);
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName != null) {
            reference.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("password", this.password));
        }
        if (this.portNumber != null) {
            reference.add(new StringRefAddr("portNumber", this.portNumber));
        }
        if (this.roleName != null) {
            reference.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.loginTimeout != 0) {
            reference.add(new StringRefAddr("loginTimeout", new Integer(this.loginTimeout).toString()));
        }
        if (this.embedded) {
            reference.add(new StringRefAddr("embedded", "true"));
        }
        if (this.spyAttributes != null) {
            reference.add(new StringRefAddr("spyAttributes", this.spyAttributes));
        }
        if (!(baseConnection = BaseClassUtilityX.getConnection(this)).getBatchIsJDBCCompliant()) {
            String string3 = this.batchPerformanceWorkaround ? "true" : "false";
            reference.add(new StringRefAddr("batchPerformanceWorkaround", string3));
        }
        this.implAddProperties(reference);
        return reference;
    }

    public final String getRoleName() {
        return this.roleName;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final String getSpyAttributes() throws SQLException {
        return this.spyAttributes;
    }

    public final String getUser() {
        return this.user;
    }

    protected void implAddProperties(Reference reference) {
    }

    protected String implGetPropertyNameValuePairs() throws SQLException {
        return null;
    }

    public final void setBatchPerformanceWorkaround(boolean bl) {
        this.batchPerformanceWorkaround = bl;
    }

    public final void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public final void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final void setEmbedded(boolean bl) throws SQLException {
        this.embedded = bl;
    }

    public final void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.setupExceptionHandling();
        this.printWriter = printWriter;
        this.spyLogger = printWriter == null ? null : BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
    }

    public final void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public final void setPassword(String string) {
        this.password = string;
    }

    public final void setPortNumber(int n) {
        this.portNumber = new Integer(n).toString();
    }

    public final void setRoleName(String string) {
        this.roleName = string;
    }

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final void setSpyAttributes(String string) throws SQLException {
        this.spyAttributes = string;
    }

    public final void setUser(String string) {
        this.user = string;
    }

    protected void setupExceptionHandling() throws SQLException {
        if (this.exceptions == null) {
            this.exceptions = new BaseExceptions(BaseClassUtilityX.getRootName(this));
        }
    }

    private void setupLogger() {
        if (this.spyLogger == null && this.spyAttributes != null) {
            this.spyLogger = BaseLog.GetSpyLoggerForDataSource(this, this.spyAttributes);
        }
    }
}

