/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseEscape;
import com.microsoft.jdbc.base.BaseEscapeParseInfoTreeNode;
import com.microsoft.jdbc.base.BaseParseInfoTree;
import com.microsoft.jdbc.base.BaseParseInfoTreeCursor;
import com.microsoft.jdbc.base.BaseParseInfoTreeNode;
import com.microsoft.util.UtilDebug;

public class BaseJoinEscape
extends BaseEscape {
    private static String footprint = "$Revision:   1.6  $";
    private int joinOperator = BaseParseInfoTreeNode.NO_OP;
    private String searchCondition = null;
    private String tableName = null;
    private String correlationName = null;
    private boolean firstOuterJoinRequest = false;
    private boolean firstTableReferenceRequest = false;
    private BaseParseInfoTreeCursor outerJoinCursor;
    private BaseParseInfoTreeCursor tableReferenceCursor;
    BaseParseInfoTree parseInfoTree = new BaseParseInfoTree();
    String parserBuiltTableReferenceName = "";
    String parserBuiltSearchCondition = "";

    public String getCurrentCorrelationName() {
        BaseParseInfoTreeCursor baseParseInfoTreeCursor = new BaseParseInfoTreeCursor(this.tableReferenceCursor);
        if (!baseParseInfoTreeCursor.moveToChild()) {
            UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
            return null;
        }
        if (!baseParseInfoTreeCursor.moveToSibling()) {
            UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
            return null;
        }
        if (!baseParseInfoTreeCursor.moveToChild()) {
            UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
            return null;
        }
        if (BaseEscapeParseInfoTreeNode.CORRELATION_NAME_OP == baseParseInfoTreeCursor.getNodeOperator()) {
            return baseParseInfoTreeCursor.getNodeLiteral();
        }
        if (BaseEscapeParseInfoTreeNode.EMPTY_OP == baseParseInfoTreeCursor.getNodeOperator()) {
            return null;
        }
        UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
        return null;
    }

    public int getCurrentJoinOperator() {
        return this.joinOperator;
    }

    public String getCurrentSearchCondition() {
        return this.searchCondition;
    }

    public String getCurrentTableName() {
        BaseParseInfoTreeCursor baseParseInfoTreeCursor = new BaseParseInfoTreeCursor(this.tableReferenceCursor);
        if (!baseParseInfoTreeCursor.moveToChild()) {
            UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
            return null;
        }
        return baseParseInfoTreeCursor.getNodeLiteral();
    }

    private boolean isJoinOperator(int n) {
        return BaseEscapeParseInfoTreeNode.LEFT_OUTER_JOIN_OP == n || BaseEscapeParseInfoTreeNode.RIGHT_OUTER_JOIN_OP == n || BaseEscapeParseInfoTreeNode.FULL_OUTER_JOIN_OP == n;
    }

    public boolean moveToNextOuterJoin() {
        boolean bl = true;
        if (!this.firstOuterJoinRequest) {
            this.outerJoinCursor = new BaseParseInfoTreeCursor(this.parseInfoTree);
            while (this.isJoinOperator(this.outerJoinCursor.getNodeOperator())) {
                if (!this.outerJoinCursor.moveToChild()) {
                    UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
                    return false;
                }
                if (this.outerJoinCursor.moveToSibling()) continue;
                UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
                return false;
            }
            this.firstOuterJoinRequest = true;
        }
        if (!this.outerJoinCursor.moveToSibling()) {
            bl = false;
        }
        if (bl) {
            this.searchCondition = this.outerJoinCursor.getNodeLiteral();
            if (!this.outerJoinCursor.moveToParent()) {
                UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
                return false;
            }
            this.joinOperator = this.outerJoinCursor.getNodeOperator();
        } else {
            this.searchCondition = null;
            this.joinOperator = BaseParseInfoTreeNode.NO_OP;
            bl = false;
        }
        return bl;
    }

    public boolean moveToNextTableReference() {
        boolean bl = true;
        if (!this.firstTableReferenceRequest) {
            this.tableReferenceCursor = new BaseParseInfoTreeCursor(this.parseInfoTree);
            if (!this.tableReferenceCursor.moveToChild()) {
                UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
                return false;
            }
            this.firstTableReferenceRequest = true;
        } else if (BaseEscapeParseInfoTreeNode.TABLE_REFERENCE_OP == this.tableReferenceCursor.getSiblingNodeOperator()) {
            if (!this.tableReferenceCursor.moveToSibling()) {
                UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
                return false;
            }
        } else if (this.isJoinOperator(this.tableReferenceCursor.getSiblingNodeOperator())) {
            if (!this.tableReferenceCursor.moveToSibling()) {
                UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
                return false;
            }
            if (!this.tableReferenceCursor.moveToChild()) {
                UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
                return false;
            }
        } else if (BaseEscapeParseInfoTreeNode.SEARCH_CONDITION_OP == this.tableReferenceCursor.getSiblingNodeOperator()) {
            bl = false;
        } else {
            UtilDebug.assert((String)"Unexpected parse tree.", (boolean)false);
            return false;
        }
        if (bl) {
            this.tableName = this.getCurrentTableName();
            this.correlationName = this.getCurrentCorrelationName();
        } else {
            this.tableName = null;
            this.correlationName = null;
        }
        return bl;
    }

    public void resetEscapeData() {
        super.resetEscapeData();
        this.parseInfoTree.reset();
        this.parserBuiltTableReferenceName = "";
        this.parserBuiltSearchCondition = "";
        this.firstOuterJoinRequest = false;
        this.outerJoinCursor = null;
        this.firstTableReferenceRequest = false;
        this.tableReferenceCursor = null;
    }
}

