/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseData;
import java.util.Vector;

public class BaseColumns {
    private static String footprint = "$Revision:   1.14  $";
    private Vector columns = new Vector();
    public static final int COUNT_ALL = 0;
    public static final int COUNT_EXPOSED = 1;
    public static final int COUNT_HIDDEN = 2;
    public static final int COUNT_KEY = 3;
    public static final int COUNT_AUTOINCREMENT = 4;
    private boolean countsValid = false;
    private int hiddenCount;
    private int exposedCount;
    private int allCount;
    private int keyCount;
    private int autoincrementCount;

    public void add(BaseColumn baseColumn) {
        this.columns.addElement(baseColumn);
        this.countsValid = false;
    }

    private void calculateCounts() {
        this.allCount = this.columns.size();
        this.hiddenCount = 0;
        this.exposedCount = 0;
        this.keyCount = 0;
        this.autoincrementCount = 0;
        int n = 0;
        while (n < this.allCount) {
            BaseColumn baseColumn = (BaseColumn)this.columns.elementAt(n);
            if (baseColumn.isHidden) {
                ++this.hiddenCount;
            } else {
                ++this.exposedCount;
            }
            if (baseColumn.isKey) {
                ++this.keyCount;
            }
            if (baseColumn.isAutoIncrement && !baseColumn.isHidden) {
                ++this.autoincrementCount;
            }
            ++n;
        }
        this.countsValid = true;
    }

    public int count(int n) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        if (n == 0) {
            return this.allCount;
        }
        if (n == 1) {
            return this.exposedCount;
        }
        if (n == 2) {
            return this.hiddenCount;
        }
        if (n == 3) {
            return this.keyCount;
        }
        if (n == 4) {
            return this.autoincrementCount;
        }
        return 0;
    }

    public BaseColumn get(int n) {
        BaseColumn baseColumn = (BaseColumn)this.columns.elementAt(n - 1);
        return baseColumn;
    }

    public int getOrdinal(String string) {
        int n = this.count(0);
        int n2 = 1;
        while (n2 <= n) {
            if (string.equalsIgnoreCase(this.get((int)n2).name)) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public boolean isValidColumnOrdinal(int n) {
        return n > 0 && n <= this.count(1);
    }

    public void markColumnsAsKeyStartingAt(int n, boolean bl) {
        this.allCount = this.columns.size();
        int n2 = n - 1;
        while (n2 < this.allCount) {
            BaseColumn baseColumn = (BaseColumn)this.columns.elementAt(n2);
            if (baseColumn.isSearchable && !baseColumn.isHidden && !BaseData.isStreamed(baseColumn.baseDataType)) {
                baseColumn.isKey = true;
            }
            if (bl) {
                baseColumn.isHidden = true;
            }
            ++n2;
        }
        this.countsValid = false;
    }

    public void reset() {
        if (this.columns != null) {
            this.columns.setSize(0);
        }
        this.countsValid = false;
    }

    public void resetCount() {
        this.countsValid = false;
    }
}

