<?php

/**************************************************
Program name:	configure.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Declare default variables
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/


// Set the name and version
$cfgProgName 	= "phpPgAdmin";
$cfgVersion 	= "3.0-dev";

// The default database is used to connect to the database to check the adv_auth
//	This can actually be any database you currently have on your system.  It just
//	needs _a_ database to connect and check the system tables.
//	NOTE:  This is the default when connecting to any server, so if you choose 
//	a database other than template1, then be sure it's on all your servers
//	WARNING:  When using persistant connections, you cannot create a new database
//	with a persistant connection to template1.
$cfgDefaultDB	= "template1";

// You should change the superuser if different from postgres
//	This is just used to filter out the system functions when listing
$cfgSuperUser	= "postgres";

//  Set to true if you want to authenticate against the passwd as well as the username
// 	In order to use adv_auth, you must update the passwords in the user admin section.
//	It is suggested that you leave this as false until you are able to get in and update the passwords.
$cfgUsePass	= false;

//  Set to true if you want to use the valuntil field in the pg_user table to verify users.
//	WARNING: you must set the expiration field on the account with which you want to
//		 login or else you will not get in.
//	It is suggested that you leave this as false until you are able to get in and
//		 update the expire fields.
$cfgUseExpire	= false;

//  If you want to be able to view the contents and structure of the System Catalog/Tables set this to true.  
//  If you are new to Postgres or are not familiar with the system tables, it is suggested you
//  leave this as false
$cfgSysTables 	= true;

//  If you want the web interface to administer postgres user, set this as true.
$cfgUserAdmin 	= true;

//  If you want to enable reporting
$cfgReports	= true;

//  If you want to filter the databases to only the ones the user has created or owns.  
//  This has no affect if the user is a superuser. (I THINK IT DOES HAVE AN EFFECT)
$cfgUserDatabases = false;

//  Set this to true during development of phpPgAdmin
$cfgDebug	= false;

//  If you do NOT want to quote all relations, set this to false
$cfgQuotesOn	= true;

//  Maximum pages to display link in browse
$cfgMaxPages	= 9;

$cfgStartOnHome = true;

//  If you do not want to display the tables of a database in the left frame, 
//  add it to this array
//  This feature is very useful when you have a database that has many tables
//  and slowes down the load of the left frame.
#$cfgNoTables[]	= "big_table";

//  The $cfgServers array starts with $cfgServers[1].  Do not use $cfgServers[0].
//  You can disable a server config entry by setting host to ''.
$cfgServers[1]['local']		= true;
$cfgServers[1]['host']		= 'localhost';
$cfgServers[1]['port']		= '5432';	// leave blank for default
$cfgServers[1]['adv_auth'] 	= true;
#$cfgServers[1]['stduser'] 	= '';
#$cfgServers[1]['stdpass'] 	= '';
$cfgServers[1]['user'] 		= 'postgres';
$cfgServers[1]['password'] 	= '';
$cfgServers[1]['only_db'] 	= '';	// if set to a db-name, only this db is accessible

$cfgServers[2]['local']		= false;
$cfgServers[2]['host'] 		= 'ke1'; 
$cfgServers[2]['port'] 		= '5432';	// leave blank for default
$cfgServers[2]['adv_auth'] 	= false;
#$cfgServers[2]['stduser'] 	= 'postgres';
#$cfgServers[2]['stdpass'] 	= 'postgres';
$cfgServers[2]['user'] 		= 'postgres';
$cfgServers[2]['password'] 	= 'postgres';
$cfgServers[2]['only_db'] 	= '';	// if set to a db-name, only this db is accessible

$cfgServers[3]['local']		= false;
$cfgServers[3]['host'] 		= 'j91';
$cfgServers[3]['port'] 		= '5432';	// leave blank for default
$cfgServers[3]['adv_auth'] 	= false;
#$cfgServers[3]['stduser'] 	= 'postgres';
#$cfgServers[3]['stdpass'] 	= 'postgres';
$cfgServers[3]['user'] 		= 'postgres';
$cfgServers[3]['password'] 	= 'postgres';
$cfgServers[3]['only_db'] 	= '';	// if set to a db-name, only this db is accessible

//  If you have more than one server configured, you can set $cfgServerDefault
//  to any one of them to autoconnect to that server when phpPGAdmin is started,
//  or set it to 0 to be given a list of servers without logging in
//  If you have only one server configured, $cfgServerDefault *MUST* be
//  set to that server.
$cfgServerDefault 		= 1;	// default server  (0 = no default server)

//  The selected server is copied here for easier access
//  IS THIS AN ARRAY.  SHOULD THIS BE GLOBAL
$cfgServer 			= '';

//  Unset $cfgServers[0] since 0 = no server (i.e. $cfgServers[0] must not be used)
unset($cfgServers[0]);	

//  User Manual URL for PostgreSQL
$cfgManualBase 			= "http://www.postgresql.org/users-lounge/docs/7.0/user";

//  Confirmation Screens On/Off
$cfgConfirm 			= true;

//  Persistent Connections On/Off
#$cfgPersistentConnections 	= false;  // Persistant Connections are currently unavailable.

//  Count Total Number of Records in Tables/Views
//  If you have a table with several thousands of records, you will want to set this false.
$cfgCountRecs			= true;

// If you want the fields alphabetized when inserting/editing, set to true.
$cfgDoOrder			= false;

$cfgBorder      			= "0";

$cfgThBgcolor				= "#D3DCE3";
$cfgBgcolorOne				= "#CCCCCC";
$cfgBgcolorTwo				= "#DDDDDD";
#$cfgBgcolorOne				= "#FFFFDE";
#$cfgBgcolorTwo				= "#FFFFCC";
$cfgMaxRows				= 10;
$cfgMaxInputsize			= "300px";
$cfgOrder				= "ASC";

// change this to point to your images directory - no trailing slash
$image_path 			= "images/";

// WHAT IS THIS
$cfgShowBlob				= false;

// WHAT IS THIS
$cfgShowSQL 				= true;

// Show Comments
$cfgShowComments			= true;

// Show Action
$cfgShowActions				= true;


// Set the maximum characters in any given field to diplay in "browse" mode - 0 is unlimited
$cfgMaxText				= 255;

$cfgMember      			= "#CCCCFF";
$cfgNonMember    			= "#CCCC99";
$cfgMaxTries     			= 10;

$cfgTemplate1 = "master_navpage.php";
$cfgMessagePage = "messagepage.php";
$cfgHttpHost = strtolower($HTTP_HOST) ;


?>
