/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef VIEWITEMPOPUP_H
#define VIEWITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "viewlistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a view item in the list viewer.
 */
class ViewItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	ViewListViewItem * m_poViewListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	ViewItemPopup(QWidget *pqoParent, ViewListViewItem *poViewListViewItem);

	/**
	 * Used to get a reference to the view item that this popup was generated from.
	 */
	ViewListViewItem * getViewListViewItem() const;
	
protected slots:	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void editComment();
	
private:

};


#endif

