/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef TRIGGERGROUPLISTVIEWITEM_H
#define TRIGGERGROUPLISTVIEWITEM_H

#include "../../baselistviewitem.h"
#include "../../../dataaccess/tables/triggers/dbtrigger.h"
#include "../../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent an index trigger.
 */
class TriggerGroupListViewItem: public BaseListViewItem, public DBMasterManagerRef
{
protected:
	string m_strTableName;
				
public:
	
	/**
 	 * Constructor
   */		
	TriggerGroupListViewItem(QListViewItem *pqoListViewItem);
	
	/**
 	 * Constructor
   */			
	TriggerGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
	
	/**
 	 * Used to set the table name.
 	 * @param rstrTableName	the table name
   */			    	
	void setTableName(const string & rstrTableName);
			
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();

};


#endif

