/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef TABLESCHEMAFORM_H
#define TABLESCHEMAFORM_H

#include "uic_tableschemaform.h"
#include "../../dataaccess/tables/dbtablecolumn.h"
#include "../../dataaccess/dbconnection.h"
#include "../../dataaccess/tables/dbtablemanager.h"
#include "tablelistviewitem.h"
#include <qstringlist.h>

/**
 * This object is used to depict a visual representation of the schema of
 * a database table.
 */
class TableSchemaForm: public UicTableSchemaForm
{
	Q_OBJECT
			
protected:
	const static int COLUMN_NAME_IDX;
	const static int COLUMN_TYPE_IDX;
	const static int COLUMN_SIZE_IDX;
	const static int COLUMN_PRIMARY_IDX;		
	const static int COLUMN_NULLABLE_IDX;	
	const static int COLUMN_DEFAULT_IDX;	
	const static int COLUMN_COMMENTS_IDX;			
	
	DBConnection m_oDBConn;
	DBTableManager m_oDBTableMgr;
	DBTableSchema m_oDBTableSchema;
	string m_strTableName;
	TableListViewItem * m_poTableListViewItem;
	int m_nRowCount;
	bool m_bNewTable;
	bool m_bSaved;
	QStringList m_qoTypeList;
	QStringList m_qoYesNoList;
				
public:
	
	/**
 	 * Constructor
   */		
  TableSchemaForm(QWidget* pqoParent, const DBConnection & roDBConn, const string & rstrTableName);

  /**
   * This function is used to populate this form with the schema details of an existing database table.
   */
  void getSchemaDetails();

public slots:
	/**
	 * This method is used to create a new table.
	 */
	void createTableSchema();
	
	/**
	 * This method is used to update a table.
	 */
	void updateTableSchema();
		
protected:
	/**
	 * This function is used to verify whether a row can be removed.
	 */
	bool isRemovable(int nRow) const throw (IndexOutOfRangeException);

	/**
	 * This function is used to verify whether a row can move up.
	 */
	bool isMoveableUp(int nRow) const throw (IndexOutOfRangeException);

	/**
	 * This function is used to verify whether a row can move down.
	 */
	bool isMoveableDown(int nRow) const throw (IndexOutOfRangeException);
	
	/**
	 * Converts a row in the table into a DBTableColumn object.
	 */
	void getTableColumn(int nRowIdx, DBTableColumn & roTableColumn) const throw (IndexOutOfRangeException);
		
protected slots:

	/**
	 * This slot is called when the close button is clicked.
	 */
	void processCloseClicked();

	/**
	 * This slot is called when the save button is clicked.
	 * This will call either createTableSchema or updateTableSchema
	 * depending on whether the table is new or modified.
	 */
	void processSaveClicked();
		
  /**
 	 * This slot is called when a new row needs to inserted.
 	 * The new row is always appended to the end of the table.
 	 */
 	void addRow();
 	
 	/**
 	 * This slot is called when a row needs to be deleted.
 	 */
 	void removeRow();
 	
 	/**
 	 * This will move the selected the row up.
 	 */
 	void moveRowUp();
 	
 	/**
 	 * This will move the selected the row down.
 	 */
 	void moveRowDown();

 	/**
 	 * This will be called when the table selection has changed.
 	 */
 	void processSelectionChanged();

 	/**
	 * This slot is called whenever the value of the table name changes.
	 */
  void processTableNameChanged(const QString &);
	 	
 	/**
 	 * This will be called when the value of a table column is changed.
 	 */
 	void processValueChanged(int nRow, int nCol); 	

 	/**
 	 * This will be called when the header is clicked.
 	 */
 	void processVerticalHeaderClicked(int nRow);  	 	 	

 	/**
 	 * This will be called when the header is pressed.
 	 */
 	void processVerticalHeaderPressed(int nRow);  	 	 	

 	/**
 	 * This will be called when the header is released.
 	 */
 	void processVerticalHeaderReleased(int nRow);  	 	 	
 	 	
	/**
 	 * This will be called when the header is clicked.
 	 */
 	void processHorizontalHeaderClicked(int nColumn);  	 	 	

 	/**
 	 * This will be called when the header is pressed.
 	 */
 	void processHorizontalHeaderPressed(int nColumn);  	 	 	

 	/**
 	 * This will be called when the header is released.
 	 */
 	void processHorizontalHeaderReleased(int nColumn);  	 	 	
 	
};


#endif

