/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef TABLEITEMPOPUP_H
#define TABLEITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "tablelistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a table item in the list viewer.
 */
class TableItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	TableListViewItem * m_poTableListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	TableItemPopup(QWidget *pqoParent, TableListViewItem *poTableListViewItem);

	/**
	 * Destructor
	 */
	~TableItemPopup();
	
	/**
	 * Used to get a reference to the table item that this popup was generated from.
	 */
	TableListViewItem * getTableListViewItem() const;
	
protected slots:	
	/**
 	 * This slot is called by the popup menu itself when view/edit schema is selected.
   */	
	void editTableSchema();

	/**
 	 * This slot is called by the popup menu itself when drop schema is selected.
   */	
	void dropTableSchema();
		
	/**
	 * This slot is called by the popup menu itself when view data is selected.
	 */
	void viewTableData();
	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void editComment();
	
private:

};


#endif

