/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "foreignkeylistviewitem.h"
#include "../../../utils/debugger.h"
#include "../../../utils/converter.h"
#include "../../../utils/stringutils.h"
#include "../../common/constants.h"

#include <iostream.h>

	ForeignKeyListViewItem::ForeignKeyListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBForeignKey(), DBMasterManagerRef()
	{
		// nothing to do
	} // end constructor

	ForeignKeyListViewItem::ForeignKeyListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBForeignKey(), DBMasterManagerRef()
	{
		// nothing to do
	} // end constructor
	
	/**
 	 * Used to update the description.
   */			    	
	void ForeignKeyListViewItem::updateDescription()
	{
		string strMethodName = "ForeignKeyListViewItem::updateDescription";
		Debugger::entered(strMethodName);
			
 		// format string to appear on description
 		string strOutputDesc = "<h1>Foreign Key</h1><hr><p><strong>Name</strong><br>"														
 													 + StringUtils::htmlstr(getForeignKeyName()) + "</p>"
 													 "<p><strong>Foreign Table</strong><br>"
 													 + StringUtils::htmlstr(getForeignTableName()) + "</p>";

 		strOutputDesc += "<p><strong>Foreign Column(s)</strong><br>";
 		for (int nColumnIdx = 0; nColumnIdx < getNumberOfForeignColumns(); nColumnIdx++)
 		{
 			if (nColumnIdx == 0)
 			{
 				strOutputDesc += getForeignColumn(nColumnIdx);
 			} // end if first column
 			else
 			{
 				strOutputDesc += ", " + getForeignColumn(nColumnIdx); 			
 			} // end else not first column 											
 		} // end for more referencing columns 														
														 			
 		// lets get the referencing columns
 		strOutputDesc += "</p><p><strong>Referencing Column(s)</strong><br>";
 		for (int nColumnIdx = 0; nColumnIdx < getNumberOfReferencingColumns(); nColumnIdx++)
 		{
 			if (nColumnIdx == 0)
 			{
 				strOutputDesc += getReferencingColumn(nColumnIdx);
 			} // end if first column
 			else
 			{
 				strOutputDesc += ", " + getReferencingColumn(nColumnIdx); 			
 			} // end else not first column 											
 		} // end for more referencing columns 														
 		// lets get the foreign colomns
 		strOutputDesc += "</p>";
			
 		Debugger::logTrace(strMethodName, "HTML generated: " + strOutputDesc);
			
 		m_qstrDescription = strOutputDesc.c_str();

		Debugger::exited(strMethodName);

	} // update getDescription
			
