/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "serverlistviewitem.h"
#include "databaselistviewitem.h"
#include "../utils/debugger.h"
#include "../utils/stringutils.h"
#include "../utils/converter.h"
#include "common/constants.h"
#include "serveritempopup.h"

// testing stuff
#include <iostream.h>

	ServerListViewItem::ServerListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem)
	{
		m_strServerName = "";
		m_nPortNumber = 5432;
		m_bLocalServer = false;
		updateDescription();		
	} // end constructor

	ServerListViewItem::ServerListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)	
		: BaseListViewItem(pqoListViewItem, pqoAfterItem)
	{
		m_strServerName = "";
		m_nPortNumber = 5432;
		m_bLocalServer = false;
		updateDescription();		
	} // end constructor
			
	/**
	 * This method is used to set the server name (could be IP address as well).
	 */
	void ServerListViewItem::setServerName(const string &rstrServerName)
	{
		m_strServerName = rstrServerName;
	} // end setServerName

	/**
	 * This method is used to get the server name (could be IP address as well).
	 */
	const string & ServerListViewItem::getServerName() const
	{
		return m_strServerName;
	} // end getServerName

	/**
	 * This method is used to set the server port number.
	 */
	void ServerListViewItem::setPortNumber(int nPortNumber)
	{
		m_nPortNumber = nPortNumber;
	} // end setPortNumber

	/**
	 * This method is used to get the port number.
	 */
	int ServerListViewItem::getPortNumber() const
	{
		return m_nPortNumber;
	} // end getPortNumber
		
	/**
	 * This method is used to indicate whether this address is local or not.
	 * If the address is set to be local then a local unix socket connection will
	 * be used instead of a TCP connection.
	 */
	void ServerListViewItem::setLocalServer(bool bLocalServer)
	{
		m_bLocalServer = bLocalServer;
	} // end setLocalServer

	/**
	 * This method is used to indicate whether this address is local or not.
	 * If the address is set to be local then a local unix socket connection will
	 * be used instead of a TCP connection.
	 */
	bool ServerListViewItem::isLocalServer() const
	{
		return m_bLocalServer;
	} // end isLocalServer

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void ServerListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new ServerItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
	} // end showRightPressedMenu
		
	/**
 	 * Used to update the description.
   */			    	
	void ServerListViewItem::updateDescription()
	{
		string strDescription = "<h1>Server</h1><hr><p><strong>Name</strong><br>" +
														StringUtils::htmlstr(getServerName()) +
														"</p><p><strong>Port</strong><br>" +
														Converter::intToString(getPortNumber()) +
														"</p><p><strong>Local</strong><br>";
		// lets see if its local or not
		if (isLocalServer())
		{
			strDescription += Constants::YES;
		} // end if server is local
		else
		{
			strDescription += Constants::NO;		
		} // end else server is not local
		strDescription += "</p>";	// close <p>
														
		m_qstrDescription = strDescription.c_str();		// convert over			
	} // end updateDescription
	
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void ServerListViewItem::initChildren()
	{	

		string strMethodName = "ServerListViewItem::initChildren";
		
		Debugger::entered(strMethodName);

		// need to add databases from Xml				
		
		Debugger::exited(strMethodName);
	} // end initChildren
 		