/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBFOREIGNKEYMANAGER_H
#define DBFOREIGNKEYMANAGER_H

#include <string>
#include "../../../exceptions/sqlexception.h"
#include "dbforeignkeyset.h"
#include "../../dbconnection.h"
#include "../../dbbasemanager.h"

/**
 * This class is used to manage operations concerning foreign keys. The class
 * provides many generic functions that can be used to retrieve/create/modify
 * foreign keys.
 */
class DBForeignKeyManager : public DBBaseManager
{
						
public:

	/**
 	 * Constructor
   */		
  DBForeignKeyManager();

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBForeignKeyManager(DBConnection *poDBConn);
	
	/**
 	 * Destructor
   */		
	~DBForeignKeyManager();

	/**
	 * Used to retrieve the list of foreign keys for the specified table.
	 * @return	a DBForeignKeySet object that contains the foreign key details
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void retrieveListOfForeignKeys(const string & rstrTableName, DBForeignKeySet & roDBForeignKeySet)
		 throw (SQLException, DBConnectionException);
		
};

#endif

