/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CXferWindow.h,v 1.4 1999/03/10 02:42:02 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LDragAndDrop.h>
#include <LActiveScroller.h>
#include <LWindow.h>
#include <LListener.h>
#include <LPeriodical.h>
#include <LCommander.h>
#include <LCicnButton.h>

#include "CXferThread.h"

class CXferView;
class CXferThread;
class CFileTable;
class CMessageQueue;
struct XSendFile;
struct XRcvFile;
struct XferInfo;

typedef struct HFSLinked
{
	HFSLinked *next;
	HFSFlavor hfsf;
} HFSLinked;

class CXferWindow		:	public LWindow,
							public LListener,
							public LPeriodical,
							public LCommander
{
public:
	enum { class_ID = 'XFwi' };
						CXferWindow(LStream *inStream);
						~CXferWindow();
	static CXferWindow*	CreateXferWindowStream(LStream *inStream);
	void				ListenToMessage(MessageT inMessage, void *ioParam);
	void				FinishCreateSelf();
	void				DrawSelf();
	void				DrawFocus();
	void				SetXferThread(CXferThread *xferThread);
	void				StartSend(XferInfo *xi);
	void				StartReceive(XferInfo *xi);
	void				EndSend();
	void				EndReceive();
	void				SpendTime(const EventRecord &inMacEvent);
	void				AddSend(HFSFlavor *hfsf);
	void				SendFile(FSSpec *fs, Boolean inDir);
	void				QueueSend(XSendFile *nxs);
	void				QueueReceive(XRcvFile *nxr);
	void				DequeueSend(XSendFile *nxs);
	void				DequeueReceive(XRcvFile *nxr);
	void				DeleteFromFocus();
	Boolean				ObeyCommand(
								CommandT			inCommand,
								void				*ioParam = nil);
	void				FindCommandStatus(
								CommandT			inCommand,
								Boolean				&outEnabled,
								Boolean				&outUsesMark,
								Char16				&outMark,
								Str255				outName);
	Boolean				HandleKeyPress(const EventRecord& inKeyEvent);
private:
	LCicnButton			*mAbortSend, *mAbortReceive;
	LActiveScroller		*mSendScroller, *mRcvScroller;
	CXferView			*mXVSend, *mXVReceive;
	CFileTable			*mReceiveTable, *mSendTable;
	CXferThread			*mXfer;
	CMessageQueue		*mXferQueue;
	HFSLinked			*mSends;
	XRcvFile			*mQReceives[MAXRCVFILES];
	XSendFile			*mQSends[MAXSNDFILES];
	long				mNumSends, mNumReceives;
	Boolean				mSendFocus;
	long				mRootDir;	// dirID for directory traverse
	short				mRootVol;	// vRefNum for directory traverse
};

