/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CDirTable.cp,v 1.4 1999/03/10 02:32:24 heller Exp $
____________________________________________________________________________*/
#include <UGAColorRamp.h>
#include <UDrawingState.h>
#include <UDrawingUtils.h>
#include <LTableMonoGeometry.h>
#include <LTableSingleSelector.h>
#include <LTableArrayStorage.h>

#include "CDirTable.h"
#include "CPFDirectoryWindow.h"
#include "PGPFoneUtils.h"


CDirTable*
CDirTable::CreateDirTableStream(
	LStream	*inStream)
{
	return (new CDirTable(inStream));
}

CDirTable::CDirTable(
	LStream	*inStream)
		: LTableView(inStream)
{
	mTableGeometry = new LTableMonoGeometry(this, mFrameSize.width, 16);
	mTableSelector = new LTableSingleSelector(this);
	mTableStorage = new LTableArrayStorage(this, sizeof(DirectoryEntry));
}

void
CDirTable::FinishCreateSelf()
{
}

CDirTable::~CDirTable()
{
}


void
CDirTable::DrawCell(
	const STableCell	&inCell,
	const Rect			&inLocalRect)
{
	Rect			iconRect;
	Uint32			dataSize = sizeof(DirectoryEntry);
	DirectoryEntry	dirEntry;
	
	GetCellData(inCell, &dirEntry, dataSize);
	ForeColor(blackColor);
	BackColor(whiteColor);
	iconRect.left = inLocalRect.left + 3;
	iconRect.right = iconRect.left + 16;
	iconRect.bottom = inLocalRect.bottom - 2;
	iconRect.top = iconRect.bottom - 16;
	::PlotIconID(&iconRect, atNone, ttNone, 1001);
	::TextSize(9);
	::TextFont(1);
	::TextFace(0);
	::MoveTo(inLocalRect.left + 22, inLocalRect.bottom - 4);
	::DrawString(dirEntry.name);
	::MoveTo(inLocalRect.left + 140, inLocalRect.bottom - 4);
	switch(dirEntry.connection)
	{
		case _cme_Internet:
			::DrawString("\pInternet");
			break;
		case _cme_Serial:
			::DrawString("\pModem");
			break;
		case _cme_AppleTalk:
			::DrawString("\pAppleTalk");
			break;
	}
}

void
CDirTable::ClickCell(
	const STableCell&		inCell,
	const SMouseDownEvent&	inMouseDown)
{
	if((inMouseDown.macEvent.when-mLastClickTime > LMGetDoubleTime()) ||
		(mLastClickCell != inCell))
	{
		mLastClickTime = inMouseDown.macEvent.when;
		mLastClickCell = inCell;
	}
	else
	{
		mLastClickTime = 0;
		BroadcastMessage('clkD', this);
	}
}

	void
CDirTable::DrawSelf()
{
	Rect frame;

	CalcLocalFrameRect(frame);
	::RGBBackColor(&UGAColorRamp::GetColor(colorRamp_White));
	::EraseRect(&frame);
	LTableView::DrawSelf();
}

void
CDirTable::HiliteCellActively(
	const STableCell	&inCell,
	Boolean				/*inHilite*/)
{
	Rect	cellFrame;
    if (GetLocalCellRect(inCell, cellFrame) && FocusExposed()) {
        StColorPenState saveColorPen;   // Preserve color & pen state
        StColorPenState::Normalize();
		ForeColor(blackColor);
		BackColor(whiteColor);
        UDrawingUtils::SetHiliteModeOn();
		::InvertRect(&cellFrame);
	}
}

void
CDirTable::HiliteCellInactively(
	const STableCell	&inCell,
	Boolean				/*inHilite*/)
{
	Rect	cellFrame;
	if (GetLocalCellRect(inCell, cellFrame) && FocusExposed()) {
        StColorPenState saveColorPen;   // Preserve color & pen state
        StColorPenState::Normalize();
		ForeColor(blackColor);
		BackColor(whiteColor);
		UDrawingUtils::SetHiliteModeOn();
		::PenMode(srcXor);
		::FrameRect(&cellFrame);
	}
}

