/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPCollectRandomDataDialog.cpp,v 1.4.8.1 1999/06/17 21:32:19 heller Exp $
____________________________________________________________________________*/
#include <stdio.h>

// PGP SDK header files
#include "pgpDialogs.h"
#include "pgpRandomPool.h"
#include "pgpKB.h"

// local globals
static PGPBoolean			g_bEntropy = FALSE;

//	______________________________________________
//
//  Entropy collection routine -- posts dialog for 
//  mouse/keyboard entropy collection.

PGPError
pgpCollectRandomDataDialogPlatform(
	PGPContextRef					context,
	CPGPRandomDataDialogOptions 	*options)
{
	PGPInt32 lRandBits = PGPGlobalRandomPoolGetEntropy();

	(void) context;
	
	if (g_bEntropy) 
		return kPGPError_ItemAlreadyExists;

	g_bEntropy = TRUE;
	PGPBoolean bCollectionEnabled = TRUE;

	// if zero passed in, use default
	PGPInt32 lTotalNeeded;
	if (options->mNeededEntropyBits) 
		lTotalNeeded = options->mNeededEntropyBits;
	else 
		lTotalNeeded = PGPGlobalRandomPoolGetMinimumEntropy();

	// if we have enough already, then just return
	if (lTotalNeeded < lRandBits) 
		return kPGPError_NoErr;

	// collect the entropy
	if (options->mPrompt)
		printf("%s\n", options->mPrompt);
	else
		printf("\n\
PGP a besoin de gnrer des donnes alatoires. Cela est fait en mesurant\n\
les intervalles de temps entre vos frappes de touche. Veuillez entrer du\n\
texte alatoire sur votre clavier jusqu' ce que l'indicateur atteigne 100%%.\n\
Appuyez sur ^D pour annuler\n");

	// Go into CBreak Mode
	PGPInt32 lStillNeeded = lTotalNeeded - lRandBits;
    kbCbreak(0);
	
	double dPercent = 0;
	while (bCollectionEnabled) {

		if (lRandBits > 0)
			dPercent = ((double) lRandBits / lTotalNeeded) * 100;

		if (dPercent > 100.5)
			dPercent = 100;

		if (dPercent >= 99.5 && lStillNeeded > 0)
			dPercent = 99.0;

		printf("\r");
		printf("%.0f%% des donnes requises   ", dPercent);
		fflush(stdout);
		
		if (lStillNeeded <= 0) {
			bCollectionEnabled = FALSE;
			printf("\n");
			break;
		}
		
		kbFlush(0);
		int c = kbGet();		// get the key and add to random pool
		if (c == 0x04) {
			g_bEntropy = FALSE;
			printf("\a\nCollection annule par l'utilisateur. \n");
			kbFlush(1);
			kbNorm();
			return kPGPError_UserAbort;
		}
		
		lRandBits = PGPGlobalRandomPoolGetEntropy();
		lStillNeeded = lTotalNeeded - lRandBits;
	}
	
    printf("\aAssez, merci.\n");;
	
	kbFlush(1);
    kbNorm();
	g_bEntropy = FALSE;

	return kPGPError_NoErr;
}

