/*____________________________________________________________________________
	pgpErrors.c
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: pgpErrors.c,v 1.71 1999/05/11 19:01:16 heller Exp $
____________________________________________________________________________*/
#include "pgpConfig.h"

#include <stdio.h>
#include <string.h>

#include "pgpDebug.h"
#include "pgpPubTypes.h"
#include "pgpErrors.h"
#include "pgpMem.h"


#include "pgpErrorsPriv.h"


typedef struct ErrorEntry
{
	PGPError const		number;
	const char * const	string;
} ErrorEntry;

#define EN(number, string)		{ number, string }


static const ErrorEntry sErrors[] =
{
/* __________________________________________________________________ */
/* later, if necessary, this table can be moved into its own file */


EN( kPGPError_BadPassphrase,			"Mauvaise phrase secrte"),
EN( kPGPError_RedundantOptions,		"Options redondantes"),
EN( kPGPError_OptionNotFound,		"Option non trouve"),
EN( kPGPError_CAPIUnsupportedKey,
						"La cl n'est pas supporte par la librairie Microsoft CAPI"),

EN( kPGPError_KeyRevoked,				"La cl a t rvoque"),
EN( kPGPError_KeyExpired,				"La cl a expir"),
EN( kPGPError_KeyDisabled,				"La cl a t dsactive"),
EN( kPGPError_KeyInvalid,				"La validit de la cl est basse ou inexistante"),
EN( kPGPError_KeyUnusableForEncryption,	"La cl ne peut pas tre utilise pour le chiffrement"),
EN( kPGPError_KeyUnusableForSignature,	"La cl ne peut pas tre utilise pour signer"),
EN( kPGPError_OutputBufferTooSmall,		"L'espace pour la sortie tait trop petit"),
EN( kPGPError_InconsistentEncryptionAlgorithms,"Pas d'alg pour tous les recips"),
EN( kPGPError_MissingPassphrase,			"La phrase secrte ncessaire manque"),
EN( kPGPError_CombinedConventionalAndPublicEncryption,"Les chiffrements conventionnel et public ne peuvent pas tre combins"),
EN( kPGPError_DetachedSignatureWithoutSigningKey,"Mauvaise combinaison des options"),
EN( kPGPError_DetachedSignatureWithEncryption,"Mauvaise combinaison des options"),
EN( kPGPError_NoInputOptions,			"Aucune entre n'a t spcifie"),
EN( kPGPError_MultipleInputOptions,		"Une seule option d'entre est autorise"),
EN( kPGPError_InputFile,					"Problme  l'ouverture du fichier d'entre"),
EN( kPGPError_NoOutputOptions,			"Aucune sortie n'a t spcifie"),
EN( kPGPError_MultipleOutputOptions,		"Une seule option de sortie est autorise"),
EN( kPGPError_MissingEventHandler,		"Evnements manquants"),
EN( kPGPError_MissingKeySet,				"Cl manquante"),
EN( kPGPError_DetachedSignatureFound,	"Une signature dtache a t trouve mais pas de fichier rattach"),
EN( kPGPError_NoDecryptionKeyFound,		"Impossible de dchiffrer, pas de cl"),
EN( kPGPError_CorruptSessionKey,			"La cl de session chiffre est mauvaise"),
EN( kPGPError_SkipSection,				"Sauter cette section"),
EN( kPGPError_Interrupted,				"Interruption non-fatale du travail"),
EN( kPGPError_TooManyARRKs,				"Limite ARR dpasse"),
EN( kPGPError_KeyUnusableForDecryption,	"La cl ne peut pas tre utilise pour le dchiffrement"),
EN( kPGPError_IncompatibleAPI,			"La version de librairie est trop vieille ou trop rcente"),

EN( kPGPError_NotMacBinary,						"Pas un fichier MacBinary"),
EN( kPGPError_NoMacBinaryTranslationAvailable,
		"Le fichier MacBinary ne peut pas tre traduit"),
EN( kPGPError_SelfTestFailed,			"L'auto test interne a chou"),


EN( kPGPError_InconsistentFilterClasses,	"Classes de filtre inconsistantes"),
EN( kPGPError_UnsupportedLDAPFilter,		"Cette recherche n'est pas disponible pour LDAP"),
EN( kPGPError_UnsupportedHKPFilter,		"Cette recherche n'est pas disponible pour HTTP"),
EN( kPGPError_UnknownFilterType,			"Type de filtre inconnu"),
EN( kPGPError_InvalidFilterParameter,	"Paramtre de filtre invalide"),


/* old errors: */
EN( kPGPError_OutOfRings,				"Bits du trousseau interne puis"),
EN( kPGPError_BadHashNumber,				"Hachage inconnu"),
EN( kPGPError_BadCipherNumber,			"Algorithme inconnu"),
EN( kPGPError_BadKeyLength,				"Longueur de cl pour le chiffre illgale"),
EN( kPGPError_SizeAdviseFailure,			"Conseil de taille non gard"),
EN( kPGPError_ConfigParseFailure,		"Erreur de configuration"),
EN( kPGPError_ConfigParseFailureBadFunction,"Fonction de configuration invalide"),
EN( kPGPError_ConfigParseFailureBadOptions,"Option de configuration inconnue"),
EN( kPGPError_KeyIsLocked,				"La cl exige une phrase secrte pour tre dverrouille"),
EN( kPGPError_CantDecrypt,				"Impossible de dchiffrer le message"),
EN( kPGPError_BadSessionKeySize,
	"Cl de session chiffre trop courte"),
EN( kPGPError_BadSessionKeyAlgorithm,
	"Algorithme de cl de session inconnu"),
EN( kPGPError_UnknownSignatureType,		"Type de signature inconnue"),
EN( kPGPError_BadSignatureSize,	"Signature trop longue ou trop courte"),
EN( kPGPError_SignatureBitsWrong,	"Mauvais nombre de bits dans la signature"),
EN( kPGPError_ExtraDateOnSignature,		"Donnes invalides pour la signature"),
EN( kPGPError_SecretKeyNotFound,			"Pas de cl secrte trouve"),
EN( kPGPError_PublicKeyNotFound,			"La cl secrte exige n'a pas t trouve"),
EN( kPGPError_AdditionalRecipientRequestKeyNotFound,
							"La demande de cl de destinataire supplmentaire n'a pas t trouve"),
EN( kPGPError_InvalidCommit,				"Invalide"),
EN( kPGPError_CantHash,					"Ne peut pas hacher le message"),
EN( kPGPError_UnbalancedScope,			"Scope non balanc"),
EN( kPGPError_WrongScope,				"Donnes envoyes dans le mauvais scope"),
EN( kPGPError_PublicKeyTooSmall,			"La cl publique est trop petite pour les donnes"),
EN( kPGPError_PublicKeyTooLarge,			"La cl publique est trop grande pour la librairie"),
EN( kPGPError_PublicKeyUnimplemented,"Opration de cl publique non implmente"),
EN( kPGPError_FIFOReadError,				"Lecture incomplte depuis le Fifo"),
EN( kPGPError_RandomSeedTooSmall,		"Pas assez de donnes dans le fichier randseed"),
EN( kPGPError_EnvPriorityTooLow,		"Variable d'environnement non rgle: priorit trop basse"),
EN( kPGPError_UnknownCharMap,			"Table de caractres inconnue"),
EN( kPGPError_AsciiParseIncomplete,		"Armature ASCII incomplte"),
EN( kPGPError_DeCompressionFailed,		"Erreur lors de la dcompression des donnes"),



EN( kPGPError_TroubleKeySubKey,			"La cl correspond  la sous-cl"),
EN( kPGPError_TroubleSigSubKey,			"Signature par la sous-cl"),
EN( kPGPError_TroubleBadTrust,			"Paquet de confiance malform"),
EN( kPGPError_TroubleUnknownPacketByte,	"Paquet inconnu PGPByte dans le trousseau"),
EN( kPGPError_TroubleUnexpectedSubKey,	"Sous-cl imprvue (avant la cl)"),
EN( kPGPError_TroubleUnexpectedName,		"Nom imprvu (avant la cl)"),
EN( kPGPError_TroubleUnexpectedSignature,"Signature imprvue (avant la cl)"),
EN( kPGPError_TroubleUnexpectedUnknown,
	"Paquet d'un type imprvu  un endroit imprvu (avant la cl)"),
EN( kPGPError_TroubleUnexpectedTrust,	"Paquet de confiance imprvu"),
EN( kPGPError_TroubleKeyTooBig,			"Cl trop grande"),
EN( kPGPError_TroubleSecretKeyTooBig,	"Cl secrte trop grande"),
EN( kPGPError_TroubleNameTooBig,			"Nom trop grand"),
EN( kPGPError_TroubleSignatureTooBig,	"Signature trop grande"),
EN( kPGPError_TroubleUnknownTooBig,
	"Paquet d'un type inconnu trop grand  supporter"),
EN( kPGPError_TroubleDuplicateKeyID,		"Identifiant de cl en double, cls diffrentes"),
EN( kPGPError_TroubleDuplicateKey,		"Cl en double (dans le mme trousseau)"),
EN( kPGPError_TroubleDuplicateSecretKey,"Cl secrte en double (dans le mme trousseau)"),
EN( kPGPError_TroubleDuplicateName,		"Nom en double (dans le mme trousseau)"),
EN( kPGPError_TroubleDuplicateSignature,
	"Signature en double (dans le mme trousseau)"),
EN( kPGPError_TroubleDuplicateUnknown,"lment en double dans le trousseau"),
EN( kPGPError_TroubleBareKey,			"Cl trouve sans nom"),
EN( kPGPError_TroubleVersionBugPrev,	"Bug introduit par la licence"),
EN( kPGPError_TroubleVersionBugCur,		"Bug introduit par la licence"),
EN( kPGPError_TroubleOldSecretKey,		"Phrase secrte avec une date prime"),
EN( kPGPError_TroubleNewSecretKey,		"La phrase secrte est plus rcente qu'une autre"),
EN( kPGPError_BadPacket,					"Mauvais paquet" ),
EN( kPGPError_BadIntegrity,				
	"Donnes modifies dtectes dans les donnes chiffres dont l'intgrit est protge"),
/*	
* Errors that can be encountered when parsing a key.
* If multiple errors apply, only the last is reported.
*
* Note: Obviously the modulus n = p*q must be odd, if p and q
* are both large primes, since all primes greater than 2 are odd.
* The exponent e must have a corresponding decryption exponent
* d such that e*d mod gcd(p-1,q-1), = 1.	Since p-1 and q-1 are both
* even, their gcd must also be even and thus e*d mod 2 = 1, implying
* that e mod 2 = 1.
* I.e. if e were even, the message would not be decryptable.
*/

/* kPGPError_KEY_LONG is a warning only */

EN( kPGPError_KEY_LONG,					"Paquet de cl trop long"),
EN( kPGPError_KeyPacketTruncated,		"Paquet de cl tronqu"),
EN( kPGPError_UnknownKeyVersion,			"Version de cl inconnue"),
EN( kPGPError_UnknownPublicKeyAlgorithm,	"Algorithme de cl inconnu"),
EN( kPGPError_MalformedKeyModulus,		"Modulus de cl mal format"),
EN( kPGPError_MalformedKeyExponent,		"Exponent de cl mal format"),
EN( kPGPError_RSAPublicModulusIsEven,	"Le modulus public RSA est jamais"),
EN( kPGPError_RSAPublicExponentIsEven,	"L'exponent public RSA est jamais"),
EN( kPGPError_MalformedKeyComponent,		"Composant de cl mal format"),

/*
* Errors that can be encountered when parsing a signature.
* If multiple errors apply, only the last is reported.
*/


EN( kPGPError_SIG_LONG,					"Paquet de signature trop long"),
EN( kPGPError_TruncatedSignature,		"Signature tronque"),
EN( kPGPError_MalformedSignatureInteger,	"Intgrateur de signature mal format"),
EN( kPGPError_UnknownSignatureAlgorithm,	"Algorithme de signature inconnu"),
EN( kPGPError_ExtraSignatureMaterial,	"Mauvaise signature extra matrielle (pas 5)"),
EN( kPGPError_UnknownSignatureVersion,	"Version de signature inconnue"),

/*	Mid-level key manipulation API error codes */
EN( kPGPError_OutOfEntropy,			"Bits alatoires insuffisants"),
EN( kPGPError_ItemIsReadOnly,		"L'objet est en lecture seule"),
EN( kPGPError_InvalidProperty,		"Proprit de nom invalide"),
EN( kPGPError_FileCorrupt,			"Base de donne de cl corrompue"),
EN( kPGPError_UnknownVersion,		"Version inconue"),
EN( kPGPError_DuplicateCert,			"Certification en double"),
EN( kPGPError_DuplicateUserID,		"Identifiant de cl en double"),
EN( kPGPError_CertifyingKeyDead,		"La cl certificatrice n'est plus valide"),
EN( kPGPError_ItemWasDeleted,		"L'objet a t effac"),

/*	Certificate Server error codes */
EN( kPGPError_ServerInProgress,	"Opration du serveur en cours"),
EN( kPGPError_ServerOperationNotSupported,	"Opration du serveur non supporte"),
EN( kPGPError_ServerInvalidProtocol,	"Procole du serveur invalide"),
EN( kPGPError_ServerRequestFailed,	"La requte a t rejete par le serveur"),
EN( kPGPError_ServerOpen,	"Serveur dj ouvert"),
EN( kPGPError_ServerNotOpen, "Serveur dj ouvert"),
EN( kPGPError_ServerKeyAlreadyExists,
								"La cl exacte existe dj sur le serveur"),
EN( kPGPError_ServerNotInitialized,	"Serveur non initialis"),
EN( kPGPError_ServerPartialAddFailure,
								"Des cls ne peuvent pas tre ajoutes au serveur"),
EN( kPGPError_ServerCorruptKeyBlock,	"Bloc de cl corrompu"),
EN( kPGPError_ServerUnknownResponse, "Rponse inconnue du serveur"),
EN( kPGPError_ServerTimedOut,	"Temps dpass"),
EN( kPGPError_ServerOpenFailed,		"Echec de l'ouverture du serveur"),
EN( kPGPError_ServerAuthorizationRequired, 
								"Autorisation ncessaire pour cette opration"),
EN( kPGPError_ServerAuthorizationFailed, 
									"L'autorisation pour cette opration a chou"),
EN( kPGPError_ServerSearchFailed,	"Echec de la recherche du serveur"),
EN( kPGPError_ServerPartialSearchResults,	"Le serveur a retourn des rsultats partiels"),
EN( kPGPError_ServerBadKeysInSearchResults,
								"Le serveur a retourn une ou plus d'une cls corrompues"),
EN( kPGPError_ServerKeyFailedPolicy, "La politique du serveur n'accepte pas la cl"),
EN( kPGPError_ServerOperationRequiresTLS, "L'opration exige TLS"),
EN( kPGPError_ServerNoStaticStorage,
		"Erreur du stockage statique du serveur"),

/* TLS error codes */
EN( kPGPError_TLSUnexpectedClose,
								"La connexion TLS s'est interrompue de manire imprvue"),
EN( kPGPError_TLSProtocolViolation,
					"Le systme distant a viol le protocole de connexion TLS"),
EN( kPGPError_TLSVersionUnsupported,
					"La version TLS du systme distant n'est pas compatible"),
EN( kPGPError_TLSWrongState,
					"Le systme distant a viol la squence de prise de contact de TLS"),
EN( kPGPError_TLSAlertReceived, "Le systme distant a interrompu la connexion TLS"),
EN( kPGPError_TLSKeyUnusable,
					"La cl slectionne n'a pas la capacit d'authentification TLS."),
EN( kPGPError_TLSNoCommonCipher,
			"Le chiffrement suggr par le systme distant TLS n'est pas utilisable"),
EN( kPGPError_TLSWouldBlock,
			"TLS bloquerait"),
EN( kPGPError_TLSRcvdHandshakeRequest,
			"Le systme distant exige une rengociation des cls"),

/* Sockets error codes */
EN( kPGPError_SocketsNetworkDown,	"Rseau coup"),
EN( kPGPError_SocketsNotInitialized, "Couche rseau non initialise"),
EN( kPGPError_SocketsInProgress,	"La couche rseau est dj en cours d'appel"),
EN( kPGPError_SocketsNotConnected,	"Couche rseau non connecte"),
EN( kPGPError_SocketsNotBound, "La couche rseau n'a pas t lance"),
EN( kPGPError_SocketsOperationNotSupported,
									"opration non supporte sur cette couche rseau"),
EN( kPGPError_SocketsProtocolNotSupported,
									"Protocole non support par les couches rseau"),
EN( kPGPError_SocketsAddressFamilyNotSupported,
									"Famille d'adresses non supporte par les couches rseau"),
EN( kPGPError_SocketsNotASocket,	"Ce n'est pas une couche rseau"),
EN( kPGPError_SocketsAddressInUse,	"Adresse dj utilise par une autre couche rseau"),
EN( kPGPError_SocketsBufferOverflow,	"Dpassement de buffer"),
EN( kPGPError_SocketsListenQueueFull,	"La queue d'coute est pleine"),
EN( kPGPError_SocketsAddressNotAvailable,	"L'adresse n'est pas disponible pour la couche rseau"),
EN( kPGPError_SocketsAlreadyConnected,	"La couche rseau est dj connecte"),
EN( kPGPError_SocketsTimedOut,	"Temps dpass pour la couche rseau pendant l'opration"),
EN( kPGPError_SocketsHostNotFound,	"Hte non trouv"),
EN( kPGPError_SocketsDomainServerError,	"Erreur dans le systme de nom de domaine"),
EN( kPGPError_SocketsNoStaticStorage,
		"Erreur du stockage statique de la couche rseau"),

/* X.509 errors */
EN( kPGPError_X509AttributeNotSupported,  "Attribut X.509 non support"),
EN( kPGPError_InvalidPKCS7Encoding,  "Impossible d'analyser les donnes PKCS-7"),
EN( kPGPError_CMSInitialization,  "Impossible d'initialiser CMS"),
EN( kPGPError_InvalidDistinguishedName,
	"Caractre invalide dans un nom distingu X.509"),
EN( kPGPError_CertRequestCreationFailure,  "Echec de la requte tc_create_request()"),
EN( kPGPError_MissingX509Certificate,
	"Impossible de localiser un cert x.509 cert associ avec la cl"),
EN( kPGPError_PKCS7SignFailure,
	"Erreur survenue lors de la tentative de signature d'un message PKCS-7"),
EN( kPGPError_ASNPackFailure,  "Echec lors du paquetage de donnes ASN.1"),
EN( kPGPError_InvalidInputFormat,  "Format d'entre PGP inconnu"),
EN( kPGPError_InvalidOutputFormat,  "Format de sortie PGP inconnu"),

EN(	kPGPError_BadSignature, "Mauvaise signature"),
EN(	kPGPError_BigNumNoInverse, "Pas de grand nombre inverse"),
EN(	kPGPError_CRLPacketTruncated, "Paquet CRL tronqu"),
EN(	kPGPError_CRSInvalidAttributeType, "Tpe d'attribut invalide"),
EN(	kPGPError_CRSInvalidAttributeValueLength, "Longueur d'attribut invalide"),
EN(	kPGPError_CRSInvalidAuthenticateValue, "Valeur d'authentification invalide"),
EN(	kPGPError_CRSInvalidCertType, "Type de certificat invalide"),
EN(	kPGPError_CRSInvalidCharacter, "Caractre invalide"),
EN(	kPGPError_CRSMissingRequiredAttribute, "Manque un attribut exig"),
EN(	kPGPError_InvalidCertificateExtension, "Extension de certificat invalide"),
EN(	kPGPError_KeyDBMismatch, "Les bases de donnes de cls ne correspondent pas"),
EN(	kPGPError_KeyTooLarge, "Cl trop grande"),
EN(	kPGPError_RevocationKeyNotFound, "Cl de rvocation non trouve"),
EN(	kPGPError_SelfTestsNotExecuted, "Les auto tests n'ont pas t excuts"),
EN(	kPGPError_ServerCertNotFound, "Certificat introuvable"),
EN(	kPGPError_TroubleCRLTooBig, "CRL trop grand"),
EN(	kPGPError_TroubleDuplicateCRL, "CRL en double"),
EN(	kPGPError_TroubleImportingNonexportableSignature, "Signature non-exportable trouve pendant l'importation"),
EN(	kPGPError_UnknownString2Key, "Cl inconnue"),
EN(	kPGPError_UnsupportedNetToolsCAFilter, "Type de filtre non support"),
EN(	kPGPError_X509InvalidCertificateFormat, "Format de certificat invalide"),
EN(	kPGPError_X509InvalidCertificateSignature, "Signature de certificat invalide"),
EN(	kPGPError_X509NeededCertNotAvailable, "Le certificat exig n'a pas t trouv"),
EN(	kPGPError_X509SelfSignedCert, "Des certificats auto signs ont t trouvs")

};
#define kPGPErrors_NumErrorTableEntries		\
	( sizeof( sErrors ) / sizeof( sErrors[ 0 ] ) )

#undef EN


	
	PGPError 
PGPGetErrorString(
	PGPError	theError,
	PGPSize		bufferSize,
	char *		theString )
{
	PGPUInt32		idx;
	char			temp[ 256 ];
	char const *	errStr	= NULL;
	PGPSize			len	= 0;
	PGPBoolean		bufferBigEnough	= FALSE;
	
	if (theError >= kPGPPFLErrorBase && theError <= kPGPError_LastPFLError )
		return PGPGetPFLErrorString(theError, bufferSize, theString);

	PGPValidateParam( bufferSize >= 1 );
	PGPValidatePtr( theString );
	*theString	= '\0';
	
	for( idx = 0; idx < kPGPErrors_NumErrorTableEntries; ++idx )
	{
		const ErrorEntry *	entry;
		
		entry	= &sErrors[ idx ];
		if ( entry->number == theError )
		{
			errStr	= entry->string;
			break;
		}
	}
	
	if ( IsNull( errStr ) )
	{
		/* Produce something for missing errors */
		sprintf( temp, "PGPError #%ld", (long)theError );
		errStr	= temp;
	}
	
	len	= strlen( errStr );
	bufferBigEnough	= ( len + 1 <= bufferSize );
	if ( bufferBigEnough )
	{
		strcpy( theString, errStr );
	}
	else
	{
		pgpCopyMemory( errStr, theString, bufferSize - 1 );
		theString[ bufferSize - 1 ]	= '\0';
	}
	
	return( bufferBigEnough	? kPGPError_NoErr : kPGPError_BufferTooSmall );
}



/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
