/*____________________________________________________________________________
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: pgpPFLErrors.c,v 1.2 1999/04/02 09:20:04 jason Exp $
____________________________________________________________________________*/
#include <stdio.h>
#include <string.h>

#include "pgpPFLErrors.h"
#include "pgpMem.h"


typedef struct PFLErrorEntry
{
	PGPError const		number;
	const char * const	string;
} PFLErrorEntry;

#define EN(number, string)		{ number, string }


static const PFLErrorEntry sErrors[] =
{
EN( kPGPError_NoErr,					"ce n'est pas une erreur"),
EN( kPGPError_BadParams,				"mauvais paramtres"),
EN( kPGPError_OutOfMemory,				"plus de mmoire"),
EN( kPGPError_BufferTooSmall,			"buffer trop petit"),

EN( kPGPError_FileNotFound,				"fichier non trouv"),
EN( kPGPError_CantOpenFile,				"impossible d'ouvrir le fichier"),
EN( kPGPError_FilePermissions,			"permissions sur le fichier"),
EN( kPGPError_FileLocked,				"fichier verrouill"),
EN( kPGPError_IllegalFileOp,			"opration illgale sur fichier"),
EN( kPGPError_FileOpFailed,				"erreur d'opration sur le fichier"),
EN( kPGPError_ReadFailed,				"chec de la lecture"),
EN( kPGPError_WriteFailed,				"chec de l'criture"),
EN( kPGPError_EOF,						"fin de fichier"),

EN( kPGPError_UserAbort,				"annul par l'utilisateur"),
EN( kPGPError_UnknownRequest,			"requte non reconnue"),
EN( kPGPError_LazyProgrammer,			"erreur inconnue"),
EN( kPGPError_ItemNotFound,				"lment non trouv"),
EN( kPGPError_ItemAlreadyExists,		"l'lment existe dj"),
EN( kPGPError_AssertFailed,				"l'assertion a chou"),
EN( kPGPError_BadMemAddress,			"mauvaise adresse mmoire"),
EN( kPGPError_UnknownError,				"erreur inconnue"),

EN( kPGPError_PrefNotFound,				"prfrence non trouve"),
EN( kPGPError_EndOfIteration,			"fin de l'itration"),
EN( kPGPError_ImproperInitialization,	"mauvaise initialisation"),
EN( kPGPError_CorruptData,				"donnes corrompues"),
EN( kPGPError_FeatureNotAvailable,		"fonction non disponible"),

EN( kPGPError_DiskFull,					"disque plein"),
EN( kPGPError_DiskLocked,				"disque verrouill"),
};

#define kPFLErrors_NumErrorTableEntries		\
	( sizeof( sErrors ) / sizeof( sErrors[ 0 ] ) )

#undef EN


	
	PGPError 
PGPGetPFLErrorString(
	PGPError	theError,
	PGPSize		bufferSize,
	char *		theString )
{
	PGPUInt32		idx;
	char			temp[ 256 ];
	char const *	errStr	= NULL;
	PGPSize			len	= 0;
	PGPBoolean		bufferBigEnough	= FALSE;
	
	PGPValidateParam( bufferSize >= 1 );
	PGPValidatePtr( theString );
	*theString	= '\0';
	
	for( idx = 0; idx < kPFLErrors_NumErrorTableEntries; ++idx )
	{
		const PFLErrorEntry *	entry;
		
		entry	= &sErrors[ idx ];
		if ( entry->number == theError )
		{
			errStr	= entry->string;
			break;
		}
	}
	
	if ( IsNull( errStr ) )
	{
		/* Produce something for missing errors */
		sprintf( temp, "PFLError #%ld", (long)theError );
		errStr	= temp;
	}
	
	len	= strlen( errStr );
	bufferBigEnough	= ( len + 1 <= bufferSize );
	if ( bufferBigEnough )
	{
		strcpy( theString, errStr );
	}
	else
	{
		pgpCopyMemory( errStr, theString, bufferSize - 1 );
		theString[ bufferSize - 1 ]	= '\0';
	}
	
	return( bufferBigEnough	? kPGPError_NoErr : kPGPError_BufferTooSmall );
}



/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
