#include <stdio.h>
#include <string.h>

#if PGPSOCKETSLDAP	/* jason */
#include "pgpSocketsLDAP.h"

#else
#ifdef MACOS
#include <stdlib.h>
#else /* MACOS */
#if defined( DOS ) || defined( _WIN32 )
#include <malloc.h>
#ifdef DOS
#include "msdos.h"
#endif
#else /* DOS */
#include <sys/types.h>
#include <sys/socket.h>
#endif /* DOS */
#endif /* MACOS */
#endif /* PGPSOCKETSLDAP */

#include "lber.h"
#include "ldap.h"

struct ldaperror {
	int	e_code;
	char	*e_reason;
};

static struct ldaperror ldap_errlist[] = {
	LDAP_SUCCESS, 			"Succs",
	LDAP_OPERATIONS_ERROR, 		"Erreur d'oprations",
	LDAP_PROTOCOL_ERROR, 		"Erreur de protocole",
	LDAP_TIMELIMIT_EXCEEDED,	"Limite de temps dpasse",
	LDAP_SIZELIMIT_EXCEEDED, 	"Limite de taille dpasse",
	LDAP_COMPARE_FALSE, 		"Compare false",
	LDAP_COMPARE_TRUE, 		"Compare true",
	LDAP_STRONG_AUTH_NOT_SUPPORTED, "Authentification rsistante non supporte",
	LDAP_STRONG_AUTH_REQUIRED, 	"Authentification rsistante requise",
	LDAP_PARTIAL_RESULTS, 		"Rsultats et rfrent partiels reus",
	LDAP_NO_SUCH_ATTRIBUTE, 	"Pas d'attribut",
	LDAP_UNDEFINED_TYPE, 		"Type d'attribut non dfini",
	LDAP_INAPPROPRIATE_MATCHING, 	"Correspondance inapproprie",
	LDAP_CONSTRAINT_VIOLATION, 	"Violation de contrainte",
	LDAP_TYPE_OR_VALUE_EXISTS, 	"Le type ou la valeur existe",
	LDAP_INVALID_SYNTAX, 		"Syntaxe invalide",
	LDAP_NO_SUCH_OBJECT, 		"Pas d'objet",
	LDAP_ALIAS_PROBLEM, 		"Problme d'alias",
	LDAP_INVALID_DN_SYNTAX,		"Syntaxe DN invalide",
	LDAP_IS_LEAF, 			"Object is a leaf",
	LDAP_ALIAS_DEREF_PROBLEM, 	"Problme d'alias drfrenant",
	LDAP_INAPPROPRIATE_AUTH, 	"Authentification inapproprie",
	LDAP_INVALID_CREDENTIALS, 	"Invalid credentials",
	LDAP_INSUFFICIENT_ACCESS, 	"Accs insuffisant",
	LDAP_BUSY, 			"DSA est occup",
	LDAP_UNAVAILABLE, 		"DSA n'est pas disponible",
	LDAP_UNWILLING_TO_PERFORM, 	"DSA n'est pas dispos  s'excuter",
	LDAP_LOOP_DETECT, 		"Loop dtect",
	LDAP_NAMING_VIOLATION, 		"Violation de nommage",
	LDAP_OBJECT_CLASS_VIOLATION, 	"Violation de classe d'objet",
	LDAP_NOT_ALLOWED_ON_NONLEAF, 	"Operation not allowed on nonleaf",
	LDAP_NOT_ALLOWED_ON_RDN, 	"Opration non autorise sur RDN",
	LDAP_ALREADY_EXISTS, 		"Existe dj",
	LDAP_NO_OBJECT_CLASS_MODS, 	"Ne peut pas modifier la classe d'objet",
	LDAP_RESULTS_TOO_LARGE,		"Resultats trop larges",
	LDAP_OTHER, 			"Erreur inconnue",
	LDAP_SERVER_DOWN,		"Ne peut pas contacter le serveur LDAP",
	LDAP_LOCAL_ERROR,		"Erreur locale",
	LDAP_ENCODING_ERROR,		"Erreur de codage",
	LDAP_DECODING_ERROR,		"Erreur de dcodage",
	LDAP_TIMEOUT,			"Temps dpass",
	LDAP_AUTH_UNKNOWN,		"Mthode d'authentification inconnue",
	LDAP_FILTER_ERROR,		"Mauvais filtre de recherche",
	LDAP_USER_CANCELLED,		"Opration annule par l'utilisateur",
	LDAP_PARAM_ERROR,		"Mauvais paramtre vers une routine ldap",
	LDAP_NO_MEMORY,			"Plus de mmoire",
	-1, 0
};

char *
ldap_err2string( int err )
{
	int	i;

	Debug( LDAP_DEBUG_TRACE, "ldap_err2string\n", 0, 0, 0 );

	for ( i = 0; ldap_errlist[i].e_code != -1; i++ ) {
		if ( err == ldap_errlist[i].e_code )
			return( ldap_errlist[i].e_reason );
	}

	return( "Unknown error" );
}

#ifndef NO_USERINTERFACE
void
ldap_perror( LDAP *ld, char *s )
{
	int	i;

	Debug( LDAP_DEBUG_TRACE, "ldap_perror\n", 0, 0, 0 );

	if ( ld == NULL ) {
		perror( s );
		return;
	}

	for ( i = 0; ldap_errlist[i].e_code != -1; i++ ) {
		if ( ld->ld_errno == ldap_errlist[i].e_code ) {
			fprintf( stderr, "%s: %s\n", s,
			    ldap_errlist[i].e_reason );
			if ( ld->ld_matched != NULL && *ld->ld_matched != '\0' )
				fprintf( stderr, "%s: matched: %s\n", s,
				    ld->ld_matched );
			if ( ld->ld_error != NULL && *ld->ld_error != '\0' )
				fprintf( stderr, "%s: additional info: %s\n",
				    s, ld->ld_error );
			fflush( stderr );
			return;
		}
	}

	fprintf( stderr, "%s: Not an LDAP errno %d\n", s, ld->ld_errno );
	fflush( stderr );
}

#else

void
ldap_perror( LDAP *ld, char *s )
{
	(void) ld;
	(void) s;
}

#endif /* NO_USERINTERFACE */


int
ldap_result2error( LDAP *ld, LDAPMessage *r, int freeit )
{
	LDAPMessage	*lm;
	BerElement	ber;
	long		along;
	int		rc;

	Debug( LDAP_DEBUG_TRACE, "ldap_result2error\n", 0, 0, 0 );

	if ( r == NULLMSG )
		return( LDAP_PARAM_ERROR );

	for ( lm = r; lm->lm_chain != NULL; lm = lm->lm_chain )
		;	/* NULL */

	if ( ld->ld_error ) {
		free( ld->ld_error );
		ld->ld_error = NULL;
	}
	if ( ld->ld_matched ) {
		free( ld->ld_matched );
		ld->ld_matched = NULL;
	}

	ber = *(lm->lm_ber);
	if ( ld->ld_version == LDAP_VERSION2 ) {
		rc = ber_scanf( &ber, "{iaa}", &along, &ld->ld_matched,
		    &ld->ld_error );
	} else {
		rc = ber_scanf( &ber, "{ia}", &along, &ld->ld_error );
	}
	if ( rc == LBER_ERROR ) {
		ld->ld_errno = LDAP_DECODING_ERROR;
	} else {
		ld->ld_errno = (int) along;
	}

	if ( freeit )
		ldap_msgfree( r );

	return( ld->ld_errno );
}
