/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPOptionsGrafPort.cp,v 1.7.12.1 1998/11/12 03:20:35 heller Exp $
____________________________________________________________________________*/

// Public includes:
#include <LCheckBox.h>
#include <LPopupButton.h>
#include <LPushButton.h>
#include <UDrawingState.h>
#include <UGAColorRamp.h>

#include "CComboError.h"
#include "MacStrings.h"
#include "pgpMem.h"

// Private includes:
#include "CPGPCheckboxOptionView.h"
#include "CPGPPopupMenuOptionView.h"
#include "CPGPOptionsGrafPort.h"
#include "CPGPOptionsListView.h"
#include "pgpDialogs.h"
#include "pgpOptionListPriv.h"

const PaneIDT	kOptionsListViewPaneID = 'OLST';

CPGPOptionsGrafPort::CPGPOptionsGrafPort(LStream *inStream)
	: CPGPUIGrafPortView(inStream)
{
	mOptions = NULL;
}

CPGPOptionsGrafPort::~CPGPOptionsGrafPort()
{
}

	void
CPGPOptionsGrafPort::UpdatePort(void)
{
	StColorPortState	savePortState( GetMacPort() );
	RGBColor			foreColor;
	RGBColor			backColor;
	
	// Revert to dark gray to erase the window background
	foreColor = UGAColorRamp::GetBlackColor();
	backColor = UGAColorRamp::GetColor( colorRamp_Gray2 );

	RGBForeColor( &foreColor );
	RGBBackColor( &backColor );
	
	CPGPUIGrafPortView::UpdatePort();
}

	void
CPGPOptionsGrafPort::DrawSelf(void)
{
	StColorState	saveColors;
	RGBColor		foreColor;
	RGBColor		backColor;
	
	// Revert to dark gray to draw the window background
	foreColor = UGAColorRamp::GetBlackColor();
	backColor = UGAColorRamp::GetColor( colorRamp_Gray2 );

	RGBForeColor( &foreColor );
	RGBBackColor( &backColor );

	CPGPUIGrafPortView::DrawSelf();
}

	void
CPGPOptionsGrafPort::FinishCreateSelf(void)
{
	RGBColor	foreColor;
	RGBColor	backColor;
	
	CPGPUIGrafPortView::FinishCreateSelf();
	
	mOptionsListView = (CPGPOptionsListView *)
							FindPaneByID( kOptionsListViewPaneID );
	pgpAssertAddrValid( mOptionsListView, VoidAlign );

	foreColor = UGAColorRamp::GetBlackColor();
	backColor = UGAColorRamp::GetColor( colorRamp_Gray1 );

	SetForeAndBackColors( &foreColor, &backColor );
	ApplyForeAndBackColors();
}

	void
CPGPOptionsGrafPort::AppendOptionView(
	CPGPOptionView 	*theView,
	Boolean			inRefresh)
{
	pgpAssertAddrValid( mOptionsListView, VoidAlign );
	mOptionsListView->AppendOptionView( theView, inRefresh );
}

	PGPError
CPGPOptionsGrafPort::SetOptions(
	PGPContextRef 				context,
	CPGPOptionsDialogOptions 	*options)
{
	PGPError	err = kPGPError_NoErr;
	
	err = CPGPUIGrafPortView::SetOptions( context, options );
	if( IsntPGPError( err ) )
	{
		PGPUInt32	optionIndex	= 0;
		PGPOption	optionData;
		
		mOptions = options;
		
		/* Build list of checkboxes and/or popups */
		
		while( IsntPGPError( pgpGetIndexedOption( options->mClientOptions,
						optionIndex, FALSE, &optionData ) ) )
		{
			if( optionData.type == kPGPOptionType_Checkbox )
			{
				PGPOUICheckboxDesc		*descriptor;
				CPGPCheckboxOptionView	*checkboxView;
				
				descriptor = (PGPOUICheckboxDesc *) optionData.value.asPtr;

				checkboxView = CPGPCheckboxOptionView::
									CreateCheckboxOptionView(mOptionsListView,
										descriptor );
				if( IsntNull( checkboxView ) )
				{
					mOKButton->AddListener( checkboxView );

					AppendOptionView( checkboxView, FALSE );
				}
				else
				{
					err = kPGPError_OutOfMemory;
					break;
				}
			}
			else if( optionData.type == kPGPOptionType_PopupList )
			{
				PGPOUIPopupListDesc		*descriptor;
				CPGPPopupMenuOptionView	*popupView;
				
				descriptor = (PGPOUIPopupListDesc *) optionData.value.asPtr;

				popupView = CPGPPopupMenuOptionView::
									CreatePopupMenuOptionView(
										mOptionsListView, descriptor );
				if( IsntNull( popupView ) )
				{
					mOKButton->AddListener( popupView );

					AppendOptionView( popupView, FALSE );
				}
				else
				{
					err = kPGPError_OutOfMemory;
					break;
				}
			}
			
			++optionIndex;
		}
	}
	
	return( err );
}