/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CWarningAlert.h,v 1.6.12.1 1998/11/12 03:19:06 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LGADialog.h>

const ResIDT	kWarningAlertDialogResID = 31500;

#include "WarningAlertTypes.h"


class CWarningAlert : public LGADialog
{
public:

	enum { class_ID = 'Warn' };

					CWarningAlert();
	virtual			~CWarningAlert();
					CWarningAlert(LStream *inStream);

	virtual void	ApplyForeAndBackColors() const;
	void			HideCancelButton(void);
	void			SetMessage(ConstStr255Param message);
	void			SetButtonTitle(PaneIDT buttonPaneID,
						ConstStr255Param descriptor);

	Boolean			SetupDialog(
						WarningAlertType	alertType,
						WarningAlertStyle	alertStyle,
						ConstStr255Param	message,
						ConstStr255Param	str1 = NULL,
						ConstStr255Param	str2 = NULL,
						ConstStr255Param	str3 = NULL);
				

	static MessageT	Display(WarningAlertType alertType,
						WarningAlertStyle alertStyle, 
						ConstStr255Param message,
						ConstStr255Param str1 = NULL,
						ConstStr255Param str2 = NULL,
						ConstStr255Param str3 = NULL);
					
	static MessageT	Display(WarningAlertType alertType,
						WarningAlertStyle alertStyle, 
						ResIDT stringListResID,
						short stringListIndex,
						ConstStr255Param str1 = NULL,
						ConstStr255Param str2 = NULL,
						ConstStr255Param str3 = NULL);
					
	static MessageT	DisplayCustom(
						short dialogResID,
						WarningAlertType alertType,
						WarningAlertStyle alertStyle,
						ConstStr255Param message,
						ConstStr255Param str1 = NULL,
						ConstStr255Param str2 = NULL,
						ConstStr255Param str3 = NULL);

protected:

	virtual void	FinishCreateSelf(void);
};














