/*____________________________________________________________________________
	CManualTranslator.h
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CManualTranslator.h,v 1.6.8.1 1998/11/12 03:06:33 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CTranslator.h"

class CManualTranslator : public CTranslator
{
public:
	
protected:
	
public:
			CManualTranslator( PGPContextRef context,
				PGPtlsContextRef tlsContext, emsProgress progressHook)
				: CTranslator( context, tlsContext, progressHook)
				{
				}
};



class CManualDecryptVerifyTranslator : public CManualTranslator
{
protected:

	virtual PGPError	PGPDecodeEventHandler(PGPContextRef context,
							PGPEvent *event,
							DecryptVerifyEventHandlerData *data );
							
public:
			CManualDecryptVerifyTranslator( PGPContextRef context,
				PGPtlsContextRef tlsContext, emsProgress progressHook)
				: CManualTranslator( context, tlsContext, progressHook)
				{
				}
				
	virtual PluginError	TranslateFile( long transContext, 
							ConstemsMIMETypeHandle InMIMEtypeHandle,
							const FSSpec * inFSp,
							StringHandle** addressesHandle,
							emsMIMEtype ***	OutMIMEtypeHandlePtr,
							const FSSpec * outFSp,
							StringHandle* returnedMessage,
							StringHandle* errorMessage, long * resultCode);
};



class CManualAddKeyTranslator : public CManualTranslator
{
public:
			CManualAddKeyTranslator( PGPContextRef context,
				PGPtlsContextRef tlsContext, emsProgress progressHook)
				: CManualTranslator( context, tlsContext, progressHook)
				{
				}
				
	virtual PluginError	TranslateFile( long transContext, 
							ConstemsMIMETypeHandle InMIMEtypeHandle,
							const FSSpec * inFSp,
							StringHandle** addressesHandle,
							emsMIMEtype ***	OutMIMEtypeHandlePtr,
							const FSSpec * outFSp,
							StringHandle* returnedMessage,
							StringHandle* errorMessage, long * resultCode);
};


class CManualEncryptSignTranslator : public CManualTranslator
{
protected:
	Boolean			mDoSign;
	
public:
		CManualEncryptSignTranslator( PGPContextRef context,
			PGPtlsContextRef tlsContext, emsProgress progressHook,
			Boolean sign );
					
	virtual PluginError	TranslateFile( long transContext, 
							ConstemsMIMETypeHandle InMIMEtypeHandle,
							const FSSpec * inFSp,
							StringHandle** addressesHandle,
							emsMIMEtype ***	OutMIMEtypeHandlePtr,
							const FSSpec * outFSp,
							StringHandle* returnedMessage,
							StringHandle* errorMessage, long * resultCode);
};


class CManualSignTranslator : public CManualTranslator
{
public:
			CManualSignTranslator( PGPContextRef context,
				PGPtlsContextRef tlsContext, emsProgress progressHook)
				: CManualTranslator( context, tlsContext, progressHook)
				{
				}
				
	virtual PluginError	TranslateFile( long transContext, 
							ConstemsMIMETypeHandle InMIMEtypeHandle,
							const FSSpec * inFSp,
							StringHandle** addressesHandle,
							emsMIMEtype ***	OutMIMEtypeHandlePtr,
							const FSSpec * outFSp,
							StringHandle* returnedMessage,
							StringHandle* errorMessage, long * resultCode);
};


