/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPActiveScroller.cp,v 1.5.16.1 1998/11/12 03:19:11 heller Exp $
____________________________________________________________________________*/

#include <UGraphicUtils.h>

#include "MacEnvirons.h"
#include "pgpMem.h"

#include "CPGPActiveScroller.h"

CPGPActiveScroller::CPGPActiveScroller(LStream *inStream)
		: LActiveScroller(inStream)
{
}

CPGPActiveScroller::~CPGPActiveScroller(void)
{
}

	void
CPGPActiveScroller::AdjustScrollBarsVisibility(void)
{
	if( HaveAppearanceMgr() )
	{
		OSErr	err;

		if( IsntNull( mHorizontalBar ) )
		{
			err = SetControlVisibility( mHorizontalBar->GetMacControl(),
							mHorizontalBar->IsVisible(), FALSE );
			pgpAssertNoErr( err );
		}

		if( IsntNull( mVerticalBar ) )
		{
			err = SetControlVisibility( mVerticalBar->GetMacControl(),
							mVerticalBar->IsVisible(), FALSE );
			pgpAssertNoErr( err );
		}
	}
}

	void
CPGPActiveScroller::Show(void)
{
	LActiveScroller::Show();

	AdjustScrollBarsVisibility();
}

	void
CPGPActiveScroller::SuperShow(void)
{
	LActiveScroller::SuperShow();

	AdjustScrollBarsVisibility();
}

	void
CPGPActiveScroller::Hide(void)
{
	LActiveScroller::Hide();

	AdjustScrollBarsVisibility();
}

	void
CPGPActiveScroller::SuperHide(void)
{
	LActiveScroller::SuperHide();

	AdjustScrollBarsVisibility();
}


	void
CPGPActiveScroller::ActivateSelf(void)
{
	LScroller::ActivateSelf();
	
	AdjustScrollBarsVisibility();
}

	void
CPGPActiveScroller::DeactivateSelf(void)
{
	if( IsntNull( mHorizontalBar ) &&
		mHorizontalBar->IsVisible() )
	{
		mHorizontalBar->Hide();			// Hide horizontal ScrollBar
		mHorizontalBar->DontRefresh( true );
	}

	if( IsntNull( mVerticalBar ) &&
		mVerticalBar->IsVisible() )
	{
		mVerticalBar->Hide();			// Hide horizontal ScrollBar
		mVerticalBar->DontRefresh( true );
	}

	AdjustScrollBarsVisibility();

	LScroller::DeactivateSelf();
}

