/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: CPGPtoolsTextTask.h,v 1.13.8.1 1998/11/12 03:09:19 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPtoolsBufferTask.h"

class CPGPtoolsTextTask : public CPGPtoolsBufferTask
{
public:
						CPGPtoolsTextTask(PGPtoolsOperation operation);
	virtual				~CPGPtoolsTextTask(void);
	virtual CToolsError	DecryptVerify(PGPContextRef	context,
								PGPtlsContextRef tlsContext,
								CDecodeParams *state);
	virtual	CToolsError	EncryptSign(PGPContextRef context,
								PGPtlsContextRef tlsContext,
								CEncodeParams *state);
	virtual	void		SetSourceFileName(ConstStringPtr name);

protected:

	virtual	void		GetDecryptPassphrasePromptString(StringPtr prompt);
	virtual	void		GetTaskItemName(StringPtr name);
	virtual	CToolsError	ProcessOutputData(void);
	
private:

	Str32				mSourceFileName;
	
	virtual	void		BuildErrorMessage(CToolsError err,
							short errorStrIndex, StringPtr msg);
};