/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CSignDialog.h,v 1.11.8.1 1998/11/12 03:08:18 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LGADialog.h>
#include <LBroadcaster.h>
#include <LCommander.h>
#include <LEditText.h>
#include <LActiveScroller.h>

#include "CKeyTable.h"

const MessageT	kSignSuccessful		=	'SSuc';
const ResIDT	kSignDialogResID	=	152;


class LCheckBox;
class LPushButton;
class LTextGroupBox;
class LRadioButton;
class CGADurationEditField;


class CSignDialog		:					public LGADialog,
											public LBroadcaster,
											public LCommander
{
public:
	enum { class_ID = 'SigD' };
					CSignDialog();
					CSignDialog(LStream *inStream);
					~CSignDialog();
	void			ListenToMessage(MessageT inMessage, void *ioParam);
	virtual void	FindCommandStatus(CommandT inCommand,
							Boolean &outEnabled, Boolean &outUsesMark,
							Char16 &outMark, Str255 outName);
	void			FinishCreateSelf();
	void			DrawSelf();
	
	void			SetUserIDs(	PGPKeyRef		signer,
								KeyTableRef		*userIDs,
								Int32			numUserIDs);
private:
	void			Sign();
	PGPError		GetParams(
								PGPUInt32		*trustLevel,
								PGPBoolean		*exportable,
								PGPUInt32		*expireDays );
	void			DomainToRegExp( char		*domain,
									char		*regExp );

	LCheckBox		*mExportCheckbox;
	LPushButton		*mAdvancedButton,
					*mSignButton,
					*mCancelButton;
	LTextGroupBox	*mSignTypesGroup,
					*mExpireTypesGroup;
	LRadioButton	*mSignN0Radio,
					*mSignE0Radio,
					*mSignE1Radio,
					*mSignN2Radio,
					*mNeverExpireRadio,
					*mExpirationRadio;
	LEditText		*mDomainEdit;
	Boolean			mAdvancedMode;
	LActiveScroller	*mScroller;
	PGPKeyRef		mSigner;
	KeyTableRef		*mUserIDs;
	Int32			mNumUserIDs;
	CGADurationEditField	*mExpirationDate;
	Int32			mLastArrowValue;

	enum	{	
				kSignButton				= 'sign',
				kCancelButton			= 'canc',
				kAdvancedButton			= 'adva',
				kExportCheckbox			= 'xExp',
				kSignTypeN0Radio		= 'rNor',
				kSignTypeE0Radio		= 'rEVA',
				kSignTypeE1Radio		= 'rTru',
				kSignTypeN2Radio		= 'rMet',
				kSignTypesGroup			= 'sGrp',
				kExpireTypesGroup		= 'sExp',
				kUserIDScroller			= 'uSCR',
				kUserIDList				= 'lUID',
				kNeverExpireRadio		= 'rNev',
				kExpirationRadio		= 'rExp',
				kExpirationDate			= 'eExp',
				kExpirationArrows		= 'lArD',
				kDomainEdit				= 'eDom'
			};
};

