/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CPGPKeys.cp,v 1.119.2.1.2.2 1998/11/13 02:49:43 heller Exp $
____________________________________________________________________________*/
#include <Balloons.h>
#include <LowMem.h>
#include <Processes.h>

#include <PP_Messages.h>
#include <PP_Resources.h>
#include <UAttachments.h>
#include <URegistrar.h>
#include <UEnvironment.h>
#include <UGraphicUtils.h>
#include <UDrawingState.h>
#include <UMemoryMgr.h>
#include <UDesktop.h>
#include <UAppleEventsMgr.h>
#include <UScreenPort.h>
#include <LComparator.h>
#include <LIconPane.h>
#include <LGAFocusBorder.h>
#include <LMultiPanelView.h>
#include <LRadioGroup.h>
#include <LRadioGroupView.h>
#include <LTabGroup.h>
#include <LMenu.h>

// Appearance classes
#include <LBevelButton.h>
#include <LChasingArrows.h>
#include <LCheckBox.h>
#include <LCmdBevelButton.h>
#include <LEditText.h>
#include <LGADialog.h>
#include <LIconControl.h>
#include <LLittleArrows.h>
#include <LPlacard.h>
#include <LPopupButton.h>
#include <LProgressBar.h>
#include <LPushButton.h>
#include <LRadioButton.h>
#include <LScrollBar.h>
#include <LStdControlImp.h>
#include <LScrollerView.h>
#include <LSeparatorLine.h>
#include <LSlider.h>
#include <LStaticText.h>
#include <LTabsControl.h>
#include <LTextGroupBox.h>
#include <LWindowHeader.h>

// Appearance Manager Implementations
#include <LAMBevelButtonImp.h>
#include <LAMControlImp.h>
#include <LAMPlacardImp.h>
#include <LAMPopupButtonImp.h>
#include <LAMPushButtonImp.h>
#include <LAMStaticTextImp.h>
#include <LAMTabsControlImp.h>
#include <LAMTrackActionImp.h>

// Grayscale Implementations
#include <LGALittleArrowsImp.h>

#include "CPGPKeys.h"
#include "BETA.h"
#include "PGPDemo.h"
#include "CWarningAlert.h"
#include "MacDebugPatches.h"
#include "PGPKeysMenuBar.h"
#include "CKeyWindow.h"
#include "CSearchWindow.h"
#include "CSearchPanel.h"
#include "CGroupsWindow.h"
#include "CGADurationEditField.h"
#include "CKeyView.h"

#include "CSplitWindow.h"
#include "CSendKeyShares.h"
#include "CFingerprintField.h"
#include "CKeyTableLabels.h"
#include "CRecessedCaption.h"
#include "ABalloon.h"
#include "CKeyTable.h"
#include "CPicture.h"
#include "CPassphraseEdit.h"
#include "CPhotoUserID.h"
#include "CSignDialog.h"
#include "CVersionCaption.h"
#include "CPGPStDialogHandler.h"
#include "CPGPAMTabsControlImp.h"
#include "CKeyGenWizardDialog.h"
#include "CProgressBar.h"
#include "CPGPAMEditTextImp.h"
#include "CPGPActiveScroller.h"
#include "CGAProgressDialog.h"
#include "BackupHandler.h"
#include "pgpRandomPool.h"
#include "MacErrors.h"
#include "MacInternet.h"
#include "MacDialogs.h"
#include "MacStrings.h"
#include "MacFiles.h"
#include "PGPOpenPrefs.h"
#include "pgpMacCustomContextAlloc.h"

// PGPsdk includes
#include "pgpUtilities.h"
#include "pgpErrors.h"
#include "pgpRandomPool.h"
#include "pgpMem.h"
#include "pgpSDKPrefs.h"
#include "pgpClientPrefs.h"
#include "pgpAdminPrefs.h"
#include "pgpRandomPool.h"
#include "pgpKeyServer.h"
#include "pgpClientLib.h"

#include <string.h>

ResIDT				gApplicationResFile;
PGPContextRef		gPGPContext;
PGPMemoryMgrRef		gPGPMemoryMgr;
PGPtlsContextRef	gTLSContext;
PGPPrefRef			gPrefRef;
PGPPrefRef			gAdminPrefRef;
Boolean				gServerCallsPresent;
PGPBoolean			gIsAdminConfigured;
FSSpec				gAppFSSpec;

const ResIDT		kKeyWindow							= 129;
const ResIDT		kWindowAbout						= 131;
const ResIDT		kNoKeyFilesDialog					= 147;
const ResIDT		kReadOnlyErrorDialog				= 157;
const ResIDT		kAboutMainPictureResID				= 129;
const ResIDT		kAboutCreditsPictureResID			= 130;
const short			kSplashDisplayTime					= 30;
const ulong			kSecondsInADay						= 86400;
const ResIDT		kOpenCustomGetDialog				= 1001;
const long			ae_ImportKey						= 4000;


enum	{
			kStringListID			= 1017,
			kNoAdminPrefsStringID	= 1,
			kErrorPrefaceStringID,
			kAboutInfoButtonTitleStrIndex,
			kAboutCreditsButtonTitleStrIndex,
			kPGPWebSiteURLStrIndex,
			kCantLaunchWebBrowserBecauseStrIndex,
			kUnrecoverableKeyringErrorStrIndex,
			kUnrecoverablePrefsErrorStrIndex,
			kPGPRegisterURLStrIndex,
			kPGPRegisterOnlineItemStrIndex,
			kNoGroupsSupportStrIndex,
			kPGPUpgradeItemStrIndex,
			kPGPBuyNowURLStrIndex,
			kURLRegExtensionStrIndex,
			kUpdateIntroducersStrIndex,
			kUpdateAllStrIndex
		};

static void RealMain(void)
{
	// GrowZone stuff disabled, not working,
	// possible PowerPlant bug?
	//LGrowZone* growZone = new LGrowZone(20000);

	// set these globals before we do anything else
	gApplicationResFile = ::CurResFile();

	CPGPKeys*	theApp = new CPGPKeys;
	theApp->Run();
	delete theApp;
	
	//delete growZone;
}

void main(void)
{
	ProcessInfoRec		processInfo;
	ProcessSerialNumber	currentProcess;
	
#if PGP_DEBUG
	SetDebugThrow_( debugAction_LowLevelDebugger );
	SetDebugSignal_( debugAction_LowLevelDebugger );
#else
	SetDebugThrow_( debugAction_Nothing );
	SetDebugSignal_( debugAction_Nothing );
#endif

	InitializeHeap(3);
	UQDGlobals::InitializeToolbox(&qd);
	DebugPatches_PatchDisposeTraps();
	
	GetCurrentProcess(&currentProcess);
	processInfo.processAppSpec = &gAppFSSpec;
	processInfo.processInfoLength = sizeof(ProcessInfoRec);
	processInfo.processName = NULL;
	GetProcessInformation(&currentProcess, &processInfo);
	
	// make sure we do not leak the Comparator classes
	LComparator::GetComparator();
	LLongComparator::GetComparator();

	pgpLeaksBeginSession("main");
	//pgpLeaksSuspend();
		RealMain();
	
	pgpLeaksEndSession();
}

CPGPKeys	*CPGPKeys::sTheApp = 0;

CPGPKeys::CPGPKeys(void):
	mMenuBar(0),
	mModelDirector(0),
	mCreatedKey(false),
	mPreviousStorage(NULL)
{
	sTheApp			= this;
	mKeyWindow		= NULL;
	mSearchWindow	= NULL;
	mGroupsWindow	= NULL;
	
	UEnvironment::InitEnvironment();
	UGraphicUtils::InitGraphicsUtilities();

#if BETA
	if( BetaExpired() )
	{
		Alert(205, NULL);	// Beta expiration
		ExitToShell();
	}
#endif
	if( !HaveAppearanceMgr() )
	{
		Alert(206, NULL);
		ExitToShell();
	}

	RegisterClass_( LActiveScroller );
	RegisterClass_( LBorderAttachment );
	RegisterClass_( LCaption );
	RegisterClass_( LGADialog );
	RegisterClass_( LGAFocusBorder );
	RegisterClass_( LMultiPanelView );
	RegisterClass_( LPaintAttachment );
	RegisterClass_( LScrollerView );
	RegisterClass_( LTabGroup );
	RegisterClass_( LTableView );
	RegisterClass_( LRadioGroup );
	RegisterClass_( LRadioGroupView );
	RegisterClass_( LView );
	
	// Appearance classes:
	
	RegisterClass_( LBevelButton );
	RegisterClass_( LChasingArrows );
	RegisterClass_( LCheckBox );
	RegisterClass_( LCmdBevelButton );
	RegisterClass_( LEditText );
	RegisterClass_( LIconControl );
	RegisterClass_( LLittleArrows );
	RegisterClass_( LPlacard );
	RegisterClass_( LPopupButton );
	RegisterClass_( LProgressBar );
	RegisterClass_( LPushButton );
	RegisterClass_( LRadioButton );
	RegisterClass_( LScrollBar );
	RegisterClass_( LSeparatorLine );
	RegisterClass_( LSlider );
	RegisterClass_( LStaticText );
	RegisterClass_( LTabsControl );
	RegisterClass_( LTextGroupBox );
	RegisterClass_( LWindowHeader );
	
	(void) RegisterAppearanceClient();

	RegisterClassID_( LAMBevelButtonImp, 	LBevelButton::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LChasingArrows::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LCheckBox::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LRadioButton::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LIconControl::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LProgressBar::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LTextGroupBox::imp_class_ID );		
	RegisterClassID_( LAMControlImp,		LScrollBar::imp_class_ID );
	RegisterClassID_( LAMControlImp,		LSeparatorLine::imp_class_ID );
	RegisterClassID_( CPGPAMEditTextImp,	LEditText::imp_class_ID );
	RegisterClassID_( LAMPlacardImp, 		LPlacard::imp_class_ID );
	RegisterClassID_( LAMPopupButtonImp, 	LPopupButton::imp_class_ID );
	RegisterClassID_( LAMPushButtonImp,		LPushButton::imp_class_ID );
	RegisterClassID_( LAMStaticTextImp,		LStaticText::imp_class_ID );
	RegisterClassID_( LAMTrackActionImp, 	LSlider::imp_class_ID);
	RegisterClassID_( CPGPAMTabsControlImp,	LTabsControl::imp_class_ID );
	RegisterClassID_( LAMControlImp, 		LWindowHeader::imp_class_ID );
	RegisterClassID_( LGALittleArrowsImp,	LLittleArrows::imp_class_ID );
	
	RegisterClass_(CKeyWindow);
	RegisterClass_(CKeyView);
	RegisterClass_(CSearchWindow);
	RegisterClass_(CSearchPanel);
	RegisterClass_(CGroupsWindow);
	RegisterClass_(CGroupsTable);
	RegisterClass_(CKeyTableLabels);
	RegisterClass_(CKeyTable);
	RegisterClass_(CSplitWindow);
	RegisterClass_(CVersionCaption);
	RegisterClass_(CPicture);
	RegisterClass_(CGADurationEditField);

	RegisterClass_(CPassphraseEdit);
	RegisterClass_(LIconPane);
	RegisterClass_(CRecessedCaption);
	RegisterClass_( CPhotoUserID );

	RegisterClass_(CKeyGenWizardDialog);
	
	RegisterClass_(CFingerprintField);
	RegisterClass_(CSignDialog);
	
	RegisterClass_(CGAProgressDialog);
	RegisterClass_(CPGPActiveScroller);
	RegisterClass_(CProgressBar);
	RegisterClass_(CWarningAlert);
	
	RegisterClass_(ABalloon);
	
	mSplashScreen	= NULL;
	mCheckedLicense = FALSE;
	mLastMouseLoc.h	= mLastMouseLoc.v = -1;
	mSearching		= FALSE;
	mAppStarted		= FALSE;
}

	void
CPGPKeys::CleanUpPPLeaks()
{
	OSErr	theErr;
	
	pgpAssertAddrValid(&UAppleEventsMgr::sAnyType, AEDesc);
	theErr = ::AEDisposeDesc(&UAppleEventsMgr::sAnyType);
	pgpAssert(theErr == noErr);
	
	URegistrar::DisposeClassTable();
	UScreenPort::Dispose();
}

CPGPKeys::~CPGPKeys(void)
{
	StopIdling();
	if(IsntNull(mGroupsWindow))
		delete mGroupsWindow;
	mGroupsWindow = NULL;
	if(IsntNull(mSearchWindow))
		delete mSearchWindow;
	mSearchWindow = NULL;
	if(IsntNull(mKeyWindow))
		delete mKeyWindow;
	mKeyWindow = NULL;
	
	if(	gServerCallsPresent )
	{
		PGPKeyServerDisposeThreadStorage(mPreviousStorage);
		PGPKeyServerCleanup();
		if( PGPtlsContextRefIsValid( gTLSContext ) )
			PGPFreeTLSContext( gTLSContext );
	}
#if	PGP_BUSINESS_SECURITY
	PGPClosePrefFile(gAdminPrefRef);
#endif
	PGPSavePrefFile(gPrefRef);
	PGPClosePrefFile(gPrefRef);
	PGPFreeMemoryMgr(gPGPMemoryMgr);
	PGPFreeContext(gPGPContext);
	
	pgpAssertAddrValid(mMenuBar, VoidAlign);
	if(IsntNull(mMenuBar))
		delete mMenuBar;
		
	pgpAssertAddrValid(mModelDirector, LModelDirector);
	if(IsntNull(mModelDirector))
		delete mModelDirector;
					
	CleanUpPPLeaks();
}

	void
CPGPKeys::ResetKeyDB()
{
	PGPError	err;
	short		keyFilesErr;
	
	if(IsntNull(mGroupsWindow))
		delete mGroupsWindow;
	mDefaultKeysView->CloseKeys();
	// Out with the old
	
	// In with the new
	err = 0;
	err = PGPOpenDefaultKeyRings(gPGPContext,
			kPGPKeyRingOpenFlags_Mutable, &mKeySet);
	if(!PGPKeySetRefIsValid(mKeySet) && (err != kPGPError_FileLocked))
	{
		if(err == kPGPError_FilePermissions)
		{
			mWritableKeyring = FALSE;
			err = PGPOpenDefaultKeyRings(gPGPContext,
					(PGPKeyRingOpenFlags)0, &mKeySet);
		}
		if(!PGPKeySetRefIsValid(mKeySet) && ((err == kPGPError_CantOpenFile) ||
								(err == kPGPError_FileNotFound)))
		{
		tryOpenKeysAgain:
			if((keyFilesErr = AskMakeNewKeyFiles()) != 0)
			{
				if(keyFilesErr == 1)
					ResetDefaultKeyringsPath();
				mWritableKeyring = TRUE;
				err = PGPOpenDefaultKeyRings(gPGPContext,
						(PGPKeyRingOpenFlags)
						(kPGPKeyRingOpenFlags_Mutable |
						kPGPKeyRingOpenFlags_Create), &mKeySet);
			}
			else
			{
				PGPFreeContext(gPGPContext);
				::ExitToShell();
			}
		}
	}
	if(!PGPKeySetRefIsValid(mKeySet) && IsErr(err))
	{
		// Fatal keyring error
		::SysBeep(1);
		CWarningAlert::Display(kWAStopAlertType, kWAOKStyle,
			kStringListID, kUnrecoverableKeyringErrorStrIndex);
		goto tryOpenKeysAgain;
	}
	// Reset the list
	mDefaultKeysView->SetKeyDBInfo(	mKeySet, mWritableKeyring, true);
}

	short
CPGPKeys::AskMakeNewKeyFiles()
{
	CPGPStDialogHandler	askKeyFilesDialog(kNoKeyFilesDialog, this);
	const CommandT		kQuitButton				= 'quit';
	const CommandT		kNewKeyFilesButton		= 'nuke';
	const CommandT		kSelectKeyFilesButton	= 'sele';
	MessageT			dialogMessage;
	PGPError			err = kPGPError_NoErr;
	
	do
	{
		dialogMessage = askKeyFilesDialog.DoDialog();
	} while(!dialogMessage);
	if(dialogMessage == kNewKeyFilesButton)
		return 1;
	else if(dialogMessage == kSelectKeyFilesButton)
	{
		FSSpec	publicSpec,
				privateSpec;
		
		err = PGPSelectPGPFile( gPGPContext, kPGPFileSelector_PublicKeys,
						&publicSpec );
		if( IsPGPError( err ) )
			return 0;
		
		err = PGPSelectPGPFile( gPGPContext, kPGPFileSelector_PrivateKeys,
						&privateSpec );
		if( IsPGPError( err ) )
			return 0;
			
		err = PGPSetPGPFileFSSpec( gPGPContext, kPGPFileSelector_PublicKeys,
					&publicSpec );
		pgpAssertNoErr( err );

		err = PGPSetPGPFileFSSpec( gPGPContext, kPGPFileSelector_PrivateKeys,
					&privateSpec );
		pgpAssertNoErr( err );

		return 2;
	}
	else
		return 0;
}

	PGPError
CPGPKeys::GetMinimumRandomData()
{
	PGPError	err = kPGPError_NoErr;
	
	if( ! PGPGlobalRandomPoolHasMinimumEntropy() )
	{
		PGPUInt32	haveBits;
		PGPUInt32	neededBits;
		
		haveBits 	= PGPGlobalRandomPoolGetEntropy();
		neededBits 	= PGPGlobalRandomPoolGetMinimumEntropy();
		
		pgpAssert( haveBits < neededBits );
		
		if( haveBits < neededBits )
		{
			neededBits = neededBits - haveBits + 100;
		}
		else
		{
			neededBits = 300;	/* Token amount */
		}
		
		UDesktop::Deactivate();
		err = PGPCollectRandomDataDialog( gPGPContext, neededBits,
						PGPOLastOption( gPGPContext ) );
		UDesktop::Activate();
	}
	
	return( err );
}


#if PGP_DEBUG
#include "PowerPlantLeaks.h"
	static void
InitPowerplantLeaks()
{
	CForceInitLPeriodical	initLPeriodical;
}

#else
#define InitPowerplantLeaks()	{/*nothing*/}
#endif

	void
CPGPKeys::StartUp(void)
{
	PGPError		err;
	Int16			keyFilesErr;
	
	if( mAppStarted )
		return;		/* Already did this */
		
	pgpLeaksSuspend();
	new UMainThread;
	
	InitPowerplantLeaks();
	
#if PGP_DEMO
	if( ShowDemoDialog( TRUE ) == kDemoStateExpired )
	{
		::ExitToShell();
	}
#endif

	mHelpMenuRegisterItemNumber = -1;
	/*{
		OSErr		osErr;
		MenuHandle	helpMenuHandle;
		
		//Install Register... command on Help menu
		
		osErr = HMGetHelpMenuHandle(&helpMenuHandle);
		if(IsntErr(osErr))
		{
			Str255	itemStr;
			
#if PGP_FREEWARE
			GetIndString(itemStr, kStringListID,
				kPGPUpgradeItemStrIndex);
#else
			GetIndString(itemStr, kStringListID,
				kPGPRegisterOnlineItemStrIndex);
#endif
			AppendMenu(helpMenuHandle, itemStr);
			mHelpMenuRegisterItemNumber = CountMItems(helpMenuHandle);
		}
	}*/
	
	err = pgpNewContextCustomMacAllocators( &gPGPContext );
	//err = PGPNewContext(kPGPsdkAPIVersion, &gPGPContext);
	pgpAssertNoErr(err);

	err = PGPsdkLoadDefaultPrefs(gPGPContext);
	pgpAssertNoErr(err);
	
	err = PGPNewMemoryMgr( 0, &gPGPMemoryMgr);
	pgpAssertNoErr(err);
	err = PGPOpenClientPrefs(gPGPMemoryMgr, &gPrefRef);
	if(IsPGPError(err))
	{
		::SysBeep(1);
		CWarningAlert::Display(kWAStopAlertType, kWAOKStyle,
			kStringListID, kUnrecoverablePrefsErrorStrIndex);
		pgpAssertNoErr(err);
		::ExitToShell();
	}
	
	gIsAdminConfigured = FALSE;
	gAdminPrefRef = kInvalidPGPPrefRef;
#if	PGP_BUSINESS_SECURITY
	err = PGPIsAdminConfigured( &gIsAdminConfigured );
	pgpAssertNoErr( err );
	
	err = PGPOpenAdminPrefs(gPGPMemoryMgr, &gAdminPrefRef );
	if(IsPGPError(err))
	{
		CWarningAlert::Display(kWAStopAlertType, kWAOKStyle,
						kStringListID, kNoAdminPrefsStringID);
		pgpAssertNoErr(err);
		::ExitToShell();
	}
#endif

	gTLSContext			= kInvalidPGPtlsContextRef;
	gServerCallsPresent = FALSE;
	if( CFM_AddressIsResolved_( ::PGPKeyServerInit ) )
	{
		if( IsntPGPError( PGPKeyServerInit() ) &&
			IsntPGPError( PGPNewTLSContext( gPGPContext, &gTLSContext ) ) )
		{
			PGPKeyServerCreateThreadStorage(&mPreviousStorage);
			gServerCallsPresent = TRUE;
		}
	}
	
	// Personalize if necessary
	
	if(!mCheckedLicense)
	{
		Str255		str;
		char		nameStr[128];
		char		cstr[128];

		mCheckedLicense = TRUE;
		err = PGPGetPrefStringBuffer(gPrefRef, kPGPPrefOwnerName,
								sizeof( nameStr ) - 1, nameStr);
		pgpAssertNoErr( err );
		
		if(nameStr[0] == '\0')
		{
			const short			kWindowRegister		= 139;
			const PaneIDT		kOwnerNameID		= 'eNam';
			const PaneIDT		kOwnerCompanyID		= 'eCom';
			const PaneIDT		kCaptionCompanyID	= 'cCom';

			CPGPStDialogHandler	regDialog(kWindowRegister, this);
			LWindow				*regLDialog;
			MessageT			message;
			
			regLDialog = regDialog.GetDialog();
			
#if PGP_BUSINESS_SECURITY
			if( gIsAdminConfigured )
			{
				((LStaticText *)regLDialog->FindPaneByID(kCaptionCompanyID))->
					Hide();
				((LEditText *)regLDialog->FindPaneByID(kOwnerCompanyID))->
					Hide();
			}
#endif
			
			do
			{
				message = regDialog.DoDialog();
			} while((message != msg_OK) && (message != msg_Cancel));
			if(message == msg_OK)
			{
				((LEditText *)regLDialog->FindPaneByID(kOwnerNameID))->
					GetDescriptor(str);
				PToCString(str, cstr);
				err = PGPSetPrefString(gPrefRef, kPGPPrefOwnerName, cstr);
				pgpAssertNoErr(err);
				((LEditText *)regLDialog->FindPaneByID(kOwnerCompanyID))->
					GetDescriptor(str);
				PToCString(str, cstr);
				err = PGPSetPrefString(gPrefRef, kPGPPrefCompanyName, cstr);
				pgpAssertNoErr(err);
				PGPSavePrefFile(gPrefRef);
				pgpAssertNoErr(err);
			}
		}
	}

	ShowSplashScreen();
	mWritableKeyring = TRUE;
	err = PGPOpenDefaultKeyRings(gPGPContext,
				kPGPKeyRingOpenFlags_Mutable, &mKeySet);
	if(!PGPKeySetRefIsValid(mKeySet) && (err != kPGPError_FileLocked))
	{
		if(err == kPGPError_FilePermissions)
		{
			mWritableKeyring = FALSE;
			err = PGPOpenDefaultKeyRings(gPGPContext,
					(PGPKeyRingOpenFlags)0, &mKeySet);
		}
		if(!PGPKeySetRefIsValid(mKeySet) &&
			( err == kPGPError_CantOpenFile ||
				err == kPGPError_FileNotFound ))
		{
		tryOpenKeysAgain:
			if((keyFilesErr = AskMakeNewKeyFiles()) != 0)
			{
				if(keyFilesErr == 1)
					ResetDefaultKeyringsPath();
				mWritableKeyring = TRUE;
				err = PGPOpenDefaultKeyRings(gPGPContext,
						(PGPKeyRingOpenFlags)
						(kPGPKeyRingOpenFlags_Mutable |
						kPGPKeyRingOpenFlags_Create), &mKeySet);
			}
			else
			{
				// User has requested Quit
				PGPFreeContext(gPGPContext);
				::ExitToShell();
			}
		}
	}
	if(!PGPKeySetRefIsValid(mKeySet) && IsPGPError(err))
	{
		// Fatal no keyrings error
		::SysBeep(1);
		CWarningAlert::Display(kWAStopAlertType, kWAOKStyle,
			kStringListID, kUnrecoverableKeyringErrorStrIndex);
		goto tryOpenKeysAgain;
	}

	mKeyWindow = (CKeyWindow *)
		LWindow::CreateWindow(kKeyWindow, this);
	mDefaultKeysView = mKeyWindow->GetKeyView();
	mDefaultKeysView->SetKeyDBInfo(mKeySet, mWritableKeyring, true);
	
	AddListener( mDefaultKeysView->GetKeyTable() );
	
	StartIdling();
	
	pgpLeaksResume();
	
	mAppStarted = TRUE;
#if	PGP_BUSINESS_SECURITY
	{
		PGPBoolean	updateIntroducers,
					updateAll;
		Uint32		timeNow;
		PGPError	err;
		
		GetDateTime( &timeNow );
		err = PGPCheckAutoUpdateKeysFromServer( gPGPMemoryMgr, FALSE,
					&updateAll, &updateIntroducers );
		if( updateIntroducers )
		{
			if( CWarningAlert::Display(kWANoteAlertType, kWAOKCancelStyle,
				kStringListID, kUpdateIntroducersStrIndex)
				== msg_OK )
			{
				GetTarget()->ProcessCommand( cmd_UpdateIntroducers, NULL );
			}
			err = PGPSetPrefNumber( gAdminPrefRef,
						kPGPPrefLastTrustedIntroducersUpdate, timeNow );
		}
		if( updateAll )
		{
			if( CWarningAlert::Display(kWANoteAlertType, kWAOKCancelStyle,
				kStringListID, kUpdateAllStrIndex)
				== msg_OK )
			{
				GetTarget()->ProcessCommand( cmd_SelectAll, NULL );
				GetTarget()->ProcessCommand( cmd_KSGetKeys, NULL );
			}
			err = PGPSetPrefNumber( gAdminPrefRef,
						kPGPPrefLastAllKeysUpdate, timeNow );
		}
		if( updateIntroducers || updateAll )
			PGPSavePrefFile( gAdminPrefRef );
	}
#endif
}

	void
CPGPKeys::ListenToMessage(	MessageT inMessage,
								void */*ioParam*/)
{
	switch(inMessage)
	{
		case kSearchWindowClosed:
			mSearchWindow = NULL;
			break;
		case kSearchInProgress:
			mSearching = TRUE;
			SetUpdateCommandStatus(true);
			break;
		case kSearchComplete:
			mSearching = FALSE;
			SetUpdateCommandStatus(true);
			break;
		case kGroupsWindowClosed:
			mGroupsWindow = NULL;
			break;
	}
}

	void
CPGPKeys::FindCommandStatus(
	CommandT	inCommand,
	Boolean		&outEnabled,
	Boolean		&outUsesMark,
	Char16		&outMark,
	Str255		outName)
{
	switch (inCommand) 
	{
		case cmd_UpdateGroupLists:
		case cmd_SendGroupLists:
#if PGP_BUSINESS_SECURITY
			PGPBoolean	configured = FALSE;
			
			PGPIsAdminConfigured( &configured );
			if( !configured && gServerCallsPresent )
				outEnabled = true;
#endif
			break;
		case cmd_SendShareFile:
		case cmd_ShowGroups:
		case cmd_Preferences:	
			outEnabled = true;
			break;
		case cmd_Search:
			if(gServerCallsPresent)
				outEnabled = true;
			break;
		case cmd_Quit:
			if(mSearching)
			{
				outEnabled = false;
				break;
			}
		default:
			LDocApplication::FindCommandStatus(inCommand, outEnabled,
												outUsesMark, outMark, outName);
			break;
	}
}

	Boolean
CPGPKeys::ObeyCommand(
	CommandT	inCommand,
	void		*ioParam)
{
	Boolean		cmdHandled = true;
	ResIDT		theMenuID;
	Int16		theMenuItem;

	/* Handle case of earlier than expected commands */
	if( ! mAppStarted )
		StartUp();
		
	if(IsSyntheticCommand(inCommand, theMenuID, theMenuItem))
	{
		switch(theMenuID)
		{
			case kSubstituteHelpMenuID:
			{
				/*if(theMenuItem == mHelpMenuRegisterItemNumber)
				{
					Str255		url,
								licenseStr,
								licenseNumStr;
					char		licenseCStr[128];
					OSStatus	status;
					PGPError	err;

#if PGP_FREEWARE
					GetIndString( url, kStringListID,
									kPGPBuyNowURLStrIndex );
#else
					GetIndString( url, kStringListID,
									kPGPRegisterURLStrIndex );
#endif
					licenseCStr[0] = '\0';
#if	PGP_BUSINESS_SECURITY
					err = PGPGetPrefStringBuffer(
							gAdminPrefRef, kPGPPrefSiteLicenseNumber, 128,
							licenseCStr);
#endif
					if(licenseCStr[0] == '\0')
					{
						err = PGPGetPrefStringBuffer(
							gPrefRef, kPGPPrefLicenseNumber, 128,
							licenseCStr);
					}
					if(licenseCStr[0] != '\0')
					{
						CToPString(licenseCStr, licenseNumStr);
						GetIndString( licenseStr, kStringListID,
									kURLRegExtensionStrIndex );
						AppendPString(licenseNumStr, licenseStr);
						AppendPString(licenseStr, url);
					}
					status = OpenURL( url );
					if( IsErr( status ) )
					{
						Str255	errorStr;

						SysBeep( 1 );
						::NumToString(status, errorStr);
						CWarningAlert::Display( kWACautionAlertType,
							kWAOKStyle,
							kStringListID,
							kCantLaunchWebBrowserBecauseStrIndex,
							errorStr );
					}
				}
				break;*/
			}
			default:
				cmdHandled = LDocApplication::ObeyCommand(inCommand, ioParam);
				break;
		}
	}
	else switch (inCommand) 
	{
		case cmd_Preferences:
			{
				PGPPrefDialogFlags	flags;
				
				if( IsntPGPError( PGPPreferencesDialog( gPGPContext,
										CPGPKeys::TheApp()->GetKeySet(),
										gPrefRef,
										gAdminPrefRef,
										&flags ) ) )
				{
					if( ( flags & kPGPPrefDialog_ChangedKeyFiles ) != 0 )
					{
						ResetKeyDB();
					}

					if( ( flags & kPGPPrefDialog_ChangedServerList ) != 0 )
					{
						BroadcastMessage( kRebuildServersMessage );
					}

					BroadcastMessage( kKeyTableRedrawMessage );
				}
			}
			break;
		case cmd_SendShareFile:
			CSendKeyShares::SendKeyShares( NULL );
			break;
		case cmd_Search:
			if( IsNull( mSearchWindow ) )
			{
				mSearchWindow = (CSearchWindow *)
					LWindow::CreateWindow(kSearchWindowID, this);
				AddListener( mSearchWindow );
				mSearchWindow->AddListener( this );
			}
			else
				mSearchWindow->Select();
			break;
		case cmd_ShowGroups:
			if( IsNull( mGroupsWindow ) )
			{
				mGroupsWindow = (CGroupsWindow *)
					LWindow::CreateWindow( kGroupsWindowID,
					CPGPKeys::TheApp() );
				mGroupsWindow->AddListener( this );
			}
			else
				mGroupsWindow->Select();
			break;
		case cmd_UpdateGroupLists:
		case cmd_SendGroupLists:
			ServerGroupUpdate( inCommand );
			break;
		case cmd_Quit:
			if(TryingToQuit())
				SendAEQuit();
			break;
		default:
			cmdHandled = LDocApplication::ObeyCommand(inCommand, ioParam);
			break;
	}
	
	return cmdHandled;
}

	void
CPGPKeys::ServerGroupUpdate(
	CommandT	inCommand	)
{
	PGPError		err = kPGPError_NoErr;
	PGPGroupSetRef	groupSet = kInvalidPGPGroupSetRef;
	PGPFileSpecRef	groupSpec = kInvalidPGPFileSpecRef;
	
	if( IsntNull( mGroupsWindow ) )
	{
		delete mGroupsWindow;
		mGroupsWindow = NULL;
	}
	err = PGPsdkPrefGetFileSpec( gPGPContext, kPGPsdkPref_GroupsFile,
				&groupSpec );
	if( inCommand == cmd_SendGroupLists )
	{
		if( IsntPGPError( err ) )
		{
			err = PGPNewGroupSetFromFile( gPGPContext, groupSpec,
										&groupSet );
		}
	}
	if( IsntPGPError( err ) )
	{
		err = PGPGroupListOperationOnServer( gPGPContext, gTLSContext,
				mKeySet, inCommand == cmd_SendGroupLists, &groupSet );
	}
	if( IsntPGPError( err ) && inCommand == cmd_UpdateGroupLists &&
		PGPGroupSetRefIsValid( groupSet ) )
	{
		err = PGPSaveGroupSetToFile( groupSet, groupSpec );
	}
	
	if( PGPGroupSetRefIsValid( groupSet ) )
		PGPFreeGroupSet( groupSet );
	if( PGPFileSpecRefIsValid( groupSpec ) )
		PGPFreeFileSpec( groupSpec );
	
	if( IsPGPError( err ) )
		ReportPGPError( err );
	if( IsntPGPError( err ) && inCommand == cmd_UpdateGroupLists )
		ProcessCommand( cmd_ShowGroups, NULL );
}

	Boolean
CPGPKeys::TryingToQuit(void)
{
	if(mCreatedKey)
	{
		BackupHandler	handler;
		return handler.Run();
	}
	else
		return true;
}

	void
CPGPKeys::CreatedKey()
{
	mCreatedKey = true;
}

	void
CPGPKeys::MakeLicenseStr(Str255 outLicenseStr)
{
	PGPError	err;
	char		companyStr[128];
	char		nameStr[128];
	char		str[256];
	
	companyStr[0] = '\0';
#if PGP_BUSINESS_SECURITY
	err = PGPGetPrefStringBuffer( gAdminPrefRef, kPGPPrefAdminCompanyName,
								sizeof( companyStr ) - 1, companyStr );
	pgpAssertNoErr( err );
#endif
	if( companyStr[0] == '\0' )
	{
		err = PGPGetPrefStringBuffer( gPrefRef, kPGPPrefCompanyName,
								sizeof( companyStr ) - 1, companyStr );
		pgpAssertNoErr( err );
	}
	
	err = PGPGetPrefStringBuffer( gPrefRef, kPGPPrefOwnerName,
								sizeof( companyStr ) - 1, nameStr );
	pgpAssertNoErr( err );
	
	
	strcpy( str, nameStr );
	strcat( str, "\r" );
	strcat( str, companyStr );
	c2pstr( str );
	CopyPString( (uchar *)str, outLicenseStr );
}

	void
CPGPKeys::ShowAboutBox()
{
	Boolean	didShowDialog = FALSE;
	FSSpec	libraryFileSpec;
	
	// Open the library resource file at the top of the resource chain
	// so we get our pictures.
	if( IsntErr( PGPGetClientLibFSSpec( &libraryFileSpec ) ) )
	{
		short	saveResFile;
		short	libFileRefNum;
		
		saveResFile = CurResFile();
		
		libFileRefNum = FSpOpenResFile( &libraryFileSpec, fsRdPerm );
		if( libFileRefNum > 0 )
		{
			UseResFile( libFileRefNum );
			
			{
				CPGPStDialogHandler	aboutDialog(kWindowAbout, this);
				LWindow			*theDialog;
				MessageT		message;
				Boolean			credits = FALSE;
				Str255			str;
				
				const MessageT		kPGPButtonMessage		= 'bPGP';
				const MessageT		kCreditsButtonMessage	= 'bCre';
				const MessageT		kOKButtonMessage		= 'bOK ';
				
				const PaneIDT		kCreditsButtonPaneID	= 'bCre';
				const PaneIDT		kAboutPicturePaneID		= 'APIC';
				const PaneIDT		kCreditsPicturePaneID	= 'CPIC';
				const PaneIDT		kBSAFEPicturePaneID		= 'RPIC';
				const PaneIDT		kLicenseCaptionID		= 'cLic';
				
				theDialog = aboutDialog.GetDialog();
				didShowDialog = TRUE;

				MakeLicenseStr(str);
				((LStaticText *)theDialog->FindPaneByID(kLicenseCaptionID))->
					SetDescriptor(str);
				
				while((message = aboutDialog.DoDialog()) != kOKButtonMessage )
				{
					if( message == kPGPButtonMessage )
					{
						Str255		url;
						OSStatus	status;
						
						GetIndString( url, kStringListID,
										kPGPWebSiteURLStrIndex );
						
						status = OpenURL( url );
						if( IsErr( status ) )
						{
							Str255	errorStr;

							SysBeep( 1 );
							NumToString(status, errorStr);
							CWarningAlert::Display( kWACautionAlertType,
								kWAOKStyle,
								kStringListID,
								kCantLaunchWebBrowserBecauseStrIndex,
								errorStr );
						}
					}
					else if ( message == kCreditsButtonMessage )
					{
						Str255	buttonTitle;
						
						if( credits )
						{
							theDialog->FindPaneByID( kAboutPicturePaneID )->
								Show();
							theDialog->FindPaneByID( kCreditsPicturePaneID )->
								Hide();
					#if CREDIT_RSA_BSAFE
							theDialog->FindPaneByID( kBSAFEPicturePaneID )->
								Hide();
					#endif
							
							GetIndString( buttonTitle, kStringListID,
								kAboutCreditsButtonTitleStrIndex );
						}
						else
						{
							theDialog->FindPaneByID( kCreditsPicturePaneID )->
								Show();
					#if CREDIT_RSA_BSAFE
							theDialog->FindPaneByID( kBSAFEPicturePaneID )->
								Show();
					#endif
							theDialog->FindPaneByID( kAboutPicturePaneID )->
								Hide();

							GetIndString( buttonTitle, kStringListID,
								kAboutInfoButtonTitleStrIndex );
						}
						
						((LControl *)theDialog->
							FindPaneByID(kCreditsButtonPaneID))->
							SetDescriptor( buttonTitle );

						credits = ! credits;
					}
				}
			}
			
			CloseResFile( libFileRefNum );
			UseResFile( saveResFile );
		}
	}
	
	if( ! didShowDialog )
		SysBeep( 1 );
}

	void
CPGPKeys::ShowSplashScreen()
{
	FSSpec		libraryFileSpec;
	PGPError	err;
	ulong		timeNow;
	PGPUInt32	lastSplashed;
	
	GetDateTime(&timeNow);
	err = PGPGetPrefNumber(gPrefRef, kPGPPrefDateOfLastSplashScreen,
							&lastSplashed);
	pgpAssertNoErr(err);
	if(timeNow - lastSplashed < kSecondsInADay)		// One day
		return;
	
	// Open the libarary resource file at the top of the resource chain
	// so we get our pictures.
	if( IsntErr( PGPGetClientLibFSSpec( &libraryFileSpec ) ) )
	{
		short	saveResFile;
		short	libFileRefNum;
		
		saveResFile = CurResFile();
		
		libFileRefNum = FSpOpenResFile( &libraryFileSpec, fsRdPerm );
		if( libFileRefNum > 0 )
		{
			UseResFile( libFileRefNum );
			
			{
				const ResIDT		kWindowSplash			= 146;
				const MessageT		kLicenseCaptionID		= 'cLic';
				LCaption			*licenseCaption;
				Str255				licenseStr;
				
				mSplashScreen = (LGADialog *)
					LWindow::CreateWindow(kWindowSplash, this);
				licenseCaption = ((LCaption *)
					mSplashScreen->FindPaneByID(kLicenseCaptionID));
				MakeLicenseStr(licenseStr);
				licenseCaption->SetDescriptor(licenseStr);
				mSplashScreen->UpdatePort();
				mSplashDisplayTime = LMGetTicks();
				err = PGPSetPrefNumber(gPrefRef,
						kPGPPrefDateOfLastSplashScreen, timeNow);
				pgpAssert(IsntErr(err));
			}
			
			CloseResFile( libFileRefNum );
			UseResFile( saveResFile );
		}
	}
}

	void
CPGPKeys::EndSplashScreen()
{
	if(mSplashScreen)
	{
		while((mSplashDisplayTime + kSplashDisplayTime > LMGetTicks()) &&
				!Button())
			;
		delete mSplashScreen;
		mSplashScreen = NULL;
		::FlushEvents(mDownMask, 0);
	}
}

	void
CPGPKeys::MakeMenuBar()
{
	mMenuBar = new PGPKeysMenuBar(MBAR_Initial);
}

	void
CPGPKeys::MakeModelDirector()
{
	pgpLeaksSuspend();
	mModelDirector = new LModelDirector(this);
	pgpLeaksResume();
}

	void
CPGPKeys::SpendTime(
	const EventRecord	&/*inMacEvent*/)
{
	GrafPtr		savePort;
	GrafPtr		wMgrPort;
	Point		mouseLoc;

	if( IsntNull( mSplashScreen ) )
	{
		EndSplashScreen();
	}

	::GetPort(&savePort);
	::GetWMgrPort(&wMgrPort);	
	
	::SetPort(wMgrPort);
	::GetMouse(&mouseLoc);
	::SetPort(savePort);
	
	if((mouseLoc.v != mLastMouseLoc.v) ||
		(mouseLoc.h != mLastMouseLoc.h))
	{
		PGPGlobalRandomPoolAddMouse(mouseLoc.h, mouseLoc.v);
		mLastMouseLoc = mouseLoc;
	}
}

	PGPKeyListRef
CPGPKeys::GetKeyList()
{
	return mKeyList;
}

	void
CPGPKeys::SetKeyList(PGPKeyListRef keyList)
{
	mKeyList = keyList;
}

	PGPKeySet *
CPGPKeys::GetKeySet()
{
	return mKeySet;
}

	void
CPGPKeys::CommitDefaultKeyrings()
{
	PGPError	err;
	
	err = PGPCommitKeyRingChanges(mKeySet);
	if(IsPGPError(err))
	{
		if((err == kPGPError_ItemIsReadOnly) &&
			!mWritableKeyring)
		{
			PGPBoolean	warnRO;
			
			err = PGPGetPrefBoolean(gPrefRef,
				kPGPPrefWarnOnReadOnlyKeyRings, &warnRO);
			pgpAssertNoErr(err);
			if(warnRO)
			{
				CPGPStDialogHandler	roErrorDialog(kReadOnlyErrorDialog, this);
				const PaneIDT		kNoWarnCheckbox	= 'xWar';
				MessageT			dialogMessage;
				LWindow				*roErrorLWindow;
				
				do
				{
					dialogMessage = roErrorDialog.DoDialog();
				} while(!dialogMessage);
				roErrorLWindow = roErrorDialog.GetDialog();
				if(((LCheckBox *)roErrorLWindow->
					FindPaneByID(kNoWarnCheckbox))->
					GetValue())
				{
					err = PGPSetPrefBoolean(gPrefRef,
						kPGPPrefWarnOnReadOnlyKeyRings, FALSE);
					pgpAssertNoErr(err);
				}
			}
		}
		else
			ReportPGPError(err);
	}
}

typedef struct SFInfo
{
	StandardFileReply	sfReply;
	Boolean				showAllFiles;
	SFTypeList			typeList;
	short				numTypes;
} SFInfo;

enum
{
	kShowAllFilesCheckboxItem	= 10
};

	static pascal short
CustomGetFileHook(short item, DialogPtr dialog, SFInfo *sfInfo)
{
	pgpAssertAddrValid( dialog, DialogRecord );
	pgpAssertAddrValid( sfInfo, SFInfo );

	if( GetWRefCon( dialog ) == sfMainDialogRefCon )
	{
		switch( item )
		{
			case kShowAllFilesCheckboxItem:
			{			
				sfInfo->showAllFiles = ToggleDialogCheckbox( dialog,
							kShowAllFilesCheckboxItem );
				item = sfHookRebuildList;
				break;
			}
			
		}
	}
	
	return item;
}

	static pascal Boolean
VisibleItemFileFilterProc(CInfoPBPtr cpb)
{
	Boolean	shouldFilter = FALSE;
	
	pgpAssertAddrValid( cpb, CInfoPBRec);

	if( cpbIsFile( cpb ) )
	{
		if( ( cpb->hFileInfo.ioFlFndrInfo.fdFlags & kIsInvisible ) != 0 )
		{
			shouldFilter = TRUE;
		}
	}
	else
	{
		if( ( cpb->dirInfo.ioDrUsrWds.frFlags & kIsInvisible ) != 0 )
		{
			shouldFilter = TRUE;
		}
	}
	
	return( shouldFilter );
}

	static pascal Boolean
CustomGetFileFilter(CInfoPBPtr cpb, const SFInfo *sfInfo)
{
	Boolean	shouldFilter = FALSE;
	
	shouldFilter = VisibleItemFileFilterProc( cpb );
	if( ! shouldFilter )
	{
		if( cpbIsFile( cpb ) && !sfInfo->showAllFiles &&
			( sfInfo->numTypes > 0 ) )
		{
			Boolean	found = FALSE;
			
			for( short typeIndex = 0; typeIndex < sfInfo->numTypes; typeIndex++ )
				if( sfInfo->typeList[typeIndex] == cpbFileType( cpb ) )
					found = TRUE;
			if( !found )
				shouldFilter = TRUE;
		}
	}
		
	return( shouldFilter );
}

	Boolean
CustomGetFileWithShowAll(
	short				numTypes,
	SFTypeList			typeList,
	FSSpec				*fsSpec )
{
	SFInfo				sfInfo;
	DlgHookYDUPP		cbHook;
	FileFilterYDUPP		filterUPP;
	static Point		where={0,0};
	
	cbHook 		=
		NewDlgHookYDProc( CustomGetFileHook );
	filterUPP	=
		NewFileFilterYDProc( CustomGetFileFilter );
	sfInfo.showAllFiles	= FALSE;
	sfInfo.numTypes		= numTypes;
	sfInfo.typeList[0]	= typeList[0];
	sfInfo.typeList[1]	= typeList[1];
	sfInfo.typeList[2]	= typeList[2];
	sfInfo.typeList[3]	= typeList[3];

	UDesktop::Deactivate();
	CustomGetFile(	filterUPP,
					-1, typeList,
					&sfInfo.sfReply,
					kOpenCustomGetDialog,
					where,
					cbHook,
					NULL,
					NULL,
					NULL,
					&sfInfo );
	UDesktop::Activate();

	DisposeRoutineDescriptor( cbHook );
	DisposeRoutineDescriptor( filterUPP );
	
	if( sfInfo.sfReply.sfGood )
	{
		*fsSpec = sfInfo.sfReply.sfFile;
		return TRUE;
	}
	return FALSE;
}

	void
CPGPKeys::InvalidateCaches()
{
	if(IsntNull(mGroupsWindow))
	{
		mGroupsWindow->InvalidateCaches();
	}
}

	void
CPGPKeys::OpenDocument(
	FSSpec	*inMacFSSpec)
{
	FInfo	fInfo;
	
	if( ! mAppStarted )
		StartUp();
	
	if( IsntErr( FSpGetFInfo( inMacFSSpec, &fInfo ) ) )
	{
		switch( fInfo.fdType )
		{
			case kPGPMacFileCreator_SplitKey:
				CSendKeyShares::SendKeyShares( inMacFSSpec );
				break;
		}
	}
}

	void
ReportPGPError(PGPError err)
{
	if( IsPGPError( err )  && ( err != kPGPError_UserAbort ) )
	{
		char	str[256];
		Str255	pStr;
		
		PGPGetClientErrorString(err, sizeof( str ), str);
		CToPString( str, pStr);
		
		CWarningAlert::Display(kWACautionAlertType, kWAOKStyle,
			kStringListID, kErrorPrefaceStringID, pStr);
	}
}

/*	pascal void
PKNavEventProc(
	NavEventCallbackMessage	callbackSelector,
	NavCBRecPtr				callbackParms,
	NavCallBackUserData		callbackUD )
{
	switch( callbackSelector )
	{
		case kNavCBEvent:
			if( callbackParms->eventData.event->what == updateEvt )
				CPGPKeys::TheApp()->
					DispatchEvent( *callbackParms->eventData.event );
			break;
	}
}
*/
	void
CPGPKeys::HandleAppleEvent(
	const AppleEvent	&inAppleEvent,
	AppleEvent			&outAEReply,
	AEDesc				&outResult,
	long				inAENumber)
{
	switch( inAENumber )
	{
		case ae_ImportKey:
		{
			StAEDescriptor	descKeys(	inAppleEvent,
										keyDirectObject);
			
			if(mWritableKeyring)
			{
				mDefaultKeysView->
					ImportKeysFromHandle(descKeys.mDesc.dataHandle);
			}
			break;
		}


		default:
			LDocApplication::HandleAppleEvent(inAppleEvent, outAEReply,
								outResult, inAENumber);
			break;
	}
	
}

	void
CPGPKeys::ResetDefaultKeyringsPath()
{
	CInfoPBRec		pb;
	Str255			name;
	PGPError		err;
	FSSpec			publicKeyFileSpec;
	FSSpec			privateKeyFileSpec;
	
	GetIndString(name, kMiscStringsID, kPGPKeyringsFolderStringID);
	
	pb.dirInfo.ioVRefNum 	= gAppFSSpec.vRefNum;
	pb.dirInfo.ioDrDirID 	= gAppFSSpec.parID;
	pb.dirInfo.ioNamePtr 	= name;
	pb.dirInfo.ioFDirIndex 	= 0;
	
	if (PBGetCatInfoSync( &pb ) == noErr
				&& cpbIsFolder( &pb ))
	{
		publicKeyFileSpec.vRefNum 	= pb.dirInfo.ioVRefNum;
		publicKeyFileSpec.parID 	= pb.dirInfo.ioDrDirID;
		
		err = PGPGetPGPFileName( gPGPContext,
					kPGPFileSelector_PublicKeys,
					publicKeyFileSpec.name );
		pgpAssertNoErr( err );
		
		privateKeyFileSpec.vRefNum 	= pb.dirInfo.ioVRefNum;
		privateKeyFileSpec.parID 	= pb.dirInfo.ioDrDirID;
		
		err = PGPGetPGPFileName( gPGPContext,
					kPGPFileSelector_PrivateKeys, 
					privateKeyFileSpec.name );
		pgpAssertNoErr( err );
	}
	else
	{
		err = PGPGetPGPFileDefaultFSSpec( gPGPContext,
					kPGPFileSelector_PublicKeys, &publicKeyFileSpec );
		pgpAssertNoErr( err );

		err = PGPGetPGPFileDefaultFSSpec( gPGPContext, 
					kPGPFileSelector_PrivateKeys,
					&privateKeyFileSpec );
		pgpAssertNoErr( err );
	}
	
	err = PGPSetPGPFileFSSpec( gPGPContext, kPGPFileSelector_PublicKeys,
				&publicKeyFileSpec );
	pgpAssertNoErr( err );

	err = PGPSetPGPFileFSSpec( gPGPContext, kPGPFileSelector_PrivateKeys,
				&privateKeyFileSpec );
	pgpAssertNoErr( err );
}

