/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPDiskGlobals.c,v 1.2.8.1 1998/11/12 03:06:09 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "PGPDisk.h"
#include "PGPDiskGlobals.h"

	OSStatus
GetPGPDiskGloblalsPtr(PGPDiskGlobals * const *globalsPtr)
{
	OSStatus	status;
	
	pgpAssertAddrValid( globalsPtr, PGPDiskGlobals * );
	
	status = Gestalt( gestaltPGPDisk, (long *) globalsPtr );
	if( IsntErr( status ) )
	{
		if( (*globalsPtr)->magic != kPGPDiskGlobalsMagic )
		{
			status = kPGPDiskInvalidGlobalsMagicError;
		}
	}
	
	AssertNoErr( status, "GetPGPDiskGloblalsPtr" );

	return( status );
}