/*___________________________________________________________________________
	DebugOSErrStrings.inc
	
	this file is #included in Debug.c
	because of its size, it is kept in this separate file

	Define a table consisting of the OSErr code and a corresponding string.
	For convenience, the string is generated using the macro preprocessor,
	which generates a C string (null terminated string).
	A table could also be generated manually, but this method guarantees
	that the string is identical to the error as seen in the header file.
____________________________________________________________________________*/
#define DefineIt(err)	{err, #err}

static const DebugOSErrStringTableEntry	sSystemErrorsTable[]	=
	{
	DefineIt( prWrErr ),
	DefineIt( prInitErr ),
	DefineIt( rcvrErr ),
	DefineIt( breakRecd ),
	
	DefineIt( pmBusyErr ),
	DefineIt( pmReplyTOErr ),
	DefineIt( pmSendStartErr ),
	DefineIt( pmSendEndErr ),
	DefineIt( pmRecvStartErr ),
	DefineIt( pmRecvEndErr ),
	
	DefineIt( noScrapErr ),
	DefineIt( noTypeErr ),
	DefineIt( memROZWarn ),
	DefineIt( memROZError ),
	DefineIt( memROZErr ),
	DefineIt( memFullErr ),
	DefineIt( nilHandleErr ),
	DefineIt( memWZErr ),
	DefineIt( memPurErr ),
	DefineIt( memAdrErr ),

	DefineIt( paramErr ),
	DefineIt( noHardwareErr ),
	DefineIt( notEnoughHardwareErr ),
	DefineIt( userCanceledErr ),
	DefineIt( qErr ),
	DefineIt( vTypErr ),
	DefineIt( corErr ),
	DefineIt( unimpErr ),
	DefineIt( SlpTypeErr ),
	DefineIt( seNoDB ),
	DefineIt( controlErr ),
	DefineIt( statusErr ),
	DefineIt( readErr ),
	DefineIt( writErr ),
	DefineIt( badUnitErr ),
	DefineIt( unitEmptyErr ),
	DefineIt( openErr ),
	DefineIt( closErr ),
	DefineIt( dRemovErr ),
	DefineIt( dInstErr ),
	DefineIt( abortErr ),
	DefineIt( iIOAbortErr ),
	DefineIt( notOpenErr ),
	DefineIt( unitTblFullErr ),
	DefineIt( dceExtErr ),
	DefineIt( slotNumErr ),
	DefineIt( gcrOnMFMErr ),
	DefineIt( dirFulErr ),
	DefineIt( dskFulErr ),
	DefineIt( nsvErr ),
	DefineIt( ioErr ),
	DefineIt( bdNamErr ),
	DefineIt( fnOpnErr ),
	DefineIt( eofErr ),
	DefineIt( posErr ),
	DefineIt( mFulErr ),
	DefineIt( tmfoErr ),
	DefineIt( fnfErr ),
	DefineIt( wPrErr ),
	DefineIt( fLckdErr ),
	DefineIt( vLckdErr ),
	DefineIt( fBsyErr ),
	DefineIt( dupFNErr ),
	DefineIt( opWrErr ),
	DefineIt( rfNumErr ),
	DefineIt( gfpErr ),
	DefineIt( volOffLinErr ),
	DefineIt( permErr ),
	DefineIt( volOnLinErr ),
	DefineIt( nsDrvErr ),
	DefineIt( noMacDskErr ),
	DefineIt( extFSErr ),
	DefineIt( fsRnErr ),
	DefineIt( badMDBErr ),
	DefineIt( wrPermErr ),
	DefineIt( dirNFErr ),
	DefineIt( tmwdoErr ),
	DefineIt( badMovErr ),
	DefineIt( wrgVolTypErr ),
	DefineIt( volGoneErr ),
	DefineIt( fidNotFound ),
	DefineIt( fidExists ),
	DefineIt( notAFileErr ),
	DefineIt( diffVolErr ),
	DefineIt( catChangedErr ),
	DefineIt( desktopDamagedErr ),
	DefineIt( sameFileErr ),
	DefineIt( badFidErr ),
	DefineIt( envNotPresent ),
	DefineIt( envBadVers ),
	DefineIt( envVersTooBig ),
	DefineIt( fontDecError ),
	DefineIt( fontNotDeclared ),
	DefineIt( fontSubErr ),
	DefineIt( fontNotOutlineErr ),
	DefineIt( firstDskErr ),
	DefineIt( lastDskErr ),
	DefineIt( noDriveErr ),
	DefineIt( offLinErr ),
	DefineIt( noNybErr ),
	DefineIt( noAdrMkErr ),
	DefineIt( dataVerErr ),
	DefineIt( badCksmErr ),
	DefineIt( badBtSlpErr ),
	DefineIt( noDtaMkErr ),
	DefineIt( badDCksum ),
	DefineIt( badDBtSlp ),
	DefineIt( wrUnderrun ),
	DefineIt( cantStepErr ),
	DefineIt( tk0BadErr ),
	DefineIt( initIWMErr ),
	DefineIt( twoSideErr ),
	DefineIt( spdAdjErr ),
	DefineIt( seekErr ),
	DefineIt( sectNFErr ),
	DefineIt( fmt1Err ),
	DefineIt( fmt2Err ),
	DefineIt( verErr ),
	DefineIt( clkRdErr ),
	DefineIt( clkWrErr ),
	DefineIt( memAZErr ),
	DefineIt( memPCErr ),
	DefineIt( memBCErr ),
	DefineIt( memSCErr ),
	DefineIt( memLockedErr ),
	DefineIt( resourceInMemory ),
	DefineIt( writingPastEnd ),
	DefineIt( inputOutOfBounds ),
	DefineIt( resNotFound ),
	DefineIt( resFNotFound ),
	DefineIt( addResFailed ),
	DefineIt( addRefFailed ),
	DefineIt( rmvResFailed ),
	DefineIt( rmvRefFailed ),
	DefineIt( resAttrErr ),
	DefineIt( mapReadErr ),
	DefineIt( CantDecompress ),
	DefineIt( badExtResource ),
	DefineIt( evtNotEnb ),
	DefineIt( noMemForPictPlaybackErr ),
	DefineIt( rgnOverflowErr ),
	DefineIt( rgnTooBigError ),
	DefineIt( pixMapTooDeepErr ),
	DefineIt( insufficientStackErr ),
	DefineIt( nsStackErr ),
	DefineIt( notEnoughMemoryErr ),
	DefineIt( notHeldErr ),
	DefineIt( cannotMakeContiguousErr ),
	DefineIt( notLockedErr ),
	DefineIt( interruptsMaskedErr ),
	DefineIt( cannotDeferErr ),
	DefineIt( errAEImpossibleRange ),
	DefineIt( errAEWrongNumberArgs ),
	DefineIt( errAEAccessorNotFound ),
	DefineIt( errAENoSuchLogical ),
	DefineIt( errAEBadTestKey ),
	DefineIt( errAENotAnObjSpec ),
	DefineIt( errAENoSuchObject ),
	DefineIt( errAENegativeCount ),
	DefineIt( errAEEmptyListContainer ),
	DefineIt( errAECoercionFail ),
	DefineIt( errAEDescNotFound ),
	DefineIt( errAECorruptData ),
	DefineIt( errAEWrongDataType ),
	DefineIt( errAENotAEDesc ),
	DefineIt( errAEBadListItem ),
	DefineIt( errAENewerVersion ),
	DefineIt( errAENotAppleEvent ),
	DefineIt( errAEEventNotHandled ),
	DefineIt( errAEReplyNotValid ),
	DefineIt( errAEUnknownSendMode ),
	DefineIt( errAEWaitCanceled ),
	DefineIt( errAETimeout ),
	DefineIt( errAENoUserInteraction ),
	DefineIt( errAENotASpecialFunction ),
	DefineIt( errAEParamMissed ),
	DefineIt( errAEUnknownAddressType ),
	DefineIt( errAEHandlerNotFound ),
	DefineIt( errAEReplyNotArrived ),
	DefineIt( errAEIllegalIndex ),
	DefineIt( errAEUnknownObjectType ),
	DefineIt( errAERecordingIsAlreadyOn ),
	DefineIt( errAEBadKeyForm ),
	DefineIt( errAECantHandleClass ),
	DefineIt( errAECantSupplyType ),
	DefineIt( errAECantUndo ),
	DefineIt( errAEEventFailed ),
	DefineIt( errAEIndexTooLarge ),
	DefineIt( errAEInTransaction ),
	DefineIt( errAELocalOnly ),
	DefineIt( errAENoSuchTransaction ),
	DefineIt( errAENotAnElement ),
	DefineIt( errAENotASingleObject ),
	DefineIt( errAENotModifiable ),
	DefineIt( errAENoUserSelection ),
	DefineIt( errAEPrivilegeError ),
	DefineIt( errAEReadDenied ),
	DefineIt( errAETypeError ),
	DefineIt( errAEWriteDenied ),
	DefineIt( fragNoErr ),
	DefineIt( fragContextNotFound ),
	DefineIt( fragConnectionIDNotFound ),
	DefineIt( fragSymbolNotFound ),
	DefineIt( fragSectionNotFound ),
	DefineIt( fragLibNotFound ),
	DefineIt( fragDupRegLibName ),
	DefineIt( fragFormatUnknown ),
	DefineIt( fragHadUnresolveds ),
	DefineIt( fragUnused1 ),
	DefineIt( fragNoMem ),
	DefineIt( fragNoAddrSpace ),
	DefineIt( fragNoContextIDs ),
	DefineIt( fragObjectInitSeqErr ),
	DefineIt( fragImportTooOld ),
	DefineIt( fragImportTooNew ),
	DefineIt( fragInitLoop ),
	DefineIt( fragInitRtnUsageErr ),
	DefineIt( fragLibConnErr ),
	DefineIt( fragMgrInitErr ),
	DefineIt( fragConstErr ),
	DefineIt( fragCorruptErr ),
	DefineIt( fragUserInitProcErr ),
	DefineIt( fragAppNotFound ),
	DefineIt( fragArchError ),
	DefineIt( fragInvalidFragmentUsage ),
	DefineIt( fragLastErrCode ),
	DefineIt( badDragRefErr ),
	DefineIt( badDragItemErr ),
	DefineIt( badDragFlavorErr ),
	DefineIt( duplicateFlavorErr ),
	DefineIt( cantGetFlavorErr ),
	DefineIt( duplicateHandlerErr ),
	DefineIt( handlerNotFoundErr ),
	DefineIt( dragNotAcceptedErr ),
	DefineIt( dsBadLibrary ),
	DefineIt( dsMixedModeFailure ),
	};

#undef DefineIt


