!define DEFAULT_DIR "C:\Garmin\Maps\Openseamap"
!define INSTALLER_DESCRIPTION "Openseamap"
!define INSTALLER_NAME "Openseamap"
!define MAPNAME "openseamap"
!define PRODUCT_ID "1"
!define REG_KEY "Openseamap"

SetCompressor /SOLID lzma

; Includes
!include "MUI2.nsh"

; Installer pages
!define MUI_CUSTOMFUNCTION_GUIINIT myGuiInit
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE ${MAPNAME}_license.txt
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!define MUI_UNPAGE_INSTFILES

; Language files
!define MUI_LANGDLL_ALLLANGUAGES
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Dutch"


LangString AlreadyInstalled ${LANG_ENGLISH} "${INSTALLER_NAME} is already installed. $\n$\nClick `OK` to remove the previous version and continue installation or `Cancel` to cancel this upgrade."
LangString AlreadyInstalled ${LANG_FRENCH} "${INSTALLER_NAME} est d�j� install�. $\n$\nAppuyez sur `OK` pour retirer la version pr�c�dente et continuer avec l'installation ou sur `Annuler` pour annuler cette mise � jour."
LangString AlreadyInstalled ${LANG_SPANISH} "${INSTALLER_NAME} ya est� instalado. $\n$\nPulse `Aceptar` para eliminar la versi�n anterior y continuar la instalaci�n o `Cancelar` para cancelar esta actualizaci�n."
LangString AlreadyInstalled ${LANG_GERMAN} "${INSTALLER_NAME} ist bereits installiert. $\n$\nKlick `OK` um die alte Version zu deinstallieren oder `Abbrechen` um die Installation abzubrechen."
LangString AlreadyInstalled ${LANG_DUTCH} "${INSTALLER_NAME} is reeds geinstalleerd. $\n$\nKlik op `OK` om de oude versie te verwijderen of `Annuleren` om deze update te onderbreken."

; Reservefiles
!insertmacro MUI_RESERVEFILE_LANGDLL ;Language selection dialog


Name "${INSTALLER_DESCRIPTION}"
OutFile "${INSTALLER_NAME}.exe"
InstallDir "${DEFAULT_DIR}"

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Function myGUIInit
  ;Read $INSTDIR from the registry
  ClearErrors
  ReadRegStr $INSTDIR HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "LOC"
  IfErrors +2
  StrCmp $INSTDIR "" 0 +2
  StrCpy $INSTDIR "${DEFAULT_DIR}"
  
  ; Uninstall before installing (code from http://nsis.sourceforge.net/Auto-uninstall_old_before_installing_new )
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}" "UninstallString"
  StrCmp $R0 "" done
 
  IfSilent silent
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION "$(AlreadyInstalled)" IDOK uninst
  Abort

  ;Run the uninstaller
  uninst:
  ClearErrors
  ExecWait '"$R0" /S ' ;Do not copy the uninstaller to a temp file
 
  IfErrors no_remove_uninstaller done
    ;You can either use Delete /REBOOTOK in the uninstaller or add some code
    ;here to remove the uninstaller. Use a registry key to check
    ;whether the user has chosen to uninstall. If you are using an uninstaller
    ;components page, make sure all sections are uninstalled.
  no_remove_uninstaller:
  
  Goto done
 
  silent:
  ExecWait '"$R0" /S ' ;Do not copy the uninstaller to a temp file
 
  done:
 
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
FunctionEnd

Section "MainSection" SectionMain
; Files to be installed
  SetOutPath "$INSTDIR"
  File "${MAPNAME}.img"
  File "${MAPNAME}.tdb"
  File "63240001.img"
  File "63240002.img"
  File "63240003.img"
  File "63240004.img"
  File "63240005.img"
  File "63240006.img"
  File "63240007.img"
  File "63240008.img"
  File "63240009.img"
  File "63240010.img"
  File "63240011.img"
  File "63240012.img"
  File "63240013.img"
  File "63240014.img"
  File "63240015.img"
  File "63240016.img"
  File "63240017.img"
  File "63240018.img"
  File "63240019.img"
  File "63240020.img"
  File "63240021.img"
  File "63240022.img"
  File "63240023.img"
  File "63240024.img"
  File "63240025.img"
  File "63240026.img"
  File "63240027.img"
  File "63240028.img"
  File "63240029.img"
  File "63240030.img"
  File "63240031.img"
  File "63240032.img"
  File "63240033.img"
  File "63240034.img"

; Create MapSource registry keys
  WriteRegBin HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "ID" d80b
!ifdef INDEX  
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "IDX" "$INSTDIR\${MAPNAME}.mdx"
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "MDR" "$INSTDIR\${MAPNAME}_mdr.img"
!endif
!ifdef TYPNAME  
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "TYP" "$INSTDIR\${TYPNAME}"
!endif
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "BMAP" "$INSTDIR\${MAPNAME}.img"
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "LOC" "$INSTDIR"
  WriteRegStr HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "TDB" "$INSTDIR\${MAPNAME}.tdb"
  
; Write uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

; Create uninstaller registry keys
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}" "UninstallString" "$INSTDIR\Uninstall.exe"
  WriteRegDWORD HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}" "NoModify" 1
  
SectionEnd

Section "Uninstall"
; Files to be uninstalled
  Delete "$INSTDIR\${MAPNAME}.img"
  Delete "$INSTDIR\${MAPNAME}.tdb"
  Delete "$INSTDIR\63240001.img"
  Delete "$INSTDIR\63240002.img"
  Delete "$INSTDIR\63240003.img"
  Delete "$INSTDIR\63240004.img"
  Delete "$INSTDIR\63240005.img"
  Delete "$INSTDIR\63240006.img"
  Delete "$INSTDIR\63240007.img"
  Delete "$INSTDIR\63240008.img"
  Delete "$INSTDIR\63240009.img"
  Delete "$INSTDIR\63240010.img"
  Delete "$INSTDIR\63240011.img"
  Delete "$INSTDIR\63240012.img"
  Delete "$INSTDIR\63240013.img"
  Delete "$INSTDIR\63240014.img"
  Delete "$INSTDIR\63240015.img"
  Delete "$INSTDIR\63240016.img"
  Delete "$INSTDIR\63240017.img"
  Delete "$INSTDIR\63240018.img"
  Delete "$INSTDIR\63240019.img"
  Delete "$INSTDIR\63240020.img"
  Delete "$INSTDIR\63240021.img"
  Delete "$INSTDIR\63240022.img"
  Delete "$INSTDIR\63240023.img"
  Delete "$INSTDIR\63240024.img"
  Delete "$INSTDIR\63240025.img"
  Delete "$INSTDIR\63240026.img"
  Delete "$INSTDIR\63240027.img"
  Delete "$INSTDIR\63240028.img"
  Delete "$INSTDIR\63240029.img"
  Delete "$INSTDIR\63240030.img"
  Delete "$INSTDIR\63240031.img"
  Delete "$INSTDIR\63240032.img"
  Delete "$INSTDIR\63240033.img"
  Delete "$INSTDIR\63240034.img"
  Delete "$INSTDIR\Uninstall.exe"

  RmDir "$INSTDIR"

; Registry cleanup
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "ID"
!ifdef INDEX  
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "IDX"
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "MDR"
!endif
!ifdef TYPNAME  
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}" "TYP"
!endif
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "BMAP"
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "LOC"
  DeleteRegValue HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}" "TDB"
  DeleteRegKey /IfEmpty HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}\${PRODUCT_ID}"
  DeleteRegKey /IfEmpty HKLM "SOFTWARE\Garmin\MapSource\Families\${REG_KEY}"
  
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${REG_KEY}"

SectionEnd
