#!/bin/bash
# set -x #echo on

# This .bat file is copyrighted by https://openmtbmap.org.
# You may not (re)distribute it.
# gmaptool (gmt) is published by www.gmaptool.eu. 
# Only for OpenMTBMap and VeloMap gmapsupp.img country contourlins only maps.

echo "please press "0" for 20m (7*.img) contourlines"
echo "please press "1" for 10m (9*.img) contourlines" 
echo "please press "2" for 10m resolution 23 (8*.img) contourlines"
read input
if [ "$input" == "0" ]; then
	cntrs=7*
elif [ "$input" == "O" ]; then
	cntrs=7*
elif [ "$input" == "o" ]; then
	cntrs=7*
elif [ "$input" == "1" ]; then
	cntrs=9*
elif [ "$input" == "2" ]; then
	cntrs=8*
else
	echo "You pressed a wrong key. Will exit now."
	exit
fi	


# Tool to change the type file including path 
# First Check if we are Using OSx or Linux
if [[ "$OSTYPE" == "linux-gnu" ]] 2>/dev/null; then 
    gmt=./resources/gmt_linux
elif [[ "$OSTYPE" == "darwin"* ]] 2>/dev/null; then
	if [[ "$os_ver" =~ 10.1[56789].* ]]; then
		echo "Note starting from macOS 10.15 or higher - this bash script does not work anymore because it needs 32 bit compatibility"
		echo ""
		echo "Aborting"
		exit
	elif [[ "$os_ver" =~ 1[123456789].* ]]; then
		echo "Note starting from macOS 10.15 or higher - this bash script does not work anymore because it needs 32 bit compatibility"
		echo ""
		echo "Aborting"
		exit
	fi
	gmt=./resources/gmt_osx
elif [[ "$OSTYPE" == "cygwin" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "msys" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "win32" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "freebsd"* ]] 2>/dev/null; then
	echo "gmt is not tested on freebsd - I hope it works"
	gmt=./resources/gmt_linux
elif [ "`uname`" = "Darwin" ] 2>/dev/null; then
	gmt=./resources/gmt_osx
elif [ "`uname`" = "Linux" ] 2>/dev/null; then
    gmt=./resources/gmt_linux
else
    echo "Cannot determine the operating system. Please edit the .sh file to select"
	echo "the correct version of gmt (gmaptool). I do not know if gmt runs on other systems"
	echo "than OSx and Linux"
	echo "This script is made for bash, but can run also on sh (Bourne Shell)"
	echo ""
	echo "Aborting"
	exit
fi
	
# Check if gmt is present!
if [ -e $gmt ]; then
	echo ""
else
	echo "trying to download gmaptool for linux now"
	wget -c -q https://openmtbmap.org/wp-content/mkgmap/gmt_linux >/dev/null
		if [ -e $gmt ]; then
			echo "Success - Downloaded gmaptool for linux"
			echo ""
			echo ""
		else
			echo "trying to install wget first"
			sudo apt-get install wget >/dev/null
			sudo zypper install wget >/dev/null
			sudo pacman -Syu wget >/dev/null
			wget -c -q https://openmtbmap.org/wp-content/mkgmap/gmt_linux >/dev/null
				if [ -e $gmt ]; then
					echo "Success installed wget and downloaded gmaptool for linux"
					echo ""
					echo ""
				else
					echo "Sorry could not download gmt_linux. Please manually download gmt_linux into the current folder"
					echo "get gmt Linux from http://gmaptool.eu or https://openmtbmap.org/wp-content/mkgmap/gmt_linux"
					echo ""
					echo "Aborting"
					exit
				fi
		fi
fi

# Elevate $gmt to have execute permissions
[ -x $gmt ] && echo "" || chmod u+x $gmt

if [ -f $cntrs.img.old ]; then
	if [ -f $cntrs.img ]; then
		echo "Found old contourlines likely containg DEM information"
		echo "If you like you can restore them now"
		echo ""
		echo "Type yes to restore them - Press any key or type no to stop (yes/no):"
		read input
		if [ "$input" == "yes" ]; then
			echo "now restoring the old contourlines containing DEM"
				for f in $cntrs.img; do 
				rm $cntrs.img
				done
				for f in $cntrs.img.old; do 
				mv -- "$f" "${f%.img.old}.img"
				done
				echo "deleted $cntrs.img files and restored $cntrs.img.old files"
				echo ""
				exit
		else
			echo "Exiting Now. This script cannot continue to run if there are any .img.old files present"
			echo ""
			exit
		fi
	fi
fi


if [ -f $cntrs.img ];
			then imgfile=$cntrs.img
			echo "Going to remove DEM information from $cntrs.img contourline files"
			echo "The contourlines containing DEM information will be renamed to .old files"
			echo "Press any key to continue"
			read -n 1 -s -r -p  "Close the Terminal or press CTRL-C to exit now"
			echo ""
			echo ""
			mkdir nodem
			$gmt -j -o nodem/nodem957.img -q $cntrs.img  >/dev/null
			if [ -f ./nodem/nodem957.img ]; then
				for f in $cntrs.img; do 
				mv -- "$f" "${f%.img}.img.old"
				done
				$gmt -S ./nodem/nodem957.img  >/dev/null
				if [ -f $cntrs.img ]; then
					rm -rf nodem
						if [ $? -eq 0 ]; then
							echo "Success - Removed the DEM information from all $cntrs.img contourlines files"
							echo ""
							echo ""
						else
							echo "Error - likely could not overwrite the old contourline files. Make sure that the map is not open anywhere"
							echo ""
							echo ""
						fi
				else
					echo "Could not split the nodem957.img file"
					echo ""
				fi
			else
				echo "could Join maps to temporary nodem957.img file"
				echo ""
			fi
else
	echo "Cannot run without having openmtbmap/velomap $cntrs files"
	echo ""
	exit
fi

if [ -f $cntrs.img.old ]; then
	if [ -f $cntrs.img ]; then
		echo "You can now optionally remove the old contourlines containing DEM. Attention you cannot restore them anymore once deleted"
		echo "If you remove the old contourlines and want to reenable DEM - you will need to redownload the map or contourlines"
		echo ""
		echo "Type yes to continue - Press any key or type no to stop (yes/no):"
		read input
		if [ "$input" == "yes" ]; then
			echo "now deleting the old contourlines containing DEM"
			rm $cntrs.img.old
		else
			echo "Keeping the old contourlines as backup. Exiting Now"
		fi
	fi
fi
		

exit
