#!/bin/bash
# set -x #echo on

#=====================================================================
#
# Replace .TYP-files in gmapsupp.img image file with GMapTool,
# gmaptool (gmt) is published by www.gmaptool.eu. 
# Only for VeloMap gmapsupp.img country maps. Not for OpenMTBMap and also not for Contourlines Maps.
# Not compatible with new Mac OSx version only supporting 64bit (gmt is only available as 32bit program on Mac, no problem in Linux - so use a virtual machine with linux or another PC if you need it)


# Tool to change the type file including path 
# First Check if we are Using OSx or Linux
if [[ "$OSTYPE" == "linux-gnu" ]] 2>/dev/null; then 
    gmt=./resources/gmt_linux
elif [[ "$OSTYPE" == "darwin"* ]] 2>/dev/null; then
	if [[ "$os_ver" =~ 10.1[56789].* ]]; then
		echo "Note starting from macOS 10.15 or higher - this bash script does not work anymore because it needs 32 bit compatibility"
		echo ""
		echo "Aborting"
		exit
	elif [[ "$os_ver" =~ 1[123456789].* ]]; then
		echo "Note starting from macOS 10.15 or higher - this bash script does not work anymore because it needs 32 bit compatibility"
		echo ""
		echo "Aborting"
		exit
	fi
	gmt=./resources/gmt_osx
elif [[ "$OSTYPE" == "cygwin" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "msys" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "win32" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "freebsd"* ]] 2>/dev/null; then
	echo "gmt is not tested on freebsd - I hope it works"
	gmt=./resources/gmt_linux
elif [ "`uname`" = "Darwin" ] 2>/dev/null; then
	gmt=./resources/gmt_osx
elif [ "`uname`" = "Linux" ] 2>/dev/null; then
    gmt=./resources/gmt_linux
else
    echo "Cannot determine the operating system. Please edit the .sh file to select"
	echo "the correct version of gmt (gmaptool). I do not know if gmt runs on other systems"
	echo "than OSx and Linux"
	echo "This script is made for bash, but can run also on sh (Bourne Shell)"
	echo ""
	echo "Aborting"
	exit
fi

# Elevate $gmt to have execute permissions

[ -x $gmt ] && echo "" || chmod u+x $gmt

# Check if gmt is present!
if [ -e $gmt ]; then
		echo ""
		else
		echo "Missing $gmt"
		echo "Cannot continue"
		echo ""
		echo "please do not move the bash file without moving all the files and directory"
		echo "Either missing resources directory - or some of its content"
		echo ""
		exit
	fi

# Check if gmapsupp.img can be found if no arguments given
if [ $# -eq 0 ]; then
	# Lets try if gmapsupp.img exists
	if [ -f gmapsupp.img ]
		then imgfile=gmapsupp.img
		echo "Going to change the .TYP-file in gmapsupp.img"
		else
		echo "Please pass the imgfile you wish to change as argument:"
		echo "or make sure the imgfile is named "gmapsupp.img""
		echo ""
		echo "example"
		echo "  bash change_layout_mtbmap.sh gmapsupp.img"
		echo ""
		exit
	fi
	
		
elif  [ $# -eq 1 ]; then
	# Catch User Input
	tempimgfile=$1
		case "$tempimgfile" in 
			*.img|*.IMG|*.Img)
			imgfile=$1
			if [ -f $imgfile ]; then
			echo ""
			else unset imgfile
			fi
			;;
		esac

	if [ -z ${imgfile+x} ]; then
			echo "Please pass the imgfile you wish to change as argument:"
			echo "or make sure the imgfile is named "gmapsupp.img""
			echo ""
			echo "example"
			echo "  bash change_layout_mtbmap.sh gmapsupp.img"
			echo ""
			echo ""
			echo "the argument you passed:"
			echo $1
			echo "does not exist or is not a valid gmapsupp.img file"
			echo ""
			echo "Aborting now"
			exit
		else
		echo "Going to Change the .TYP-file in "
			echo $imgfile
		fi
		
elif [ $# -eq 2 ]; then
	# Catch User Input
	tempimgfile=$1
	temptypfile=$2
	
	echo $tempimgfile
	case "$tempimgfile" in 
		*.img|*.IMG|*.Img)
		imgfile=$1
		if [ -f $imgfile ]; then
		echo ""
		else unset imgfile
		fi
		;;
	esac

	echo $temptypfile
	case "$temptypfile" in 
		*.typ|*.TYP|*.Typ)
		typfile=$2
		if [ -f $typfile ]; then
		echo "" 
		else unset typfile
		fi
		;;
	esac
	
	
	if [ -z ${imgfile+x} ] && [ -z ${typfile+x} ]; then
			echo "Please pass the .img file you wish to change as first argument, the .TYP-file as second argument:"
			echo "or make sure the .img file is named "gmapsupp.img""
			echo ""
			echo $1
			echo does not exist or is not a valid gmapsupp.img file
			echo ""
			echo $2
			echo does not exist or is not a valid .TYP file
			echo ""
			echo "example"
			echo "  bash change_layout_mtbmap.sh gmapsupp.img resources/trdn.TYP"
			echo ""
			echo "Either your arguments are not correct, or the files do not exist!"
			echo Aborting Now
			echo ""
			exit
			
	elif [ -z ${imgfile+x} ]; then
			echo "The first argument you passed has to be the gmapsupp.img file"
			echo "You did not pass a valid gmapsupp.img file or"
			echo $1 does not exist or is not valid
			echo ""
			echo "example"
			echo "  bash change_layout_mtbmap.sh gmapsupp.img resources/trdn.TYP"
			echo ""
			echo "Aborting now"
			echo ""
			exit

	elif [ -z ${typfile+x} ]; then
			echo "The second argument you pass can only be a .TYP file"
			echo "you did not pass a valid TYP file or"
			echo $2 does not exist or is not valid
			echo ""
			echo "example"
			echo "  bash change_layout_mtbmap.sh gmapsupp.img resources/trdn.TYP"
			echo ""
			echo "Aborting Now"
			echo ""
			exit
	else 
			echo "Going to Change the .TYP-file in "
			echo $imgfile
			echo "with"
			echo $typfile
	fi	

	
	
else # In case there is more than 2 arguments
		echo "Sorry you can not pass more than 2 arguments"
		echo "Please pass the .img file you wish to change as first argument, the .TYP-file as second argument:"
		echo "or make sure the .img file is named "gmapsupp.img""
		echo ""
		echo ""
		echo example without argument - in this case you will be asked for .TYP-file and gmapsupp.img needs to be present.
		echo "  bash change_layout_mtbmap.sh"
		echo ""
		echo "example with 1 argument"
		echo "  bash change_layout_mtbmap.sh gmapsupp.img "
		echo ""
		echo "example 2 with 2 arguments"
		echo "  bash change_layout_mtbmap.sh gmapsupp.img resources/trdn.TYP"
		echo ""
		echo "Either your arguments are not correct, or the files do not exist!"
		echo "or there is more than 1 .img or .TYP file matching"
		echo "you gave the following arguments"
		echo $1
		echo $2
		echo $3
		echo $4
		echo ""
		echo "Aborting now"
		echo ""
		exit
fi

# If $typfile is still '' here, we need to aks the user
if [ -z $typfile ]; then
	echo ""
	echo "Select from the following options:"
	typ0="Wide - standard design for most GPS units with high contrast and wide lines (for medium to high DPI GPS Units) - streets in modern colors only orange to yellow"
	typ1="Wide Legacy. Same as above but with streets in high contrast colours - blue/red/orange/yellow"
	typ2="Race - A reduced layout for road cycling/racing with high contrast"
	typ3="Classic - Similar to Wide Layout but thinner lines - for units with lower DPI/older Garmin GPS devices  - streets in modern colors only orange to yellow"
	typ4="Classic Legacy - Same as above - but with streets in high contrast colours - blue/red/orange/yellow"
	typ5="Thin - like Velo Legacy but even thinner lines. For low resolution devices like GPSMaps series."
	typ6="Traditional - the Desktop Layout - lower Contrast not really suited for GPS Units outdoor"
	typ7="Wide_Easy - Same width as Velo_Wide - but easier to understand - colors similar to topographical maps or google maps. No parallel cycletracks."
	typ8="Fenix - similar to Velo Wide Legacy but optimized for Fenix series 5/6/7 watches which can only show 64 colours"
	typ9="Simple Topographical Layout - Classical topographical map layout simple and easy to read. High Contrast."
	typ10="LCD-AMOLED --- similar to Wide Legacy but for high DPI devices like Fenix 8 / Epix 2 / Edge 1050 with LCD or AMOLED display (not for Fenix 8 Solar which needs Fenix Layout)"

	
	echo "  0: $typ0"	
	echo "  1: $typ1"
	echo "  2: $typ2"
	echo "  3: $typ3"
	echo "  4: $typ4"
	echo "  5: $typ5"
	echo "  6: $typ6"
	echo "  7: $typ7"
	echo "  8: $typ8"
	echo "  9: $typ9"
	echo "  10: $typ10"
	echo ""
	echo "  Q: Press Q or any other key to Quit/Exit"
	echo ""
	echo ""
	
		
	
	echo "Enter your choice (0-10, Q): "
          # Do we run bash ?
          if [ -n "$BASH" ]; then
                    read -n 1 key
          else
                    read key
          fi

	echo ""

	typfile=''

	case "$key" in

		0)
			echo You selected:
			echo $typ0
			typfile=resources/velw*.TYP
		;;
	
		1)
			echo You selected:
			echo $typ1
			typfile=resources/vwlg*.TYP
		;;
		
		2)
			echo You selected:
			echo $typ2
			typfile=resources/race*.TYP
		;;

		3)
			echo You selected:
			echo $typ3
			typfile=resources/velo*.TYP
		;;
		
		4)
			echo You selected:
			echo $typ4
			typfile=resources/velg*.TYP
		;;

		5)
			echo You selected:
			echo $typ5
			typfile=resources/vthn*.TYP
		;;
		
		6)
			echo You selected:
			echo $typ6
			typfile=resources/trdn*.TYP
		;;
		
		7)
			echo You selected:
			echo $typ7
			typfile=resources/esyv*.TYP
		;;
		8)
			echo You selected:
			echo $typ8
			typfile=resources/vfnx*.TYP
		;;
		9)
			echo You selected:
			echo $typ9
			typfile=resources/topv*.TYP
		;;
		10)
			echo You selected:
			echo $typ10
			typfile=resources/vlcd*.TYP
		;;
		q|Q)
			echo Aborting by user request.
			exit
		;;
		*)
			echo Unknown selection. Exiting...
			exit
		;;
	esac
fi


















echo "------------------------------------------------------------"
echo ""


# Use gmt to fist find FID and change FID in .typfile (usually not needed)
# then replace the typ inside the gmapsupp.img
fid=`$gmt -i $imgfile | grep ", FID " | cut -d',' -f 2 | sed -e 's/ FID //'`



$gmt -w -y $fid $typfile >/dev/null
$gmt -w -x $typfile $imgfile >/dev/null
echo "Success - Replaced .TYP file in:"
echo $imgfile
echo ""


# basecamp_readable
echo ""
echo ""
echo BASECAMP VISIBILITY of $imgfile
echo ""
echo - do you want that the gmapsupp.img file to show up for display in Basecamp?
echo - note that reading in the map by Basecamp takes some time. Therefore it is off by default now. I recommend you press 0 to exit.
echo - However it can be useful to some people.
echo - Press 0 or any other key to keep map invisible to Basecamp. 
echo - Press 1 to make map readable by Basecamp

read -n 1 -p "Enter your choice (0,1): 
" USR_INT

while [[ -n "$USR_INT" ]]; do

    case "$USR_INT" in
        
        1)
            $gmt -wc 1.00,0 $imgfile >/dev/null
		    echo ""
			echo ""
			echo "$imgfile will be visible in Basecamp"
			echo""
            exit 1
            ;;
        *)
            $gmt -wc 1.00,1 $imgfile >/dev/null
			echo""
			echo""
			echo "$imgfile will not be loaded in Basecamp"
			echo""
            exit 1
            ;;
    esac
done
          
	echo ""

