#!/bin/bash
# set -x #echo on

#=====================================================================
#
# Replace .TYP-files in gmapsupp.img image file with GMapTool,
# gmaptool (gmt) is published by www.gmaptool.eu. 
# Only for OpenMTBMap/VeloMap gmapsupp.img country maps.
# Not compatible with new Mac OSx version only supporting 64bit (gmt is only available as 32bit program on Mac, no problem in Linux - so use a virtual machine with linux or another PC if you need it)


# Tool to change the type file including path 
# First Check if we are Using OSx or Linux
if [[ "$OSTYPE" == "linux-gnu" ]] 2>/dev/null; then 
    gmt=./resources/gmt_linux
elif [[ "$OSTYPE" == "darwin"* ]] 2>/dev/null; then
	if [[ "$os_ver" =~ 10.1[56789].* ]]; then
		echo "Note starting from macOS 10.15 or higher - this bash script does not work anymore because it needs 32 bit compatibility"
		echo ""
		echo "Aborting"
		exit
	elif [[ "$os_ver" =~ 1[123456789].* ]]; then
		echo "Note starting from macOS 10.15 or higher - this bash script does not work anymore because it needs 32 bit compatibility"
		echo ""
		echo "Aborting"
		exit
	fi
	gmt=./resources/gmt_osx
elif [[ "$OSTYPE" == "cygwin" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "msys" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "win32" ]] 2>/dev/null; then
    echo "Please use the .cmd script for Windows isntead"
	echo "well if you know why, then hack this script"
	echo "Aborting"
	exit
elif [[ "$OSTYPE" == "freebsd"* ]] 2>/dev/null; then
	echo "gmt is not tested on freebsd - I hope it works"
	gmt=./resources/gmt_linux
elif [ "`uname`" = "Darwin" ] 2>/dev/null; then
	gmt=./resources/gmt_osx
elif [ "`uname`" = "Linux" ] 2>/dev/null; then
    gmt=./resources/gmt_linux
else
    echo "Cannot determine the operating system. Please edit the .sh file to select"
	echo "the correct version of gmt (gmaptool). I do not know if gmt runs on other systems"
	echo "than OSx and Linux"
	echo "This script is made for bash, but can run also on sh (Bourne Shell)"
	echo ""
	echo "Aborting"
	exit
fi
	
# Elevate $gmt to have execute permissions

[ -x $gmt ] && echo "" || chmod u+x $gmt

# Check if gmt is present!
if [ -e $gmt ]; then
		echo ""
		else
		echo "Missing $gmt"
		echo "Cannot continue"
		echo ""
		echo "please do not move the bash file without moving all the files and directory"
		echo "Either missing resources directory - or some of its content"
		echo ""
		exit
	fi
	

		
# Stop if gmapsupp9999.img is found
if [ -f gmapsupp999.img ]
	then
	echo "" 
	echo ""
	echo "" 
	echo ""
	echo "-------------------ERROR-------------"
	echo "The output filename of this script is gmapsupp999.img"
	echo "This script cannot continue as"
	echo "gmapsupp999.img already exists"
	echo "Please delete gmapsupp999.img or move it somewhere else"
	echo ""
	echo "Do not rename - except if you want it to be merged with the other"
	echo "*.img files present in the directory"
	echo "" 
	echo ""
	echo "This script will exit now"
	echo ""
	echo ""
	exit
	fi
	
# Move Basemaps into temp Directory - still missing here.
	if stat --printf='' basemap*.img 2>/dev/null
	then
	echo "Files with basemap in their name will not be input into the gmapsupp.img - as the standard"
	echo "garmin Basemap is conidered superior. If you want them to be included rename basemap_COUNTRY.img to e.g." 
	echo "map_COUNTRY.img and restart the script!"
		if [ ! -d ./temp999 ] 
			then
			mkdir  ./temp999
		fi 
	mv basemap*.img ./temp999/
	fi
	
# Make sure there are more than 2 *.img files present
if [ `ls -1 *.img 2>/dev/null | wc -l ` -eq 0 ];
then
    echo ""
	echo ""
	echo ""
	echo "-------------------ERROR-------------"
	echo ""
	echo ""
	echo "Combine_all_img_files_into_a_single_gmapsupp_img.cmd should not be moved."
	echo "You should simply add the gmapsupp.img files you want to combine all into the"
	echo "current folder. You can rename them to gmapsupp1.img gmapsupp2.img and so on."
	echo ""
	echo "no gmapsuppfile found  - will terminate now"
	echo ""
	if stat --printf='' ./temp999/basemap*.img 2>/dev/null	
	then
	mv ./temp999/basemap*.img ./
	rmdir ./temp999/
	fi
	exit
fi

if [ `ls -1 *.img 2>/dev/null | wc -l ` -eq 1 ];
	then
	echo "" 
	echo ""
	echo "" 
	echo ""
	echo "-------------------ERROR-------------"
	echo ""
	echo "nothing to do - there is only a single gmapsupp.img file present"
	echo "cannot combine a single as it's single"
	echo "Please move more files into this folder so the script can combine them"
	echo "will terminate now"
	if stat --printf='' ./temp999/basemap*.img 2>/dev/null	
	then
	mv ./temp999/basemap*.img ./
	rmdir ./temp999/
	fi
	exit
fi

if [ `ls -1 *.img 2>/dev/null | wc -l ` -gt 1 ];
	then
	echo "This Script combines all gmapsupp.img files inside current directory"
	echo "Into a new gmapsupp.img file"
	echo "This is intended for very old Garmin GPS devices that can only display a single"
	echo "gmapsupp.img file"
	echo "Modern garmin devices (introduced 2010 or later) do not need this"
	echo "as they can display several gmapsupp.img files"
	echo ""
	echo ""
	echo "Due to FAT32 size limitations - the max filesize for the gmapsupp.img is 4GB"
	echo "Attention this script does not check the size and will combine all *.img files"
	echo "no matter the final output size"
	echo ""
	echo ""
fi




# Combine all *.img files into one big gmapsupp.img
$gmt -j -i -o gmapsupp999.img -m OpenMTBMap *.img >/dev/null

imgfile=gmapsupp999.img

if [ -f gmapsupp999.img ]
	then
	echo "" 
	echo ""
	echo "" 
	echo ""
	echo "-------------------SUCCESS-------------"
	echo ""
	echo "Combined all *img files found into the new"
	echo ""
	echo "gmapsupp999.img"
	echo ""
	echo ""
	echo ""
	echo ""
	fi


# Move back Basemap files
if stat --printf='' ./temp999/basemap*.img 2>/dev/null	
	then
	mv ./temp999/basemap*.img ./
	rmdir ./temp999/
	fi


# basecamp_readable
echo ""
echo ""
echo "BASECAMP VISIBILITY of $imgfile"
echo ""
echo "- do you want that the gmapsupp.img file to show up for display in Basecamp?"
echo "- note that reading in the map by Basecamp takes some time. "
echo "- Therefore it is off by default now. I recommend you press 0 to exit."
echo "- However it can be useful to some people."
echo "- Press 0 or any other key to keep map invisible to Basecamp. "
echo "- Press 1 to make map readable by Basecamp"

read -n 1 -p "Enter your choice (0,1): 
" USR_INT

while [[ -n "$USR_INT" ]]; do

    case "$USR_INT" in
        
        1)
            $gmt -wc 1.00,0 $imgfile >/dev/null
		    echo ""
			echo ""
			echo "$imgfile will be visible in Basecamp"
			echo""
            exit 1
            ;;
        *)
            $gmt -wc 1.00,1 $imgfile >/dev/null
			echo""
			echo""
			echo "$imgfile will not be loaded in Basecamp"
			echo""
            exit 1
            ;;
    esac
done
          
	echo ""

