@echo off
setlocal enabledelayedexpansion
:start0
:: check if gmt.exe and img files are present
if not exist "%~dps0\resources\gmt.exe" goto :error
if not exist "%~dp0*.img" goto :error3

:test_if_gmapsupp999.img exists
if exist "%~dp0gmapsupp999.img" goto error_overwrite

:Test_the_size_sum_of_all_img_files_found_and_move_basemaps_away
if exist "%~dp0tempsize.txt" del "%~dp0tempsize.txt"
if exist "%~dp0basemap*.img" md "%~dp0backup999\" >NUL 2>NUL
if exist "%~dp0basemap*.img" move "%~dp0basemap*.img" "%~dp0backup999\" >NUL 2>NUL
for %%I in (*.img) do @echo %%~zI >>"%~dp0tempsize.txt"
:: type tempsize.txt
set sum=0
for /F "delims=~" %%L in (tempsize.txt) do (
  set val=%%L
  set /A sum += val/1024
)
if exist "%~dp0tempsize.txt" del "%~dp0tempsize.txt"
if %SUM% GTR 4096647 goto :error_too_big


:check_for_minimum_2_img_files
set count=0
for %%x in (*.img) do set /a count+=1
if %count% EQU 1 goto :single_img_file_only



:start
echo.
echo This Script combines all gmapsupp.img files inside current directory
echo Into a new gmapsupp.img file
echo This is intended for very old Garmin GPS devices that can only display a single
echo gmapsupp.img file
echo Modern garmin devices (introduced 2010 or later) do not need this
echo as they can display several gmapsupp.img files
echo.
echo.
if exist "%~dp0backup999\basemap*.img" echo Files with basemap in their name will not be input into the gmapsupp.img - as the standard
if exist "%~dp0backup999\basemap*.img" echo garmin Basemap is considered superior. If you want them to be included rename basemap_COUNTRY.img to e.g. 
if exist "%~dp0backup999\basemap*.img" echo map_COUNTRY.img and restart the script!
if exist "%~dp0backup999\basemap*.img" echo.
if exist "%~dp0backup999\basemap*.img" echo.
if exist "%~dp0backup999\basemap*.img" echo.
echo.
goto :end

:error
echo.
echo.
echo.
echo Requirements:
echo.
echo Combine_all_img_files_into_a_single_gmapsupp_img.cmd should not be moved.
echo You should simply add the gmapsupp.img files you want to combine all into the 
echo current folder. You can rename them to gmapsupp1.img gmapsupp2.img and so on.
echo.
echo gmt.exe needs to be in the /resources subfolder
echo.
echo.
echo.
pause
goto :start0

:end
echo.


:basecamp_readable
set bscamp=0
@echo.
@echo BASECAMP VISIBILITY
@echo - do you want the new combined gmapsupp.img file to show up in Basecamp?
@echo - note that reading in the map by Basecamp takes some time. Therefore it is off by default now. 
@echo - However it can be useful to some.
@echo - Press 0 or any other key to keep map invisible to Basecamp. Press 1 to make map readable by Basecamp
set /p bscamp=0-1:
@echo.
@echo.
"%~dps0resources/gmt.exe" -j -i -o "%~dp0gmapsupp999.img" -m VeloMap "%~dp0*.img" >NUL

if 1 EQU %bscamp% echo gmapsupp999.img will be read in by basecamp.
if 1 EQU %bscamp% set bscampx=0
if 1 NEQ %bscamp% set bscampx=1
if 1 NEQ %bscamp% echo gmapsupp999.img will not be read in by basecamp.
"%~dps0resources/gmt.exe" -wc 1.00,%bscampx% "%~dp0gmapsupp999.img" >NUL
@echo.
@echo.
if 1 EQU %bscamp% timeout 2 >NUL
if 1 NEQ %bscamp% timeout 1 >NUL
echo.
echo.
echo Please copy the new "%~dp0gmapsupp999.img" file to  
echo /garmin folder on the mSD card of your Garmin GPS unit
echo Then rename gmapsupp999.img to gmapsupp.img so it will be found
echo.
echo.
echo.
if exist "%~dp0tempsize.txt" del "%~dp0tempsize.txt" >NUL 2>NUL
if exist "%~dp0backup999\basemap*.img" move "%~dp0backup999\basemap*.img" "%~dp0" >NUL 2>NUL
@RD /S /Q "%~dp0backup999" >NUL 2>NUL
pause
exit


:error3
set str1="%~1"
if not x%str1:.img=%==x%str1% goto :start
if x%str1:.img=%==x%str1% goto :error
@echo on
echo You will need to have the gmapsupp.img Files in the same directory as this batch script
echo Please add the img files to be combined - and restart.
echo.
pause
exit

:error_too_big
echo.
echo This Script cannot continue
echo The combined size of all *.img files may not be higher than 4GB
echo This script is mainly intended for old Garmin GPS devices that only support 
echo a single gmapsupp.img file - as FAT 32 allows a max filesize of 4GB
echo as joining the gmapsupp.img files creates a small overhead - this script
echo only allows ~3.9GB max input size of gmapsupp.img files
echo.
echo.
echo Right now the combined file size of all *.img files present is:
echo %SUM% Kbytes.
echo.
echo.
echo This script will exit now.
if exist "%~dp0tempsize.txt" del "%~dp0tempsize.txt" >NUL 2>NUL
if exist "%~dp0backup999\basemap*.img" move "%~dp0backup999\basemap*.img" "%~dp0" >NUL 2>NUL
@RD /S /Q "%~dp0backup999" >NUL 2>NUL
pause
exit

:single_img_file_only
echo.
echo There is only a single gmapsupp.img file found
echo Cannot combine/join a single file!
echo.
echo.
echo.
echo.
echo This script will exit now.
if exist "%~dp0tempsize.txt" del "%~dp0tempsize.txt" >NUL 2>NUL
if exist "%~dp0backup999\basemap*.img" move "%~dp0backup999\basemap*.img" "%~dp0" >NUL 2>NUL
@RD /S /Q "%~dp0backup999" >NUL 2>NUL
pause
exit

:error_overwrite
echo. 
echo.
echo The output filename of this script is gmapsupp999.img
echo This script cannot continue as
echo gmapsupp999.img already exists
echo Please delete gmapsupp999.img or move it somewhere else
echo. 
echo.
echo This script will continue on key press - make sure to Remove "%~dp0gmapsupp999.img"
echo before continuing
echo.
echo.
pause
goto :start0
